/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.mergeinfo.MergeinfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class BranchInfo {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.mergeinfo.BranchInfo");
    private final Map<String, Set<Long>> myPathMergedMap;
    private final Map<String, Set<Long>> myNonInheritablePathMergedMap;
    private boolean myMixedRevisionsFound;
    private final Map<Long, SvnMergeInfoCache.MergeCheckResult> myAlreadyCalculatedMap;
    private final Object myCalculatedLock = new Object();
    private final String myRepositoryRoot;
    private final String myBranchUrl;
    private final String myTrunkUrl;
    private final String myTrunkCorrected;
    private final SvnVcs myVcs;
    private SvnMergeInfoCache.CopyRevison myCopyRevison;
    private final MultiMap<Long, String> myPartlyMerged;

    public BranchInfo(SvnVcs vcs, String repositoryRoot, String branchUrl, String trunkUrl, String trunkCorrected) {
        this.myVcs = vcs;
        this.myRepositoryRoot = repositoryRoot;
        this.myBranchUrl = branchUrl;
        this.myTrunkUrl = trunkUrl;
        this.myTrunkCorrected = trunkCorrected;
        this.myPathMergedMap = new HashMap<String, Set<Long>>();
        this.myPartlyMerged = new MultiMap();
        this.myNonInheritablePathMergedMap = new HashMap<String, Set<Long>>();
        this.myAlreadyCalculatedMap = new HashMap<Long, SvnMergeInfoCache.MergeCheckResult>();
    }

    private long calculateCopyRevision(String branchPath) {
        if (this.myCopyRevison != null && Comparing.equal((String)this.myCopyRevison.getPath(), (String)branchPath)) {
            return this.myCopyRevison.getRevision();
        }
        this.myCopyRevison = new SvnMergeInfoCache.CopyRevison(this.myVcs, branchPath, this.myRepositoryRoot, this.myBranchUrl, this.myTrunkUrl);
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.myPathMergedMap.clear();
        Object object = this.myCalculatedLock;
        synchronized (object) {
            this.myAlreadyCalculatedMap.clear();
        }
        this.myMixedRevisionsFound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halfClear(long listNumber) {
        this.myPathMergedMap.clear();
        Object object = this.myCalculatedLock;
        synchronized (object) {
            this.myAlreadyCalculatedMap.remove(listNumber);
        }
        this.myMixedRevisionsFound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeinfoCached getCached() {
        Object object = this.myCalculatedLock;
        synchronized (object) {
            long revision = this.myCopyRevison != null && this.myCopyRevison.getRevision() != -1L ? this.myCopyRevison.getRevision() : -1L;
            return new MergeinfoCached(Collections.unmodifiableMap(this.myAlreadyCalculatedMap), revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMergeInfoCache.MergeCheckResult checkList(SvnChangeList list, String branchPath) {
        Object object = this.myCalculatedLock;
        synchronized (object) {
            long revision = this.calculateCopyRevision(branchPath);
            if (revision != -1L && revision >= list.getNumber()) {
                return SvnMergeInfoCache.MergeCheckResult.COMMON;
            }
            SvnMergeInfoCache.MergeCheckResult calculated = this.myAlreadyCalculatedMap.get(list.getNumber());
            if (calculated != null) {
                return calculated;
            }
            SvnMergeInfoCache.MergeCheckResult result = this.checkAlive(list, branchPath);
            this.myAlreadyCalculatedMap.put(list.getNumber(), result);
            return result;
        }
    }

    private SvnMergeInfoCache.MergeCheckResult checkAlive(SvnChangeList list, String branchPath) {
        Info info = this.getInfo(new File(branchPath));
        if (info == null || info.getURL() == null || !SVNPathUtil.isAncestor((String)this.myBranchUrl, (String)info.getURL().toString())) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        String subPathUnderBranch = SVNPathUtil.getRelativePath((String)this.myBranchUrl, (String)info.getURL().toString());
        MultiMap result = new MultiMap();
        this.checkPaths(list.getNumber(), list.getAddedPaths(), branchPath, subPathUnderBranch, (MultiMap<SvnMergeInfoCache.MergeCheckResult, String>)result);
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS)) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        }
        this.checkPaths(list.getNumber(), list.getDeletedPaths(), branchPath, subPathUnderBranch, (MultiMap<SvnMergeInfoCache.MergeCheckResult, String>)result);
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS)) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        }
        this.checkPaths(list.getNumber(), list.getChangedPaths(), branchPath, subPathUnderBranch, (MultiMap<SvnMergeInfoCache.MergeCheckResult, String>)result);
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS)) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        }
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_MERGED)) {
            this.myPartlyMerged.put((Object)list.getNumber(), result.get((Object)SvnMergeInfoCache.MergeCheckResult.NOT_MERGED));
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        return SvnMergeInfoCache.MergeCheckResult.MERGED;
    }

    private void checkPaths(long number, Collection<String> paths, String branchPath, String subPathUnderBranch, MultiMap<SvnMergeInfoCache.MergeCheckResult, String> result) {
        String myTrunkPathCorrespondingToLocalBranchPath = SVNPathUtil.append((String)this.myTrunkCorrected, (String)subPathUnderBranch);
        for (String path : paths) {
            String absoluteInTrunkPath = SVNPathUtil.append((String)this.myRepositoryRoot, (String)path);
            if (!absoluteInTrunkPath.startsWith(myTrunkPathCorrespondingToLocalBranchPath)) {
                result.putValue((Object)SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS, (Object)path);
                continue;
            }
            String relativeToTrunkPath = absoluteInTrunkPath.substring(myTrunkPathCorrespondingToLocalBranchPath.length());
            String localPathInBranch = new File(branchPath, relativeToTrunkPath).getAbsolutePath();
            SvnMergeInfoCache.MergeCheckResult pathResult = this.checkPathGoingUp(number, -1L, branchPath, localPathInBranch, path, true);
            result.putValue((Object)pathResult, (Object)path);
        }
    }

    private SvnMergeInfoCache.MergeCheckResult goUp(long revisionAsked, long targetRevision, String branchRootPath, String path, String trunkUrl) {
        String newTrunkUrl = SVNPathUtil.removeTail((String)trunkUrl).trim();
        if (newTrunkUrl.length() == 0 || "/".equals(newTrunkUrl)) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        String newPath = new File(path).getParent();
        if (newPath.length() < branchRootPath.length()) {
            if (targetRevision == -1L) {
                return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
            }
            Info svnInfo = this.getInfo(new File(branchRootPath));
            if (svnInfo == null || svnInfo.getRevision() == null || svnInfo.getURL() == null) {
                return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            }
            try {
                return this.goUpInRepo(revisionAsked, targetRevision, svnInfo.getURL().removePathTail(), newTrunkUrl);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            }
        }
        return this.checkPathGoingUp(revisionAsked, targetRevision, branchRootPath, newPath, newTrunkUrl, false);
    }

    private SvnMergeInfoCache.MergeCheckResult goUpInRepo(long revisionAsked, long targetRevision, SVNURL branchUrl, String trunkUrl) {
        PropertyValue mergeinfoProperty;
        String branchAsString = branchUrl.toString();
        String keyString = branchAsString + "@" + targetRevision;
        Set<Long> mergeInfo = this.myPathMergedMap.get(keyString);
        if (mergeInfo != null) {
            return SvnMergeInfoCache.MergeCheckResult.getInstance(mergeInfo.contains(revisionAsked));
        }
        SvnTarget target = SvnTarget.fromURL((SVNURL)branchUrl);
        try {
            mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, SVNRevision.create((long)targetRevision));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        if (mergeinfoProperty == null) {
            SVNURL newBranchUrl;
            String newTrunkUrl = SVNPathUtil.removeTail((String)trunkUrl).trim();
            try {
                newBranchUrl = branchUrl.removePathTail();
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            }
            String absoluteTrunk = SVNPathUtil.append((String)this.myRepositoryRoot, (String)newTrunkUrl);
            if (1 >= newTrunkUrl.length() || this.myRepositoryRoot.length() >= newBranchUrl.toString().length() || newBranchUrl.toString().equals(absoluteTrunk)) {
                return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            }
            return this.goUpInRepo(revisionAsked, targetRevision, newBranchUrl, newTrunkUrl);
        }
        return this.processMergeinfoProperty(keyString, revisionAsked, mergeinfoProperty, trunkUrl, false);
    }

    private Info getInfo(File pathFile) {
        return this.myVcs.getInfo(pathFile);
    }

    private SvnMergeInfoCache.MergeCheckResult checkPathGoingUp(long revisionAsked, long targetRevision, String branchRootPath, String path, String trunkUrl, boolean self) {
        PropertyValue mergeinfoProperty;
        File pathFile = new File(path);
        if (targetRevision == -1L && !pathFile.exists()) {
            return this.goUp(revisionAsked, targetRevision, branchRootPath, path, trunkUrl);
        }
        Info svnInfo = this.getInfo(pathFile);
        if (svnInfo == null || svnInfo.getRevision() == null || svnInfo.getURL() == null) {
            LOG.info("Svninfo for " + pathFile + " is null or not full.");
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        long actualRevision = svnInfo.getRevision().getNumber();
        long targetRevisionCorrected = targetRevision == -1L ? actualRevision : targetRevision;
        String keyString = path + "@" + targetRevisionCorrected;
        Set<Long> selfInfo = self ? this.myNonInheritablePathMergedMap.get(keyString) : null;
        Set<Long> mergeInfo = this.myPathMergedMap.get(keyString);
        if (mergeInfo != null || selfInfo != null) {
            boolean merged = mergeInfo != null && mergeInfo.contains(revisionAsked) || selfInfo != null && selfInfo.contains(revisionAsked);
            return SvnMergeInfoCache.MergeCheckResult.getInstance(merged);
        }
        try {
            if (actualRevision == targetRevisionCorrected) {
                SvnTarget target = SvnTarget.fromFile((File)pathFile, (SVNRevision)SVNRevision.WORKING);
                mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, SVNRevision.WORKING);
            } else {
                this.myMixedRevisionsFound = true;
                SvnTarget target = SvnTarget.fromURL((SVNURL)svnInfo.getURL());
                mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, SVNRevision.create((long)targetRevisionCorrected));
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        if (mergeinfoProperty == null) {
            return this.goUp(revisionAsked, targetRevisionCorrected, branchRootPath, path, trunkUrl);
        }
        return this.processMergeinfoProperty(keyString, revisionAsked, mergeinfoProperty, trunkUrl, self);
    }

    private SvnMergeInfoCache.MergeCheckResult processMergeinfoProperty(String pathWithRevisionNumber, long revisionAsked, PropertyValue value, String trunkRelativeUrl, boolean self) {
        Map map;
        String valueAsString = value.toString().trim();
        if (valueAsString.length() == 0) {
            this.myPathMergedMap.put(pathWithRevisionNumber, Collections.emptySet());
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        try {
            map = SVNMergeInfoUtil.parseMergeInfo((StringBuffer)new StringBuffer(this.replaceSeparators(value.toString())), null);
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        for (String key : map.keySet()) {
            if (key == null || !trunkRelativeUrl.startsWith(key)) continue;
            HashSet<Long> revisions = new HashSet<Long>();
            HashSet<Long> nonInheritableRevisions = new HashSet<Long>();
            SVNMergeRangeList rangesList = (SVNMergeRangeList)map.get(key);
            boolean result = false;
            for (SVNMergeRange range : rangesList.getRanges()) {
                boolean inInterval;
                long startRevision = range.getStartRevision() + 1L;
                long endRevision = range.getEndRevision();
                boolean isInheritable = range.isInheritable();
                boolean bl = inInterval = revisionAsked >= startRevision && revisionAsked <= endRevision;
                if ((isInheritable || self) && inInterval) {
                    result = true;
                }
                for (long i = startRevision; i <= endRevision; ++i) {
                    if (isInheritable) {
                        revisions.add(i);
                        continue;
                    }
                    nonInheritableRevisions.add(i);
                }
            }
            this.myPathMergedMap.put(pathWithRevisionNumber, revisions);
            if (!nonInheritableRevisions.isEmpty()) {
                this.myNonInheritablePathMergedMap.put(pathWithRevisionNumber, nonInheritableRevisions);
            }
            return SvnMergeInfoCache.MergeCheckResult.getInstance(result);
        }
        this.myPathMergedMap.put(pathWithRevisionNumber, Collections.emptySet());
        return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
    }

    private String replaceSeparators(String s) {
        return s.replace('\r', '\n').replace("\n\n", "\n");
    }

    public boolean isMixedRevisionsFound() {
        return this.myMixedRevisionsFound;
    }

    public Collection<String> getNotMergedPaths(long number) {
        return this.myPartlyMerged.get((Object)number);
    }
}

