/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.welcome.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.ConfirmFirstRunWizardCloseDialog;
import com.android.tools.idea.welcome.FirstRunWelcomeStep;
import com.android.tools.idea.welcome.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.InstallComponentsPath;
import com.android.tools.idea.welcome.LongRunningOperationPath;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.welcome.SetupJdkPath;
import com.android.tools.idea.welcome.WizardException;
import com.android.tools.idea.wizard.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardHost;
import com.android.tools.idea.wizard.SingleStepPath;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.Multimap;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirstRunWizard
extends DynamicWizard {
    public static final String WIZARD_TITLE = "Android Studio Setup";
    @NotNull
    private final FirstRunWizardMode myMode;
    @Nullable
    private final Multimap<PkgType, RemotePkgInfo> myRemotePackages;
    private final AtomicInteger myFinishClicks;
    private final SetupJdkPath myJdkPath;
    private InstallComponentsPath myComponentsPath;
    private boolean mySetupFailed;

    public FirstRunWizard(@NotNull DynamicWizardHost host, @NotNull FirstRunWizardMode mode, @Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/welcome/FirstRunWizard", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/FirstRunWizard", "<init>"));
        }
        super(null, null, WIZARD_TITLE, host);
        this.myFinishClicks = new AtomicInteger(0);
        this.myMode = mode;
        this.myJdkPath = new SetupJdkPath(mode);
        this.myRemotePackages = remotePackages;
        this.setTitle(WIZARD_TITLE);
    }

    @Override
    public void init() {
        File initialSdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(this.myMode);
        SetupProgressStep progressStep = new SetupProgressStep();
        this.myComponentsPath = new InstallComponentsPath(progressStep, this.myMode, initialSdkLocation, this.myRemotePackages);
        if (this.myMode == FirstRunWizardMode.NEW_INSTALL) {
            boolean sdkExists = initialSdkLocation.isDirectory() && SdkManager.createManager((String)initialSdkLocation.getAbsolutePath(), (ILogger)new NullLogger()) != null;
            this.addPath(new SingleStepPath(new FirstRunWelcomeStep(sdkExists)));
        }
        this.addPath(this.myJdkPath);
        this.addPath(this.myComponentsPath);
        if (this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            this.addPath(new SingleStepPath(new LicenseAgreementStep(this.getDisposable())));
        }
        this.addPath(new SingleStepPath(progressStep));
        super.init();
    }

    @Override
    public boolean canCancel() {
        return AndroidSdkUtils.isAndroidSdkAvailable();
    }

    @Override
    public void doCancelAction() {
        ConfirmFirstRunWizardCloseDialog.Result result = new ConfirmFirstRunWizardCloseDialog().open();
        switch (result) {
            case Skip: {
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.myMode.getInstallerTimestamp());
            }
            case Rerun: {
                this.myHost.close(DynamicWizardHost.CloseAction.CANCEL);
                break;
            }
        }
    }

    @Override
    public void doFinishAction() {
        if (this.mySetupFailed) {
            this.myHost.close(DynamicWizardHost.CloseAction.EXIT);
            return;
        }
        if (this.myFinishClicks.incrementAndGet() == 1) {
            this.doNextAction();
        } else {
            assert (this.myFinishClicks.get() <= 2);
            super.doFinishAction();
        }
    }

    private void doLongRunningOperation(@NotNull ProgressStep progressStep) throws WizardException {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/FirstRunWizard", "doLongRunningOperation"));
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (progressStep.isCanceled()) break;
            if (!(path instanceof LongRunningOperationPath)) continue;
            ((LongRunningOperationPath)((Object)path)).runLongOperation();
        }
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    protected String getWizardActionDescription() {
        return WIZARD_TITLE;
    }

    private class SetupProgressStep
    extends ProgressStep {
        public SetupProgressStep() {
            super(FirstRunWizard.this.getDisposable());
        }

        @Override
        protected void execute() {
            FirstRunWizard.this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

                @Override
                public void run() {
                    try {
                        FirstRunWizard.this.doLongRunningOperation(SetupProgressStep.this);
                    }
                    catch (WizardException e) {
                        Logger.getInstance(this.getClass()).error((Throwable)e);
                        SetupProgressStep.this.showConsole();
                        FirstRunWizard.this.mySetupFailed = true;
                        SetupProgressStep.this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        @Override
        public boolean isStepVisible() {
            return FirstRunWizard.this.myFinishClicks.get() == 1 || !FirstRunWizard.this.myJdkPath.showsStep() && !FirstRunWizard.this.myComponentsPath.showsStep();
        }
    }
}

