/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.Log;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.android.logcat.AndroidConfiguredLogFilters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfiguredFilter {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.logcat.ConfiguredFilter");
    private final String myName;
    private final Pattern myMessagePattern;
    private final Pattern myTagPattern;
    private final Pattern myPkgNamePattern;
    private final String myPid;
    private final Log.LogLevel myLogLevel;

    private ConfiguredFilter(@NotNull String name, @Nullable Pattern messagePattern, @Nullable Pattern tagPattern, @Nullable Pattern pkgNamePattern, @Nullable String pid, @Nullable Log.LogLevel logLevel) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/logcat/ConfiguredFilter", "<init>"));
        }
        this.myName = name;
        this.myMessagePattern = messagePattern;
        this.myTagPattern = tagPattern;
        this.myPkgNamePattern = pkgNamePattern;
        this.myPid = pid;
        this.myLogLevel = logLevel;
    }

    public boolean isApplicable(String message, String tag, String pkg, String pid, Log.LogLevel logLevel) {
        if (!(this.myMessagePattern == null || message != null && this.myMessagePattern.matcher(message).find())) {
            return false;
        }
        if (!(this.myTagPattern == null || tag != null && this.myTagPattern.matcher(tag).find())) {
            return false;
        }
        if (!(this.myPkgNamePattern == null || pkg != null && this.myPkgNamePattern.matcher(pkg).find())) {
            return false;
        }
        if (this.myPid != null && this.myPid.length() > 0 && !this.myPid.equals(pid)) {
            return false;
        }
        return this.myLogLevel == null || logLevel != null && logLevel.getPriority() >= this.myLogLevel.getPriority();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/ConfiguredFilter", "getName"));
        }
        return string;
    }

    @Nullable
    public static ConfiguredFilter compile(@Nullable AndroidConfiguredLogFilters.MyFilterEntry entry, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/logcat/ConfiguredFilter", "compile"));
        }
        if (entry == null) {
            return null;
        }
        Pattern logMessagePattern = ConfiguredFilter.compilePattern(entry.getLogMessagePattern());
        Pattern logTagPattern = ConfiguredFilter.compilePattern(entry.getLogTagPattern());
        Pattern pkgNamePattern = ConfiguredFilter.compilePattern(entry.getPackageNamePattern());
        String pid = entry.getPid();
        Log.LogLevel logLevel = null;
        String logLevelStr = entry.getLogLevel();
        if (logLevelStr != null && logLevelStr.length() > 0) {
            logLevel = Log.LogLevel.getByString((String)logLevelStr);
        }
        return new ConfiguredFilter(name, logMessagePattern, logTagPattern, pkgNamePattern, pid, logLevel);
    }

    private static Pattern compilePattern(String pattern) {
        Pattern p = null;
        if (StringUtil.isNotEmpty((String)pattern)) {
            try {
                p = Pattern.compile(pattern, AndroidConfiguredLogFilters.getPatternCompileFlags(pattern));
            }
            catch (PatternSyntaxException e) {
                LOG.info((Throwable)e);
            }
        }
        return p;
    }
}

