/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.base.Splitter;
import java.io.File;

public class PropertyFileDetector
extends Detector {
    public static final Issue ESCAPE = Issue.create("PropertyEscape", "Incorrect property escapes", "All backslashes and colons in .property files must be escaped with a backslash (\\). This means that when writing a Windows path, you must escape the file separators, so the path \\My\\Files should be written as `key=\\\\My\\\\Files.`", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
    public static final Issue HTTP = Issue.create("UsingHttp", "Using HTTP instead of HTTPS", "The Gradle Wrapper is available both via HTTP and HTTPS. HTTPS is more secure since it protects against man-in-the-middle attacks etc. Older projects created in Android Studio used HTTP but we now default to HTTPS and recommend upgrading existing projects.", Category.SECURITY, 6, Severity.WARNING, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return file.getPath().endsWith(".properties");
    }

    @Override
    public void run(@NonNull Context context) {
        String contents = context.getContents();
        if (contents == null) {
            return;
        }
        int offset = 0;
        for (String line : Splitter.on((char)'\n').split((CharSequence)contents)) {
            int valueStart;
            if (!(line.startsWith("#") || line.startsWith(" ") || line.indexOf(92) == -1 && line.indexOf(58) == -1 || (valueStart = line.indexOf(61) + 1) == 0)) {
                PropertyFileDetector.checkLine(context, contents, line, offset, valueStart);
            }
            offset += line.length() + 1;
        }
    }

    private static void checkLine(@NonNull Context context, @NonNull String contents, @NonNull String line, int offset, int valueStart) {
        String prefix = "distributionUrl=http\\";
        if (line.startsWith(prefix)) {
            String https = "https" + line.substring(prefix.length() - 1);
            String message = String.format("Replace HTTP with HTTPS for better security; use %1$s", https);
            int startOffset = offset + valueStart;
            int endOffset = startOffset + 4;
            Location location = Location.create(context.file, contents, startOffset, endOffset);
            context.report(HTTP, location, message);
        }
        boolean escaped = false;
        boolean hadNonPathEscape = false;
        StringBuilder path = new StringBuilder();
        for (int i = valueStart; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                boolean bl = escaped = !escaped;
                if (!escaped) continue;
                path.append(c);
                continue;
            }
            if (escaped && c != ':') {
                hadNonPathEscape = true;
            }
            escaped = false;
            path.append(c);
        }
        String pathString = path.toString();
        String key = line.substring(0, valueStart);
        if (hadNonPathEscape && key.endsWith(".dir=") || new File(pathString).exists()) {
            String escapedPath = pathString.replace("\\", "\\\\");
            String message = "Windows file separators (`\\`) must be escaped (`\\\\`); use " + escapedPath;
            int startOffset = offset + valueStart;
            int endOffset = offset + line.length();
            Location location = Location.create(context.file, contents, startOffset, endOffset);
            context.report(ESCAPE, location, message);
        }
    }

    @Nullable
    public static String getSuggestedEscape(@NonNull String message, @NonNull TextFormat format) {
        return LintUtils.findSubstring(format.toText(message), "; use ", null);
    }
}

