/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.util.ArrayUtil;
import com.intellij.util.Base64Converter;
import com.intellij.util.PathUtilRt;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;

public class Attachment {
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final byte[] myBytes;
    private boolean myIncluded;
    private final String myDisplayText;

    public Attachment(@NotNull String path, @NotNull String content) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diagnostic/Attachment", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diagnostic/Attachment", "<init>"));
        }
        this.myIncluded = true;
        this.myPath = path;
        this.myDisplayText = content;
        this.myBytes = Attachment.getBytes(content);
    }

    public Attachment(@NotNull String path, @NotNull byte[] bytes, @NotNull String displayText) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diagnostic/Attachment", "<init>"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/diagnostic/Attachment", "<init>"));
        }
        if (displayText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayText", "com/intellij/openapi/diagnostic/Attachment", "<init>"));
        }
        this.myIncluded = true;
        this.myPath = path;
        this.myBytes = bytes;
        this.myDisplayText = displayText;
    }

    @NotNull
    public static byte[] getBytes(@NotNull String content) {
        byte[] byArray;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diagnostic/Attachment", "getBytes"));
        }
        try {
            byArray = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Attachment", "getBytes"));
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Attachment", "getBytes"));
        }
        return byArray;
    }

    @NotNull
    public String getDisplayText() {
        String string = this.myDisplayText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Attachment", "getDisplayText"));
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Attachment", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = PathUtilRt.getFileName(this.myPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Attachment", "getName"));
        }
        return string;
    }

    @NotNull
    public String getEncodedBytes() {
        String string = Base64Converter.encode(this.myBytes);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Attachment", "getEncodedBytes"));
        }
        return string;
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(boolean included) {
        this.myIncluded = included;
    }
}

