/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.AbstractAction;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.config.ImportConfiguration;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsImport.ImportDetails;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.ui.experts.importToCvs.ImportWizard;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;

public class ImportAction
extends ActionOnSelectedElement {
    private ImportDetails myImportDetails;

    public ImportAction() {
        super(false);
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(true);
    }

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.message((String)"operation.name.import", (Object[])new Object[0]);
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        VirtualFile selectedFile = context.getSelectedFile();
        ImportWizard importWizard = new ImportWizard(context.getProject(), selectedFile);
        importWizard.show();
        if (!importWizard.isOK()) {
            return CvsHandler.NULL;
        }
        this.myImportDetails = importWizard.createImportDetails();
        if (this.myImportDetails == null) {
            return CvsHandler.NULL;
        }
        return CommandCvsHandler.createImportHandler(this.myImportDetails);
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        ImportConfiguration importConfiguration = ImportConfiguration.getInstance();
        if (successfully && importConfiguration.CHECKOUT_AFTER_IMPORT) {
            this.createCheckoutAction(importConfiguration.MAKE_NEW_FILES_READ_ONLY).actionPerformed(context);
        }
    }

    private AbstractAction createCheckoutAction(final boolean makeNewFilesReadOnly) {
        return new AbstractAction(false){

            @Override
            protected String getTitle(VcsContext context) {
                return CvsBundle.message((String)"operation.name.check.out.project", (Object[])new Object[0]);
            }

            @Override
            protected CvsHandler getCvsHandler(CvsContext context) {
                Project project = context.getProject();
                return CommandCvsHandler.createCheckoutHandler(ImportAction.this.myImportDetails.getCvsRoot(), new String[]{ImportAction.this.myImportDetails.getModuleName()}, ImportAction.this.myImportDetails.getBaseImportDirectory(), true, makeNewFilesReadOnly, project == null ? null : VcsConfiguration.getInstance((Project)project).getCheckoutOption());
            }

            @Override
            protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
                super.onActionPerformed(context, tabbedWindow, successfully, handler);
                Project project = context.getProject();
                if (successfully && project != null) {
                    VirtualFile importedRoot = CvsVfsUtil.findFileByIoFile(ImportAction.this.myImportDetails.getBaseImportDirectory());
                    this.updateDirectoryMappings(project, importedRoot);
                }
            }

            private void updateDirectoryMappings(Project project, VirtualFile mapRoot) {
                if (project == null || project.isDefault()) {
                    return;
                }
                VirtualFile projectBaseDir = project.getBaseDir();
                if (projectBaseDir == null || !VfsUtil.isAncestor((VirtualFile)projectBaseDir, (VirtualFile)mapRoot, (boolean)false)) {
                    return;
                }
                mapRoot.refresh(false, false);
                String path = mapRoot.equals(projectBaseDir) ? "" : mapRoot.getPath();
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                ArrayList<VcsDirectoryMapping> vcsDirectoryMappings = new ArrayList<VcsDirectoryMapping>(vcsManager.getDirectoryMappings());
                VcsDirectoryMapping mapping = new VcsDirectoryMapping(path, CvsVcs2.getInstance(project).getName());
                for (int i = 0; i < vcsDirectoryMappings.size(); ++i) {
                    VcsDirectoryMapping m = (VcsDirectoryMapping)vcsDirectoryMappings.get(i);
                    if (!m.getDirectory().equals(path)) continue;
                    if (m.getVcs().length() == 0) {
                        vcsDirectoryMappings.set(i, mapping);
                        mapping = null;
                        break;
                    }
                    if (!m.getVcs().equals(mapping.getVcs())) continue;
                    mapping = null;
                    break;
                }
                if (mapping != null) {
                    vcsDirectoryMappings.add(mapping);
                }
                vcsManager.setDirectoryMappings(vcsDirectoryMappings);
                vcsManager.updateActiveVcss();
            }
        };
    }
}

