/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationModule
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.RunConfigurationModule");
    @NonNls
    private static final String ELEMENT = "module";
    @NonNls
    private static final String ATTRIBUTE = "name";
    private Module myModule = null;
    private String myModuleName;
    private final Project myProject;

    public RunConfigurationModule(Project project) {
        this.myProject = project;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element module;
        String moduleName;
        List modules = element.getChildren(ELEMENT);
        LOG.assertTrue(modules.size() <= 1);
        if (modules.size() == 1 && (moduleName = (module = (Element)modules.get(0)).getAttributeValue(ATTRIBUTE)) != null && moduleName.length() > 0) {
            this.myModuleName = moduleName;
        }
    }

    public void writeExternal(Element parent) throws WriteExternalException {
        Element element = new Element(ELEMENT);
        element.setAttribute(ATTRIBUTE, this.getModuleName());
        parent.addContent(element);
    }

    public void init() {
        if (this.getModuleName().trim().length() > 0) {
            return;
        }
        Module[] modules = this.getModuleManager().getModules();
        if (modules.length > 0) {
            this.setModule(modules[0]);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public Module getModule() {
        if (this.myModuleName != null) {
            this.myModule = this.findModule(this.myModuleName);
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModule = null;
        }
        return this.myModule;
    }

    @Nullable
    public Module findModule(final String moduleName) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Module>(){

            @Nullable
            public Module compute() {
                return RunConfigurationModule.this.getModuleManager().findModuleByName(moduleName);
            }
        });
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myModuleName = module != null ? module.getName() : null;
    }

    public String getModuleName() {
        return this.myModuleName != null ? this.myModuleName : "";
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance(this.myProject);
    }

    public void checkForWarning() throws RuntimeConfigurationException {
        Module module = this.getModule();
        if (module != null) {
            if (ModuleRootManager.getInstance(module).getSdk() == null) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message("no.jdk.specified.for.module.warning.text", module.getName()));
            }
        } else {
            if (this.myModuleName != null) {
                throw new RuntimeConfigurationError(ExecutionBundle.message("module.doesn.t.exist.in.project.error.text", this.myModuleName));
            }
            throw new RuntimeConfigurationError(ExecutionBundle.message("module.not.specified.error.text", new Object[0]));
        }
    }
}

