/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.net.ssl.ConfirmingHostnameVerifier;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CertificateManager", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class CertificateManager
implements PersistentStateComponent<Config> {
    @NonNls
    private static final String DEFAULT_PATH = FileUtil.join((String[])new String[]{PathManager.getSystemPath(), "tasks", "cacerts"});
    @NonNls
    private static final String DEFAULT_PASSWORD = "changeit";
    private static final Logger LOG = Logger.getInstance(CertificateManager.class);
    public static final HostnameVerifier HOSTNAME_VERIFIER = new ConfirmingHostnameVerifier(SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    static final long DIALOG_VISIBILITY_TIMEOUT = 5000L;
    private final String myCacertsPath = DEFAULT_PATH;
    private final String myPassword;
    private final Config myConfig = new Config();
    private final ConfirmingTrustManager myTrustManager = ConfirmingTrustManager.createForStorage(this.myCacertsPath, this.myPassword);
    private SSLContext mySslContext;

    public static CertificateManager getInstance() {
        return ServiceManager.getService(CertificateManager.class);
    }

    public CertificateManager() {
        this.myPassword = DEFAULT_PASSWORD;
        this.initComponent();
    }

    public void initComponent() {
        try {
            if (Registry.is((String)"ide.certificate.manager")) {
                SSLContext.setDefault(this.getSslContext());
                LOG.debug("Default SSL context initialized");
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public synchronized SSLContext getSslContext() {
        if (this.mySslContext == null) {
            SSLContext context = CertificateManager.getSystemSslContext();
            if (Registry.is((String)"ide.certificate.manager")) {
                try {
                    context.init(CertificateManager.getDefaultKeyManagers(), new TrustManager[]{this.getTrustManager()}, null);
                }
                catch (KeyManagementException e) {
                    LOG.error((Throwable)e);
                }
            } else {
                context = CertificateManager.getDefaultSslContext();
            }
            this.mySslContext = context;
        }
        SSLContext sSLContext = this.mySslContext;
        if (sSLContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getSslContext"));
        }
        return sSLContext;
    }

    @NotNull
    public static SSLContext getSystemSslContext() {
        SSLContext sSLContext;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            sSLContext = context;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Throwable)e);
            throw new AssertionError((Object)"Cannot get system SSL context");
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
            throw new AssertionError((Object)"Cannot initialize system SSL context");
        }
        if (sSLContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getSystemSslContext"));
        }
        return sSLContext;
    }

    @NotNull
    private static SSLContext getDefaultSslContext() {
        SSLContext sSLContext;
        try {
            sSLContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Default SSL context not available. Using system instead.");
            SSLContext sSLContext2 = CertificateManager.getSystemSslContext();
            if (sSLContext2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getDefaultSslContext"));
            }
            return sSLContext2;
        }
        if (sSLContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getDefaultSslContext"));
        }
        return sSLContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static KeyManager[] getDefaultKeyManagers() {
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        if (keyStorePath == null) return null;
        LOG.info("Loading custom key store specified with VM options: " + keyStorePath);
        try {
            KeyStore keyStore;
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
            try {
                keyStore = KeyStore.getInstance(keyStoreType);
            }
            catch (KeyStoreException e) {
                if (!(e.getCause() instanceof NoSuchAlgorithmException)) throw e;
                LOG.error("Wrong key store type: " + keyStoreType, (Throwable)e);
                return null;
            }
            String password = System.getProperty("javax.net.ssl.keyStorePassword", "");
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(keyStorePath);
                keyStore.load(inputStream, password.toCharArray());
                factory.init(keyStore, password.toCharArray());
            }
            catch (FileNotFoundException e) {
                LOG.error("Key store file not found: " + keyStorePath);
                KeyManager[] keyManagerArray = null;
                {
                    catch (Throwable throwable) {
                        StreamUtil.closeStream(inputStream);
                        throw throwable;
                    }
                }
                StreamUtil.closeStream((Closeable)inputStream);
                return keyManagerArray;
                catch (Exception e2) {
                    block11: {
                        if (!(e2.getCause() instanceof BadPaddingException)) break block11;
                        LOG.error("Wrong key store password: " + password, (Throwable)e2);
                        KeyManager[] keyManagerArray2 = null;
                        StreamUtil.closeStream((Closeable)inputStream);
                        return keyManagerArray2;
                    }
                    throw e2;
                }
            }
            StreamUtil.closeStream((Closeable)inputStream);
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    public String getCacertsPath() {
        String string = this.myCacertsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getCacertsPath"));
        }
        return string;
    }

    @NotNull
    public String getPassword() {
        String string = this.myPassword;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getPassword"));
        }
        return string;
    }

    @NotNull
    public ConfirmingTrustManager getTrustManager() {
        ConfirmingTrustManager confirmingTrustManager = this.myTrustManager;
        if (confirmingTrustManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getTrustManager"));
        }
        return confirmingTrustManager;
    }

    @NotNull
    public ConfirmingTrustManager.MutableTrustManager getCustomTrustManager() {
        ConfirmingTrustManager.MutableTrustManager mutableTrustManager = this.myTrustManager.getCustomManager();
        if (mutableTrustManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getCustomTrustManager"));
        }
        return mutableTrustManager;
    }

    public static boolean showAcceptDialog(final @NotNull Callable<? extends DialogWrapper> dialogFactory) {
        if (dialogFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialogFactory", "com/intellij/util/net/ssl/CertificateManager", "showAcceptDialog"));
        }
        Application app = ApplicationManager.getApplication();
        final CountDownLatch proceeded = new CountDownLatch(1);
        final AtomicBoolean accepted = new AtomicBoolean();
        final AtomicReference dialogRef = new AtomicReference();
        Runnable showDialog = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (proceeded.getCount() == 0L) {
                    return;
                }
                try {
                    DialogWrapper dialog = (DialogWrapper)dialogFactory.call();
                    dialogRef.set(dialog);
                    accepted.set(dialog.showAndGet());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    proceeded.countDown();
                }
            }
        };
        if (app.isDispatchThread()) {
            showDialog.run();
        } else {
            app.invokeLater(showDialog, ModalityState.any());
        }
        try {
            boolean inTime = proceeded.await(5000L, TimeUnit.MILLISECONDS);
            if (!inTime) {
                DialogWrapper dialog = (DialogWrapper)dialogRef.get();
                if (dialog == null || !dialog.isShowing()) {
                    LOG.debug("After 5000 ms dialog was not shown. Rejecting certificate. Current thread: " + Thread.currentThread().getName());
                    proceeded.countDown();
                    return false;
                }
                proceeded.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            proceeded.countDown();
        }
        return accepted.get();
    }

    @Override
    @NotNull
    public Config getState() {
        Config config = this.myConfig;
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateManager", "getState"));
        }
        return config;
    }

    @Override
    public void loadState(Config state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myConfig);
    }

    public static class Config {
        public boolean CHECK_HOSTNAME = false;
        public boolean CHECK_VALIDITY = false;
        @Tag(value="expired")
        @Property(surroundWithTag=false)
        @AbstractCollection(elementTag="commonName")
        public LinkedHashSet<String> BROKEN_CERTIFICATES = new LinkedHashSet();
        public boolean ACCEPT_AUTOMATICALLY = false;
    }
}

