/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.states;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.execution.junit2.states.ReadableState;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.ui.ConsoleViewContentType;

public class IgnoredState
extends ReadableState {
    private TestProxy myPeformedTest;
    private String myIgnoredMessage;
    private String myMessage;
    private String myStackTrace;

    @Override
    public void initializeFrom(ObjectReader reader) {
        this.myPeformedTest = reader.readObject();
        this.myIgnoredMessage = reader.readLimitedString();
        this.myMessage = reader.readLimitedString();
        this.myStackTrace = reader.readLimitedString();
    }

    public void printOn(Printer printer) {
        String parentName = this.myPeformedTest.getParent() == null ? this.myPeformedTest.getInfo().getComment() : this.myPeformedTest.getParent().toString();
        String message = ExecutionBundle.message((String)"junit.runing.info.ignored.console.message", (Object[])new Object[]{parentName, this.myPeformedTest.getInfo().getName()});
        printer.print(message + (this.myIgnoredMessage.length() > 0 ? " (" + this.myIgnoredMessage + ")" : "") + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        if (this.myMessage.length() > 0) {
            printer.print(this.myMessage + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        if (this.myStackTrace.length() > 0) {
            printer.print(this.myStackTrace + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }
}

