/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRootsHandler
implements AbstractVcs.RootsConvertor {
    private final Project myProject;

    public HgRootsHandler(Project project) {
        this.myProject = project;
    }

    public static HgRootsHandler getInstance(Project project) {
        return (HgRootsHandler)ServiceManager.getService((Project)project, HgRootsHandler.class);
    }

    public List<VirtualFile> convertRoots(List<VirtualFile> original) {
        THashSet result = new THashSet(original.size());
        for (VirtualFile vf : original) {
            VirtualFile root = this.convertRoot(vf);
            if (root == null) continue;
            result.add(root);
        }
        return new ArrayList<VirtualFile>((Collection<VirtualFile>)result);
    }

    @Nullable
    public VirtualFile getRootFor(VirtualFile file) {
        return this.convertRoot(VcsUtil.getVcsRootFor((Project)this.myProject, (VirtualFile)file));
    }

    @Nullable
    public VirtualFile getRootFor(FilePath filepath) {
        return this.convertRoot(VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filepath));
    }

    @Nullable
    private VirtualFile convertRoot(@Nullable VirtualFile root) {
        return HgUtil.getHgRootOrNull(this.myProject, root);
    }
}

