/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.common.RationalNumberUtilities;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.util.Debug;

public class FieldTypeRational
extends FieldType {
    public FieldTypeRational(int type, String name) {
        super(type, 8, name);
    }

    @Override
    public Object getSimpleValue(TiffField entry) {
        if (entry.length == 1) {
            return this.convertByteArrayToRational(this.name + " (" + entry.tagInfo.name + ")", entry.oversizeValue, entry.byteOrder);
        }
        return this.convertByteArrayToRationalArray(this.name + " (" + entry.tagInfo.name + ")", this.getRawBytes(entry), 0, entry.length, entry.byteOrder);
    }

    @Override
    public byte[] writeData(Object o, int byteOrder) throws ImageWriteException {
        if (o instanceof RationalNumber) {
            return this.convertRationalToByteArray((RationalNumber)o, byteOrder);
        }
        if (o instanceof RationalNumber[]) {
            return this.convertRationalArrayToByteArray((RationalNumber[])o, byteOrder);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            RationalNumber rationalNumber = RationalNumberUtilities.getRationalNumber(number.doubleValue());
            return this.convertRationalToByteArray(rationalNumber, byteOrder);
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            RationalNumber[] rationalNumbers = new RationalNumber[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                Number number = numbers[i];
                rationalNumbers[i] = RationalNumberUtilities.getRationalNumber(number.doubleValue());
            }
            return this.convertRationalArrayToByteArray(rationalNumbers, byteOrder);
        }
        if (o instanceof double[]) {
            double[] numbers = (double[])o;
            RationalNumber[] rationalNumbers = new RationalNumber[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                double number = numbers[i];
                rationalNumbers[i] = RationalNumberUtilities.getRationalNumber(number);
            }
            return this.convertRationalArrayToByteArray(rationalNumbers, byteOrder);
        }
        throw new ImageWriteException("Invalid data: " + o + " (" + Debug.getType(o) + ")");
    }

    public byte[] writeData(int numerator, int denominator, int byteOrder) throws ImageWriteException {
        return this.writeData(new int[]{numerator}, new int[]{denominator}, byteOrder);
    }

    public byte[] writeData(int[] numerators, int[] denominators, int byteOrder) throws ImageWriteException {
        return this.convertIntArrayToRationalArray(numerators, denominators, byteOrder);
    }
}

