/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.desktop.kde;

import com.btr.proxy.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

class KdeSettingsParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties parseSettings() throws IOException {
        File settingsFile = this.findSettingsFile();
        if (settingsFile == null) {
            return null;
        }
        BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(settingsFile)));
        Properties result = new Properties();
        try {
            String line = fin.readLine();
            while (line != null && !"[Proxy Settings]".equals(line.trim())) {
                line = fin.readLine();
            }
            if (line == null) {
                Properties properties = result;
                return properties;
            }
            line = "";
            while (line != null && !line.trim().startsWith("[")) {
                int index = (line = line.trim()).indexOf(61);
                if (index > 0) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    result.setProperty(key, value);
                }
                line = fin.readLine();
            }
        }
        finally {
            fin.close();
        }
        return result;
    }

    private File findSettingsFile() {
        File userDir = new File(System.getProperty("user.home"));
        File settingsFile = new File(userDir, ".kde" + File.separator + "share" + File.separator + "config" + File.separator + "kioslaverc");
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Searching Kde settings in {0}", settingsFile);
        if (!settingsFile.exists()) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Settings not found", new Object[0]);
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Settings found", new Object[0]);
        return settingsFile;
    }
}

