/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import org.gradle.api.Incubating;

@Incubating
public class ModelPath {
    public static final String SEPARATOR = ".";
    private final String path;

    public ModelPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelPath modelPath = (ModelPath)o;
        return this.path.equals(modelPath.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    public static ModelPath path(String path) {
        return new ModelPath(path);
    }

    public ModelPath child(String child) {
        return ModelPath.path(this.path + SEPARATOR + child);
    }

    public ModelPath getParent() {
        int lastIndex = this.path.lastIndexOf(SEPARATOR);
        if (lastIndex == -1) {
            return null;
        }
        return ModelPath.path(this.path.substring(0, lastIndex));
    }

    public String getName() {
        int lastIndex = this.path.lastIndexOf(SEPARATOR);
        if (lastIndex == -1) {
            return this.path;
        }
        return this.path.substring(lastIndex + 1);
    }

    public boolean isDirectChild(ModelPath other) {
        ModelPath otherParent = other.getParent();
        return otherParent == null ? false : otherParent.equals(this);
    }
}

