/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.AbstractShowPropertiesDiffAction;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

class SvnChangeProviderContext
implements StatusReceiver {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.SvnChangeProviderContext");
    private final ChangelistBuilder myChangelistBuilder;
    private List<SvnChangedFile> myCopiedFiles = null;
    private final List<SvnChangedFile> myDeletedFiles = new ArrayList<SvnChangedFile>();
    private final Map<String, Status> myTreeConflicted;
    private Map<FilePath, String> myCopyFromURLs = null;
    private final SvnVcs myVcs;
    private final SvnBranchConfigurationManager myBranchConfigurationManager;
    private final List<File> filesToRefresh = ContainerUtil.newArrayList();
    private final ProgressIndicator myProgress;

    public SvnChangeProviderContext(SvnVcs vcs, ChangelistBuilder changelistBuilder, ProgressIndicator progress) {
        this.myVcs = vcs;
        this.myChangelistBuilder = changelistBuilder;
        this.myProgress = progress;
        this.myTreeConflicted = new HashMap<String, Status>();
        this.myBranchConfigurationManager = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject());
    }

    @Override
    public void process(FilePath path, Status status) throws SVNException {
        this.processStatusFirstPass(path, status);
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
        this.myChangelistBuilder.processIgnoredFile(vFile);
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
        this.myChangelistBuilder.processUnversionedFile(vFile);
    }

    @Override
    public void processCopyRoot(VirtualFile file, SVNURL url, WorkingCopyFormat format, SVNURL rootURL) {
    }

    @Override
    public void bewareRoot(VirtualFile vf, SVNURL url) {
    }

    @Override
    public void finish() {
        LocalFileSystem.getInstance().refreshIoFiles(this.filesToRefresh, true, false, null);
    }

    public ChangelistBuilder getBuilder() {
        return this.myChangelistBuilder;
    }

    public void reportTreeConflict(Status status) {
        this.myTreeConflicted.put(status.getFile().getAbsolutePath(), status);
    }

    @Nullable
    public Status getTreeConflictStatus(File file) {
        return this.myTreeConflicted.get(file.getAbsolutePath());
    }

    @NotNull
    public List<SvnChangedFile> getCopiedFiles() {
        if (this.myCopiedFiles == null) {
            List<SvnChangedFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getCopiedFiles"));
            }
            return list;
        }
        List<SvnChangedFile> list = this.myCopiedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getCopiedFiles"));
        }
        return list;
    }

    public List<SvnChangedFile> getDeletedFiles() {
        return this.myDeletedFiles;
    }

    public boolean isDeleted(FilePath path) {
        for (SvnChangedFile deletedFile : this.myDeletedFiles) {
            if (!Comparing.equal((Object)path, (Object)deletedFile.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public boolean isCanceled() {
        return this.myProgress != null && this.myProgress.isCanceled();
    }

    @Nullable
    public String getParentCopyFromURL(FilePath filePath) {
        if (this.myCopyFromURLs == null) {
            return null;
        }
        StringBuilder relPathBuilder = new StringBuilder();
        while (filePath != null) {
            String copyFromURL = this.myCopyFromURLs.get(filePath);
            if (copyFromURL != null) {
                return copyFromURL + relPathBuilder.toString();
            }
            relPathBuilder.insert(0, "/" + filePath.getName());
            filePath = filePath.getParentPath();
        }
        return null;
    }

    public void addCopiedFile(FilePath filePath, Status status, String copyFromURL) {
        if (this.myCopiedFiles == null) {
            this.myCopiedFiles = new ArrayList<SvnChangedFile>();
        }
        this.myCopiedFiles.add(new SvnChangedFile(filePath, status, copyFromURL));
        String url = status.getCopyFromURL();
        if (url != null) {
            this.addCopyFromURL(filePath, url);
        }
    }

    public void addCopyFromURL(FilePath filePath, String url) {
        if (this.myCopyFromURLs == null) {
            this.myCopyFromURLs = new HashMap<FilePath, String>();
        }
        this.myCopyFromURLs.put(filePath, url);
    }

    void processStatusFirstPass(FilePath filePath, Status status) throws SVNException {
        Lock lock;
        if (status == null) {
            return;
        }
        if (status.getRemoteLock() != null) {
            lock = status.getRemoteLock();
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), new LogicalLock(false, lock.getOwner(), lock.getComment(), lock.getCreationDate(), lock.getExpirationDate()));
        }
        if (status.getLocalLock() != null) {
            lock = status.getLocalLock();
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), new LogicalLock(true, lock.getOwner(), lock.getComment(), lock.getCreationDate(), lock.getExpirationDate()));
        }
        if (filePath.isDirectory() && status.isLocked()) {
            this.myChangelistBuilder.processLockedFolder(filePath.getVirtualFile());
        }
        if ((status.is(StatusType.STATUS_ADDED) || StatusType.STATUS_MODIFIED.equals((Object)status.getNodeStatus())) && status.getCopyFromURL() != null) {
            this.addCopiedFile(filePath, status, status.getCopyFromURL());
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.myDeletedFiles.add(new SvnChangedFile(filePath, status));
        } else {
            String parentCopyFromURL = this.getParentCopyFromURL(filePath);
            if (parentCopyFromURL != null) {
                this.addCopiedFile(filePath, status, parentCopyFromURL);
            } else {
                this.processStatus(filePath, status);
            }
        }
    }

    void processStatus(FilePath filePath, Status status) throws SVNException {
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(filePath.getIOFile());
        if (!WorkingCopyFormat.UNKNOWN.equals((Object)format) && format.less(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            this.loadEntriesFile(filePath);
        }
        if (status != null) {
            FileStatus fStatus = SvnStatusConvertor.convertStatus(status);
            StatusType statusType = status.getContentsStatus();
            StatusType propStatus = status.getPropertiesStatus();
            if (status.is(StatusType.STATUS_UNVERSIONED, StatusType.UNKNOWN)) {
                VirtualFile file = filePath.getVirtualFile();
                if (file != null) {
                    this.myChangelistBuilder.processUnversionedFile(file);
                }
            } else if (status.is(StatusType.STATUS_ADDED)) {
                this.myChangelistBuilder.processChangeInList(this.createChange(null, CurrentContentRevision.create((FilePath)filePath), fStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
            } else if (status.is(StatusType.STATUS_CONFLICTED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED) || propStatus == StatusType.STATUS_MODIFIED || propStatus == StatusType.STATUS_CONFLICTED) {
                this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), fStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                this.checkSwitched(filePath, this.myChangelistBuilder, status, fStatus);
            } else if (status.is(StatusType.STATUS_DELETED)) {
                this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), null, fStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
            } else if (status.is(StatusType.STATUS_MISSING)) {
                this.myChangelistBuilder.processLocallyDeletedFile(this.createLocallyDeletedChange(filePath, status));
            } else if (status.is(StatusType.STATUS_IGNORED)) {
                if (filePath.getVirtualFile() == null) {
                    filePath.hardRefresh();
                }
                if (filePath.getVirtualFile() == null) {
                    LOG.error("No virtual file for ignored file: " + filePath.getPresentableUrl() + ", isNonLocal: " + filePath.isNonLocal());
                } else if (!this.myVcs.isWcRoot(filePath)) {
                    this.myChangelistBuilder.processIgnoredFile(filePath.getVirtualFile());
                }
            } else if (!(status.isCopied() || fStatus != FileStatus.NOT_CHANGED && fStatus != FileStatus.SWITCHED || statusType == StatusType.STATUS_NONE)) {
                VirtualFile file = filePath.getVirtualFile();
                if (file != null && FileDocumentManager.getInstance().isFileModified(file)) {
                    this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                } else if (status.getTreeConflict() != null) {
                    this.myChangelistBuilder.processChange(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnVcs.getKey());
                }
                this.checkSwitched(filePath, this.myChangelistBuilder, status, fStatus);
            }
        }
    }

    public void addModifiedNotSavedChange(VirtualFile file) throws SVNException {
        FilePathImpl filePath = new FilePathImpl(file);
        Info svnInfo = this.myVcs.getInfo(file);
        if (svnInfo != null) {
            Status svnStatus = new Status();
            svnStatus.setRevision(svnInfo.getRevision());
            this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, (FilePath)filePath, svnInfo.getRevision()), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, svnStatus), (String)null, SvnVcs.getKey());
        }
    }

    private void checkSwitched(FilePath filePath, ChangelistBuilder builder, Status status, FileStatus convertedStatus) {
        if (status.isSwitched() || convertedStatus == FileStatus.SWITCHED) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            String switchUrl = status.getURL().toString();
            VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsRootFor(virtualFile);
            if (vcsRoot != null) {
                String baseUrl = null;
                try {
                    baseUrl = this.myBranchConfigurationManager.get(vcsRoot).getBaseName(switchUrl);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
                builder.processSwitchedFile(virtualFile, baseUrl == null ? switchUrl : baseUrl, true);
            }
        }
    }

    private void loadEntriesFile(FilePath filePath) {
        FilePath parentPath = filePath.getParentPath();
        if (parentPath == null) {
            return;
        }
        this.refreshDotSvnAndEntries(parentPath);
        if (filePath.isDirectory()) {
            this.refreshDotSvnAndEntries(filePath);
        }
    }

    private void refreshDotSvnAndEntries(FilePath filePath) {
        File svn = new File(filePath.getPath(), SvnUtil.SVN_ADMIN_DIR_NAME);
        this.filesToRefresh.add(svn);
        this.filesToRefresh.add(new File(svn, "entries"));
    }

    Change createMovedChange(ContentRevision before, ContentRevision after, Status copiedStatus, Status deletedStatus) throws SVNException {
        ConflictedSvnChange conflictedSvnChange = new ConflictedSvnChange(before, after, ConflictState.mergeState(this.getState(copiedStatus), this.getState(deletedStatus)), copiedStatus != null && copiedStatus.getTreeConflict() != null ? after.getFile() : before.getFile());
        if (deletedStatus != null) {
            conflictedSvnChange.setBeforeDescription(deletedStatus.getTreeConflict());
        }
        if (copiedStatus != null) {
            conflictedSvnChange.setAfterDescription(copiedStatus.getTreeConflict());
        }
        return this.patchWithPropertyChange(conflictedSvnChange, copiedStatus, deletedStatus);
    }

    private Change createChange(ContentRevision before, ContentRevision after, FileStatus fStatus, Status svnStatus) throws SVNException {
        ConflictedSvnChange conflictedSvnChange = new ConflictedSvnChange(before, after, this.correctContentsStatus(fStatus, svnStatus), this.getState(svnStatus), after == null ? before.getFile() : after.getFile());
        if (svnStatus != null) {
            if (StatusType.STATUS_DELETED.equals((Object)svnStatus.getNodeStatus()) && !svnStatus.getRevision().isValid()) {
                conflictedSvnChange.setIsPhantom(true);
            }
            conflictedSvnChange.setBeforeDescription(svnStatus.getTreeConflict());
        }
        return this.patchWithPropertyChange(conflictedSvnChange, svnStatus, null);
    }

    private FileStatus correctContentsStatus(FileStatus fs, Status svnStatus) throws SVNException {
        return fs;
    }

    private LocallyDeletedChange createLocallyDeletedChange(@NotNull FilePath filePath, Status status) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createLocallyDeletedChange"));
        }
        return new SvnLocallyDeletedChange(filePath, this.getState(status));
    }

    private Change patchWithPropertyChange(Change change, Status svnStatus, Status deletedStatus) throws SVNException {
        if (svnStatus == null) {
            return change;
        }
        StatusType propertiesStatus = svnStatus.getPropertiesStatus();
        if (StatusType.STATUS_CONFLICTED.equals((Object)propertiesStatus) || StatusType.CHANGED.equals((Object)propertiesStatus) || StatusType.STATUS_ADDED.equals((Object)propertiesStatus) || StatusType.STATUS_DELETED.equals((Object)propertiesStatus) || StatusType.STATUS_MODIFIED.equals((Object)propertiesStatus) || StatusType.STATUS_REPLACED.equals((Object)propertiesStatus) || StatusType.MERGED.equals((Object)propertiesStatus)) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            File ioFile = path.getIOFile();
            File beforeFile = deletedStatus != null ? deletedStatus.getFile() : ioFile;
            String beforeList = StatusType.STATUS_ADDED.equals((Object)propertiesStatus) && deletedStatus == null ? null : AbstractShowPropertiesDiffAction.getPropertyList(this.myVcs, beforeFile, SVNRevision.BASE);
            String afterList = StatusType.STATUS_DELETED.equals((Object)propertiesStatus) ? null : AbstractShowPropertiesDiffAction.getPropertyList(this.myVcs, ioFile, SVNRevision.WORKING);
            String beforeRevisionNu = change.getBeforeRevision() == null ? null : change.getBeforeRevision().getRevisionNumber().asString();
            String afterRevisionNu = change.getAfterRevision() == null ? null : change.getAfterRevision().getRevisionNumber().asString();
            Change propertyChange = new Change((ContentRevision)(beforeList == null ? null : new SimpleContentRevision(beforeList, path, beforeRevisionNu)), (ContentRevision)(afterList == null ? null : new SimpleContentRevision(afterList, path, afterRevisionNu)), deletedStatus != null ? FileStatus.MODIFIED : SvnStatusConvertor.convertPropertyStatus(propertiesStatus));
            change.addAdditionalLayerElement("Property", propertyChange);
        }
        return change;
    }

    private ConflictState getState(@Nullable Status svnStatus) {
        boolean propertyConflict;
        if (svnStatus == null) {
            return ConflictState.none;
        }
        StatusType propertiesStatus = svnStatus.getPropertiesStatus();
        boolean treeConflict = svnStatus.getTreeConflict() != null;
        boolean textConflict = StatusType.STATUS_CONFLICTED == svnStatus.getContentsStatus();
        boolean bl = propertyConflict = StatusType.STATUS_CONFLICTED == propertiesStatus;
        if (treeConflict) {
            this.reportTreeConflict(svnStatus);
        }
        return ConflictState.getInstance(treeConflict, textConflict, propertyConflict);
    }
}

