/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdMergeClient
extends BaseSvnClient
implements MergeClient {
    @Override
    public void merge(@NotNull SvnTarget source, @NotNull File destination, boolean dryRun, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        this.assertUrl(source);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CmdMergeClient.fillParameters(parameters, destination, null, dryRun, false, false, true, diffOptions);
        this.run(destination, handler, parameters);
    }

    @Override
    public void merge(@NotNull SvnTarget source, @NotNull SVNRevisionRange range, @NotNull File destination, @Nullable Depth depth, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        this.assertUrl(source);
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("--revision");
        parameters.add(range.getStartRevision() + ":" + range.getEndRevision());
        CommandUtil.put(parameters, source);
        CmdMergeClient.fillParameters(parameters, destination, depth, dryRun, recordOnly, force, false, diffOptions);
        this.run(destination, handler, parameters);
    }

    @Override
    public void merge(@NotNull SvnTarget source1, @NotNull SvnTarget source2, @NotNull File destination, @Nullable Depth depth, boolean useAncestry, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source1", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        if (source2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source2", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "merge"));
        }
        this.assertUrl(source1);
        this.assertUrl(source2);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source1);
        CommandUtil.put(parameters, source2);
        CmdMergeClient.fillParameters(parameters, destination, depth, dryRun, recordOnly, force, false, diffOptions);
        CommandUtil.put(parameters, !useAncestry, "--ignore-ancestry");
        this.run(destination, handler, parameters);
    }

    private static void fillParameters(@NotNull List<String> parameters, @NotNull File destination, @Nullable Depth depth, boolean dryRun, boolean recordOnly, boolean force, boolean reintegrate, @Nullable DiffOptions diffOptions) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "fillParameters"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/integrate/CmdMergeClient", "fillParameters"));
        }
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, diffOptions);
        CommandUtil.put(parameters, dryRun, "--dry-run");
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, force, "--force");
        CommandUtil.put(parameters, recordOnly, "--record-only");
        parameters.add("--accept");
        parameters.add("postpone");
        CommandUtil.put(parameters, reintegrate, "--reintegrate");
    }

    private void run(File destination, ProgressTracker handler, List<String> parameters) throws VcsException {
        BaseUpdateCommandListener listener = new BaseUpdateCommandListener(CommandUtil.correctUpToExistingParent(destination), handler);
        this.execute(this.myVcs, SvnTarget.fromFile((File)destination), SvnCommandName.merge, parameters, listener);
        listener.throwWrappedIfException();
    }
}

