/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;

@State(name="MavenImportPreferences", storages={@Storage(file="$WORKSPACE_FILE$")})
public class MavenWorkspaceSettingsComponent
implements PersistentStateComponent<MavenWorkspaceSettings> {
    private MavenWorkspaceSettings mySettings = new MavenWorkspaceSettings();
    private final Project myProject;

    public MavenWorkspaceSettingsComponent(Project project) {
        this.myProject = project;
    }

    public static MavenWorkspaceSettingsComponent getInstance(Project project) {
        return (MavenWorkspaceSettingsComponent)ServiceManager.getService((Project)project, MavenWorkspaceSettingsComponent.class);
    }

    @NotNull
    public MavenWorkspaceSettings getState() {
        MavenExplicitProfiles profiles = MavenProjectsManager.getInstance(this.myProject).getExplicitProfiles();
        this.mySettings.setEnabledProfiles(profiles.getEnabledProfiles());
        this.mySettings.setDisabledProfiles(profiles.getDisabledProfiles());
        MavenWorkspaceSettings mavenWorkspaceSettings = this.mySettings;
        if (mavenWorkspaceSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent", "getState"));
        }
        return mavenWorkspaceSettings;
    }

    public void loadState(MavenWorkspaceSettings state) {
        this.mySettings = state;
    }

    public MavenWorkspaceSettings getSettings() {
        return this.mySettings;
    }
}

