/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.maven.wagon.providers.http.commons.logging.Log;
import org.apache.maven.wagon.providers.http.commons.logging.LogFactory;
import org.apache.maven.wagon.providers.http.httpclient.ConnectionReuseStrategy;
import org.apache.maven.wagon.providers.http.httpclient.HttpClientConnection;
import org.apache.maven.wagon.providers.http.httpclient.HttpEntity;
import org.apache.maven.wagon.providers.http.httpclient.HttpException;
import org.apache.maven.wagon.providers.http.httpclient.HttpHost;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequest;
import org.apache.maven.wagon.providers.http.httpclient.HttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.annotation.Immutable;
import org.apache.maven.wagon.providers.http.httpclient.client.config.RequestConfig;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.CloseableHttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpExecutionAware;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpRequestWrapper;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpUriRequest;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.HttpClientContext;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestClientConnControl;
import org.apache.maven.wagon.providers.http.httpclient.conn.ConnectionKeepAliveStrategy;
import org.apache.maven.wagon.providers.http.httpclient.conn.ConnectionRequest;
import org.apache.maven.wagon.providers.http.httpclient.conn.HttpClientConnectionManager;
import org.apache.maven.wagon.providers.http.httpclient.conn.routing.HttpRoute;
import org.apache.maven.wagon.providers.http.httpclient.impl.conn.ConnectionShutdownException;
import org.apache.maven.wagon.providers.http.httpclient.impl.execchain.ClientExecChain;
import org.apache.maven.wagon.providers.http.httpclient.impl.execchain.ConnectionHolder;
import org.apache.maven.wagon.providers.http.httpclient.impl.execchain.Proxies;
import org.apache.maven.wagon.providers.http.httpclient.impl.execchain.RequestAbortedException;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpRequestExecutor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.ImmutableHttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestContent;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestTargetHost;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestUserAgent;
import org.apache.maven.wagon.providers.http.httpclient.util.Args;
import org.apache.maven.wagon.providers.http.httpclient.util.VersionInfo;

@Immutable
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(connManager, "Client connection manager");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "org.apache.maven.wagon.providers.http.httpclient.client", this.getClass())));
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        ConnectionRequest connRequest = this.connManager.requestConnection(route, null);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config = context.getRequestConfig();
        try {
            int timeout = config.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        ConnectionHolder releaseTrigger = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            URI uri;
            int timeout;
            if (execAware != null) {
                if (execAware.isAborted()) {
                    releaseTrigger.close();
                    throw new RequestAbortedException("Request aborted");
                }
                execAware.setCancellable(releaseTrigger);
            }
            if (!managedConn.isOpen()) {
                timeout = config.getConnectTimeout();
                this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, context);
                this.connManager.routeComplete(managedConn, route, context);
            }
            if ((timeout = config.getSocketTimeout()) >= 0) {
                managedConn.setSocketTimeout(timeout);
            }
            HttpHost target = null;
            HttpRequest original = request.getOriginal();
            if (original instanceof HttpUriRequest && (uri = ((HttpUriRequest)original).getURI()).isAbsolute()) {
                target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            if (target == null) {
                target = route.getTargetHost();
            }
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.request", request);
            context.setAttribute("http.connection", managedConn);
            context.setAttribute("http.route", route);
            this.httpProcessor.process(request, (HttpContext)context);
            HttpResponse response = this.requestExecutor.execute(request, managedConn, context);
            this.httpProcessor.process(response, (HttpContext)context);
            if (this.reuseStrategy.keepAlive(response, context)) {
                long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                releaseTrigger.setValidFor(duration, TimeUnit.MILLISECONDS);
                releaseTrigger.markReusable();
            } else {
                releaseTrigger.markNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                releaseTrigger.releaseConnection();
                return Proxies.enhanceResponse(response, null);
            }
            return Proxies.enhanceResponse(response, releaseTrigger);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
    }
}

