/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.Capability;
import com.android.resources.Density;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.NestedConfiguration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.Locale;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaryingConfiguration
extends NestedConfiguration {
    private int myVariation;
    private int myVariationCount;
    private int myAlternate;
    private Device myPrevParentDevice;
    private Device myPrevDevice;

    private VaryingConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/VaryingConfiguration", "<init>"));
        }
        super(configuration);
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull Configuration parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/configurations/VaryingConfiguration", "create"));
        }
        VaryingConfiguration varyingConfiguration = new VaryingConfiguration(parent);
        if (varyingConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "create"));
        }
        return varyingConfiguration;
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull VaryingConfiguration other, @NotNull Configuration parent) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/configurations/VaryingConfiguration", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/configurations/VaryingConfiguration", "create"));
        }
        VaryingConfiguration configuration = new VaryingConfiguration(parent);
        configuration.startBulkEditing();
        VaryingConfiguration.initFrom(configuration, other, other);
        configuration.myAlternate = other.myAlternate;
        configuration.myVariation = other.myVariation;
        configuration.myVariationCount = other.myVariationCount;
        configuration.finishBulkEditing();
        VaryingConfiguration varyingConfiguration = configuration;
        if (varyingConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "create"));
        }
        return varyingConfiguration;
    }

    public int getAlternateFlags() {
        return this.myAlternate;
    }

    @Override
    protected void syncFolderConfig() {
        super.syncFolderConfig();
        this.updateDisplayName();
    }

    public void setVariation(int variation) {
        this.myVariation = variation;
        this.myVariationCount = Math.max(this.myVariationCount, variation + 1);
    }

    public void setVariationCount(int count) {
        this.myVariationCount = count;
    }

    public void updateDisplayName() {
        this.setDisplayName(this.computeDisplayName());
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            Locale locale = super.getLocale();
            if (locale == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getLocale"));
            }
            return locale;
        }
        Locale locale = this.myParent.getLocale();
        if (this.isAlternatingLocale()) {
            List<Locale> locales = this.getConfigurationManager().getLocales();
            for (Locale l : locales) {
                if (l.equals(locale)) continue;
                locale = l;
                break;
            }
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getLocale"));
        }
        return locale2;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        ConfigurationManager manager;
        IAndroidTarget[] targets;
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        IAndroidTarget target = this.myParent.getTarget();
        if (this.isAlternatingTarget() && target != null && (targets = (manager = this.getConfigurationManager()).getTargets()).length > 0) {
            IAndroidTarget mostRecent = manager.getHighestApiTarget();
            if (target.equals(mostRecent)) {
                AndroidModuleInfo info = AndroidModuleInfo.get(manager.getModule());
                if (info != null) {
                    int minSdkVersion = info.getMinSdkVersion().getFeatureLevel();
                    for (IAndroidTarget t : targets) {
                        if (t.getVersion().getFeatureLevel() < minSdkVersion || !ConfigurationManager.isLayoutLibTarget(t)) continue;
                        target = t;
                        break;
                    }
                }
            } else {
                target = mostRecent;
            }
        }
        return target;
    }

    @Override
    @Nullable
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        Device device = this.myParent.getDevice();
        if (this.isAlternatingDevice() && device != null) {
            if (device == this.myPrevParentDevice) {
                return this.myPrevDevice;
            }
            this.myPrevParentDevice = device;
            List<Device> devices = this.getConfigurationManager().getDevices();
            boolean isTv = HardwareConfigHelper.isTv((Device)device);
            boolean isWear = HardwareConfigHelper.isWear((Device)device);
            double smallest = 100.0;
            double biggest = 1.0;
            for (Device d : devices) {
                double size = VaryingConfiguration.getScreenSize(d);
                if (size < 0.0 || isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d)) continue;
                if (size >= biggest) {
                    biggest = size;
                }
                if (!(size <= smallest)) continue;
                smallest = size;
            }
            int bucketCount = this.myVariationCount + 1;
            double inchesPerBucket = (biggest - smallest) / (double)bucketCount;
            double overriddenSize = VaryingConfiguration.getScreenSize(device);
            int overriddenBucket = (int)((overriddenSize - smallest) / inchesPerBucket);
            int bucket = this.myVariation < overriddenBucket ? this.myVariation : this.myVariation + 1;
            double from = inchesPerBucket * (double)bucket + smallest;
            double to = from + inchesPerBucket;
            if (biggest - to < 0.1) {
                to = biggest + 0.1;
            }
            boolean canScaleNinePatch = this.supports(Capability.FIXED_SCALABLE_NINE_PATCH);
            for (Device d : devices) {
                Density density;
                double size;
                if (isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d) || !((size = VaryingConfiguration.getScreenSize(d)) >= from) || !(size < to) || !canScaleNinePatch && ((density = VaryingConfiguration.getDensity(d)) == Density.TV || density == Density.LOW)) continue;
                device = d;
                break;
            }
            this.myPrevDevice = device;
        }
        return device;
    }

    @Nullable
    private static Density getDensity(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/configurations/VaryingConfiguration", "getDensity"));
        }
        Hardware hardware = device.getDefaultHardware();
        Screen screen = hardware.getScreen();
        if (screen != null) {
            return screen.getPixelDensity();
        }
        return null;
    }

    private static double getScreenSize(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/configurations/VaryingConfiguration", "getScreenSize"));
        }
        Hardware hardware = device.getDefaultHardware();
        Screen screen = hardware.getScreen();
        if (screen != null) {
            return screen.getDiagonalLength();
        }
        return -1.0;
    }

    @Override
    @Nullable
    public State getDeviceState() {
        Device device;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state = this.myParent.getDeviceState();
        if (this.isAlternatingDeviceState() && state != null) {
            State next = this.getNextDeviceState(state);
            if (next != null) {
                return next;
            }
            return state;
        }
        if ((this.isAlternatingDevice() || this.isOverridingDevice()) && state != null && (device = this.getDevice()) != null) {
            return device.getState(state.getName());
        }
        return state;
    }

    @Override
    @NotNull
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            NightMode nightMode = super.getNightMode();
            if (nightMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getNightMode"));
            }
            return nightMode;
        }
        NightMode nightMode = this.myParent.getNightMode();
        if (this.isAlternatingNightMode()) {
            NightMode nightMode2 = nightMode = nightMode == NightMode.NIGHT ? NightMode.NOTNIGHT : NightMode.NIGHT;
            if (nightMode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getNightMode"));
            }
            return nightMode2;
        }
        NightMode nightMode3 = nightMode;
        if (nightMode3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getNightMode"));
        }
        return nightMode3;
    }

    @Override
    @NotNull
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            UiMode uiMode = super.getUiMode();
            if (uiMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getUiMode"));
            }
            return uiMode;
        }
        UiMode uiMode = this.myParent.getUiMode();
        if (this.isAlternatingUiMode()) {
            UiMode[] values = UiMode.values();
            UiMode uiMode2 = uiMode = values[(uiMode.ordinal() + 1) % values.length];
            if (uiMode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getUiMode"));
            }
            return uiMode2;
        }
        UiMode uiMode3 = uiMode;
        if (uiMode3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/VaryingConfiguration", "getUiMode"));
        }
        return uiMode3;
    }

    @Override
    @Nullable
    public String computeDisplayName() {
        return VaryingConfiguration.computeDisplayName(this.getOverrideFlags() | this.myAlternate, this);
    }

    public void setAlternateLocale(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x10) : (this.myAlternate &= 0xFFFFFFEF);
    }

    public final boolean isAlternatingLocale() {
        return (this.myAlternate & 0x10) != 0;
    }

    public void setAlternateTarget(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x20) : (this.myAlternate &= 0xFFFFFFDF);
    }

    public final boolean isAlternatingTarget() {
        return (this.myAlternate & 0x20) != 0;
    }

    public void setAlternateDevice(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 2) : (this.myAlternate &= 0xFFFFFFFD);
    }

    public final boolean isAlternatingDevice() {
        return (this.myAlternate & 2) != 0;
    }

    public void setAlternateDeviceState(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 4) : (this.myAlternate &= 0xFFFFFFFB);
    }

    public final boolean isAlternatingDeviceState() {
        return (this.myAlternate & 4) != 0;
    }

    public void setAlternateNightMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x40) : (this.myAlternate &= 0xFFFFFFBF);
    }

    public final boolean isAlternatingNightMode() {
        return (this.myAlternate & 0x40) != 0;
    }

    public void setAlternateUiMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x80) : (this.myAlternate &= 0xFFFFFF7F);
    }

    public final boolean isAlternatingUiMode() {
        return (this.myAlternate & 0x80) != 0;
    }

    @Override
    public boolean changed(int flags) {
        this.updated(flags);
        return true;
    }
}

