/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiFile;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository {
    protected List<? extends LocalResourceRepository> myChildren;
    private long[] myModificationCounts;
    private Map<ResourceType, ListMultimap<String, ResourceItem>> myItems;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myCachedTypeMaps;

    MultiResourceRepository(@NotNull String displayName, @NotNull List<? extends LocalResourceRepository> children) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/rendering/MultiResourceRepository", "<init>"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/rendering/MultiResourceRepository", "<init>"));
        }
        super(displayName);
        this.myItems = Maps.newEnumMap(ResourceType.class);
        this.myCachedTypeMaps = Maps.newEnumMap(ResourceType.class);
        this.setChildren(children);
    }

    protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
        LocalResourceRepository resources;
        int i;
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/rendering/MultiResourceRepository", "setChildren"));
        }
        if (this.myChildren != null) {
            for (i = this.myChildren.size() - 1; i >= 0; --i) {
                resources = this.myChildren.get(i);
                resources.removeParent(this);
            }
        }
        this.myChildren = children;
        this.myModificationCounts = new long[children.size()];
        for (i = this.myChildren.size() - 1; i >= 0; --i) {
            resources = this.myChildren.get(i);
            resources.addParent(this);
            this.myModificationCounts[i] = resources.getModificationCount();
        }
        ++this.myGeneration;
        this.clearCache();
        this.invalidateItemCaches(new ResourceType[0]);
    }

    private void clearCache() {
        this.myItems = null;
        this.myCachedTypeMaps.clear();
    }

    public List<? extends LocalResourceRepository> getChildren() {
        return this.myChildren;
    }

    @Override
    public long getModificationCount() {
        if (this.myChildren.size() == 1) {
            return this.myChildren.get(0).getModificationCount();
        }
        boolean changed = false;
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            long rev = resources.getModificationCount();
            if (rev == this.myModificationCounts[i]) continue;
            this.myModificationCounts[i] = rev;
            changed = true;
        }
        if (changed) {
            ++this.myGeneration;
        }
        return this.myGeneration;
    }

    @NonNull
    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        if (this.myItems == null) {
            if (this.myChildren.size() == 1) {
                this.myItems = this.myChildren.get(0).getItems();
            } else {
                EnumMap map = Maps.newEnumMap(ResourceType.class);
                for (ResourceType type : ResourceType.values()) {
                    map.put(type, this.getMap(type, false));
                }
                this.myItems = map;
            }
        }
        return this.myItems;
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap map = this.myCachedTypeMaps.get(type);
        if (map != null) {
            return map;
        }
        if (this.myChildren.size() == 1) {
            return (ListMultimap)this.myChildren.get(0).getItems().get(type);
        }
        map = ArrayListMultimap.create();
        this.myCachedTypeMaps.put(type, (ListMultimap<String, ResourceItem>)map);
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            Map items = resources.getItems();
            ListMultimap m = (ListMultimap)items.get(type);
            if (m == null) continue;
            for (ResourceItem item : m.values()) {
                String name = item.getName();
                if (map.containsKey((Object)name)) {
                    String qualifiers = item.getQualifiers();
                    boolean contains = false;
                    List list = map.get((Object)name);
                    assert (list != null);
                    for (ResourceItem existing : list) {
                        if (!qualifiers.equals(existing.getQualifiers())) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    map.put((Object)name, (Object)item);
                    continue;
                }
                map.put((Object)name, (Object)item);
            }
        }
        return map;
    }

    @NonNull
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type) {
        return super.getMap(type);
    }

    @NonNull
    public Map<ResourceType, ListMultimap<String, ResourceItem>> getItems() {
        return this.getMap();
    }

    @Override
    public void dispose() {
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            resources.removeParent(this);
            resources.dispose();
        }
    }

    public void invalidateCache(@NotNull LocalResourceRepository repository, ResourceType ... types) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/rendering/MultiResourceRepository", "invalidateCache"));
        }
        assert (this.myChildren.contains((Object)repository)) : repository;
        if (types == null || types.length == 0) {
            this.myCachedTypeMaps.clear();
        } else {
            for (ResourceType type : types) {
                this.myCachedTypeMaps.remove(type);
            }
        }
        this.myItems = null;
        ++this.myGeneration;
        this.invalidateItemCaches(types);
    }

    @Override
    public boolean isScanPending(@NonNull PsiFile psiFile) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            if (!resources.isScanPending(psiFile)) continue;
            return true;
        }
        return false;
    }

    int getChildCount() {
        return this.myChildren.size();
    }
}

