/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.ConfigureAndroidProjectStep;
import com.android.tools.idea.wizard.CreateModuleTemplate;
import com.android.tools.idea.wizard.FormFactorApiComboBox;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.Splitter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import java.awt.Component;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidModuleStepDynamic
extends ConfigureAndroidProjectStep {
    private static final Logger LOG = Logger.getInstance(ConfigureAndroidModuleStepDynamic.class);
    private CreateModuleTemplate myModuleType;
    private FormFactorApiComboBox mySdkControls;
    private Project myProject;
    private final ScopedDataBinder.ValueDeriver<String> ourModuleNameDeriver = new ScopedDataBinder.ValueDeriver<String>(){

        @Override
        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return 1.makeSetOf(WizardConstants.APPLICATION_NAME_KEY);
        }

        @Override
        @Nullable
        public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/wizard/ConfigureAndroidModuleStepDynamic$1", "deriveValue"));
            }
            String appName = state.get(WizardConstants.APPLICATION_NAME_KEY);
            if (appName == null) {
                appName = ((ConfigureAndroidModuleStepDynamic)ConfigureAndroidModuleStepDynamic.this).myModuleType.formFactor.toString();
            }
            return ConfigureAndroidModuleStepDynamic.this.computeModuleName(appName);
        }
    };

    public ConfigureAndroidModuleStepDynamic(@Nullable Project project, @Nullable Disposable parentDisposable) {
        super("Configure your new module", parentDisposable);
        this.myProject = project;
    }

    @Override
    public void init() {
        String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        super.init();
        this.myProjectLocation.setVisible(false);
        this.myProjectLocationLabel.setVisible(false);
        this.deregister((JComponent)this.myProjectLocation);
        this.unregisterValueDeriver(WizardConstants.PROJECT_LOCATION_KEY);
        this.myProjectLocation.setText(projectLocation);
        this.myState.put(WizardConstants.PROJECT_LOCATION_KEY, projectLocation);
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        CreateModuleTemplate moduleType = this.getModuleType();
        if (moduleType != null && moduleType.formFactor != null && moduleType.templateMetadata != null) {
            this.myModuleType = moduleType;
            this.registerValueDeriver(FormFactorUtils.getModuleNameKey(moduleType.formFactor), this.ourModuleNameDeriver);
            if (this.mySdkControls != null) {
                this.deregister(this.mySdkControls);
                this.myPanel.remove(this.mySdkControls);
            }
            this.mySdkControls = new FormFactorApiComboBox(moduleType.formFactor, moduleType.templateMetadata.getMinSdk());
            GridConstraints constraints = new GridConstraints();
            constraints.setColumn(0);
            constraints.setRow(3);
            this.myPanel.add((Component)new JBLabel("Minimum SDK"), constraints);
            constraints.setColumn(1);
            constraints.setFill(1);
            this.myPanel.add((Component)this.mySdkControls, constraints);
            this.mySdkControls.register(this);
        } else {
            LOG.error("init() Called on ConfigureAndroidModuleStepDynamic with an incorrect selected ModuleType");
        }
        if (this.mySdkControls != null) {
            this.mySdkControls.loadSavedApi();
        }
        this.invokeUpdate(null);
    }

    @Nullable
    private CreateModuleTemplate getModuleType() {
        ModuleTemplate moduleTemplate = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        if (moduleTemplate instanceof CreateModuleTemplate) {
            CreateModuleTemplate type = (CreateModuleTemplate)moduleTemplate;
            if (type.formFactor != null && type.templateMetadata != null) {
                return type;
            }
        }
        return null;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        if (this.mySdkControls != null) {
            this.mySdkControls.deriveValues(this.myState, modified);
        }
    }

    @Override
    public boolean validate() {
        this.setErrorHtml("");
        return this.validateAppName() && this.validatePackageName() && this.validateApiLevel();
    }

    private boolean validateApiLevel() {
        if (this.mySdkControls == null || this.mySdkControls.getItemCount() < 1) {
            this.setErrorHtml("No supported platforms found. Please install the proper platform or add-on through the SDK manager.");
            return false;
        }
        return true;
    }

    @NotNull
    String computeModuleName(@NotNull String appName) {
        if (appName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appName", "com/android/tools/idea/wizard/ConfigureAndroidModuleStepDynamic", "computeModuleName"));
        }
        String moduleName = appName.toLowerCase().replaceAll("[/\\\\?%*:|\"<>]", "");
        if (!this.isUniqueModuleName(moduleName = moduleName.replaceAll("\\s", ""))) {
            int i = 2;
            while (!this.isUniqueModuleName(moduleName + Integer.toString(i))) {
                ++i;
            }
            moduleName = moduleName + Integer.toString(i);
        }
        String string = moduleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStepDynamic", "computeModuleName"));
        }
        return string;
    }

    static boolean isValidModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/wizard/ConfigureAndroidModuleStepDynamic", "isValidModuleName"));
        }
        if (!moduleName.replaceAll("[/\\\\?%*:|\"<>]", "").equals(moduleName)) {
            return false;
        }
        for (String s : Splitter.on((char)'.').split((CharSequence)moduleName)) {
            if (!INVALID_MSFT_FILENAMES.contains(s.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private boolean isUniqueModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/wizard/ConfigureAndroidModuleStepDynamic", "isUniqueModuleName"));
        }
        if (this.myProject == null) {
            return true;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module m : moduleManager.getModules()) {
            if (!m.getName().equalsIgnoreCase(moduleName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStepVisible() {
        return this.getModuleType() != null;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("New Android Module Configuration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStepDynamic", "getStepName"));
        }
        return "New Android Module Configuration";
    }

    @Override
    @Nullable
    protected JComponent getHeader() {
        return null;
    }
}

