/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.model.IConfigurableComponent;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.FragmentProperty;
import com.intellij.android.designer.propertyTable.IdProperty;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.TextEditorWithAutoCommit;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadFragment
extends RadViewComponent
implements IConfigurableComponent {
    private static final Property NAME_PROPERTY = new FragmentProperty("name", "http://schemas.android.com/apk/res/android", new MyResourceEditor(), JavadocParser.build("name", "Supply the name of the fragment class to instantiate."));
    private static final Property CLASS_PROPERTY = new FragmentProperty("class", null, new MyResourceEditor(), JavadocParser.build("class", "Supply the name of the fragment class to instantiate."));
    private static final Property TAG_PROPERTY = new FragmentProperty("tag", "http://schemas.android.com/apk/res/android", (PropertyEditor)new TextEditorWithAutoCommit(), JavadocParser.build("tag", "Use <code>device-admin</code> as the root tag of the XML resource that\ndescribes a\n         {@link android.app.admin.DeviceAdminReceiver}, which is\n         referenced from its\n         {@link android.app.admin.DeviceAdminReceiver#DEVICE_ADMIN_META_DATA}\n         meta-data entry.  Described here are the attributes that can be\n         included in that tag."));
    private static final String NAME_KEY = "fragment.name";

    @Override
    public String getCreationXml() {
        return "<fragment android:layout_width=\"wrap_content\"\nandroid:layout_height=\"wrap_content\"\nandroid:name=\"" + this.getClientProperty(NAME_KEY) + "\"/>";
    }

    @Override
    public void configure(RadComponent rootComponent) throws Exception {
        String fragment = RadFragment.chooseFragment(rootComponent);
        if (fragment == null) {
            throw new Exception();
        }
        this.setClientProperty(NAME_KEY, fragment);
    }

    @Nullable
    private static String chooseFragment(RadComponent rootComponent) {
        Module module = RadModelBuilder.getModule(rootComponent);
        if (module == null) {
            return null;
        }
        ChooseClassDialog dialog = new ChooseClassDialog(module, "Fragments", true, "android.app.Fragment", "android.support.v4.app.Fragment");
        dialog.show();
        if (dialog.isOK()) {
            return dialog.getClassName();
        }
        return null;
    }

    @Override
    public void setProperties(List<Property> properties) {
        if (!properties.isEmpty()) {
            properties = new ArrayList<Property>(properties);
            properties.add(NAME_PROPERTY);
            properties.add(CLASS_PROPERTY);
            properties.add(IdProperty.INSTANCE);
            properties.add(TAG_PROPERTY);
        }
        super.setProperties(properties);
    }

    @Override
    public boolean addPopupActions(@NotNull AndroidDesignerEditorPanel designer, @NotNull DefaultActionGroup beforeGroup, @NotNull DefaultActionGroup afterGroup, @Nullable JComponent shortcuts, @NotNull List<RadComponent> selection) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/android/designer/model/RadFragment", "addPopupActions"));
        }
        if (beforeGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeGroup", "com/intellij/android/designer/model/RadFragment", "addPopupActions"));
        }
        if (afterGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGroup", "com/intellij/android/designer/model/RadFragment", "addPopupActions"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/android/designer/model/RadFragment", "addPopupActions"));
        }
        super.addPopupActions(designer, beforeGroup, afterGroup, shortcuts, selection);
        beforeGroup.add((AnAction)new AssignFragmentLayoutAction(designer));
        beforeGroup.addSeparator();
        return true;
    }

    private class AssignFragmentLayoutAction
    extends AnAction {
        private final AndroidDesignerEditorPanel myDesigner;

        private AssignFragmentLayoutAction(AndroidDesignerEditorPanel designer) {
            super("Choose Preview Layout...");
            this.myDesigner = designer;
        }

        public void actionPerformed(AnActionEvent e) {
            ChooseResourceDialog dialog = new ChooseResourceDialog(this.myDesigner.getModule(), new ResourceType[]{ResourceType.LAYOUT}, null, null);
            dialog.setAllowCreateResource(false);
            dialog.show();
            if (dialog.isOK()) {
                String layout = dialog.getResourceName();
                Project project = this.myDesigner.getProject();
                XmlFile xmlFile = this.myDesigner.getXmlFile();
                XmlTag tag = RadFragment.this.getTag();
                LayoutMetadata.setProperty(project, "Set List Type", xmlFile, tag, "layout", "http://schemas.android.com/tools", layout);
                this.myDesigner.requestRender();
            }
        }
    }

    private static final class MyResourceEditor
    extends ResourceEditor {
        public MyResourceEditor() {
            super(null, Collections.<AttributeFormat>emptySet(), null);
        }

        @Override
        protected void showDialog() {
            String fragment = RadFragment.chooseFragment(this.myRootComponent);
            if (fragment != null) {
                this.setValue(fragment);
            }
        }
    }
}

