/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.idea.designer.Insets;
import com.android.tools.idea.designer.SegmentType;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.ConstraintType;
import com.intellij.android.designer.model.layout.relative.DependencyGraph;
import com.intellij.android.designer.model.layout.relative.GuidelineHandler;
import com.intellij.android.designer.model.layout.relative.Match;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ConstraintPainter {
    private static final int ARROW_SIZE = 5;
    private static final int PARENT_RECT_SIZE = 12;

    static void paintConstraint(DesignerGraphics graphics, GuidelineHandler state, Match match) {
        RadViewComponent node = match.edge.node;
        if (node == null) {
            return;
        }
        JComponent layer = graphics.getTarget();
        Rectangle targetBounds = node == state.layout ? node.getPaddedBounds(layer) : node.getBounds(layer);
        ConstraintType type = match.type;
        assert (type != null);
        Rectangle sourceBounds = state.myBounds;
        ConstraintPainter.paintConstraint(graphics, type, node, sourceBounds, node, targetBounds, null, true);
    }

    private static void paintConstraint(DesignerGraphics graphics, DependencyGraph.Constraint constraint, Set<DependencyGraph.Constraint> allConstraints) {
        DependencyGraph.ViewData source = constraint.from;
        DependencyGraph.ViewData target = constraint.to;
        RadViewComponent sourceNode = source.node;
        RadViewComponent targetNode = target.node;
        if (sourceNode == targetNode) {
            return;
        }
        JComponent targetComponent = graphics.getTarget();
        Rectangle sourceBounds = sourceNode.getBounds(targetComponent);
        Rectangle targetBounds = targetNode.getBounds(targetComponent);
        ConstraintPainter.paintConstraint(graphics, constraint.type, sourceNode, sourceBounds, targetNode, targetBounds, allConstraints, false);
    }

    public static void paintSelectionFeedback(DesignerGraphics graphics, RadViewComponent parentNode, List<? extends RadViewComponent> childNodes, boolean showDependents) {
        DependencyGraph dependencyGraph = DependencyGraph.get(parentNode);
        Set<RadViewComponent> horizontalDeps = dependencyGraph.dependsOn(childNodes, false);
        Set<RadViewComponent> verticalDeps = dependencyGraph.dependsOn(childNodes, true);
        HashSet<RadViewComponent> deps = new HashSet<RadViewComponent>(horizontalDeps.size() + verticalDeps.size());
        deps.addAll(horizontalDeps);
        deps.addAll(verticalDeps);
        if (deps.size() > 0) {
            for (RadViewComponent radViewComponent : deps) {
                if (childNodes.contains((Object)radViewComponent)) continue;
                Rectangle bounds = radViewComponent.getBounds(graphics.getTarget());
                graphics.useStyle(DrawingStyle.DEPENDENCY);
                graphics.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
        for (RadViewComponent radViewComponent : childNodes) {
            DependencyGraph.ViewData view = dependencyGraph.getView(radViewComponent);
            if (view == null) continue;
            if (showDependents) {
                ConstraintPainter.paintConstraints(graphics, view.dependedOnBy);
            }
            ConstraintPainter.paintConstraints(graphics, view.dependsOn);
        }
    }

    private static void paintConstraints(DesignerGraphics graphics, List<DependencyGraph.Constraint> constraints) {
        HashSet<DependencyGraph.Constraint> mutableConstraintSet = new HashSet<DependencyGraph.Constraint>(constraints);
        for (DependencyGraph.Constraint constraint : constraints) {
            if (constraint.type != ConstraintType.ALIGN_BASELINE) continue;
            for (DependencyGraph.Constraint c : constraints) {
                if (c.type != ConstraintType.ALIGN_BOTTOM || c.to.node != constraint.to.node) continue;
                mutableConstraintSet.remove(c);
            }
        }
        for (DependencyGraph.Constraint constraint : constraints) {
            if (!mutableConstraintSet.contains(constraint)) continue;
            ConstraintPainter.paintConstraint(graphics, constraint, mutableConstraintSet);
        }
    }

    private static void paintConstraint(DesignerGraphics graphics, ConstraintType type, RadViewComponent sourceNode, Rectangle sourceBounds, RadViewComponent targetNode, Rectangle targetBounds, @Nullable Set<DependencyGraph.Constraint> allConstraints, boolean highlightTargetEdge) {
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        if (sourceSegmentTypeX == SegmentType.CENTER_VERTICAL && targetSegmentTypeX == SegmentType.CENTER_VERTICAL) {
            ConstraintPainter.paintHorizontalCenterConstraint(graphics, sourceBounds, targetBounds);
            return;
        }
        if (sourceSegmentTypeY == SegmentType.CENTER_HORIZONTAL && targetSegmentTypeY == SegmentType.CENTER_HORIZONTAL) {
            ConstraintPainter.paintVerticalCenterConstraint(graphics, sourceBounds, targetBounds);
            return;
        }
        if (allConstraints != null && (type == ConstraintType.LAYOUT_ABOVE || type == ConstraintType.LAYOUT_BELOW || type == ConstraintType.LAYOUT_LEFT_OF || type == ConstraintType.LAYOUT_RIGHT_OF) && ConstraintPainter.paintCornerConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, allConstraints)) {
            return;
        }
        if (sourceSegmentTypeX == SegmentType.UNKNOWN) {
            ConstraintPainter.paintVerticalConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, highlightTargetEdge);
            return;
        }
        if (sourceSegmentTypeY == SegmentType.UNKNOWN) {
            ConstraintPainter.paintHorizontalConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, highlightTargetEdge);
            return;
        }
        assert (false);
    }

    private static boolean paintCornerConstraint(DesignerGraphics graphics, ConstraintType type, RadViewComponent sourceNode, Rectangle sourceBounds, RadViewComponent targetNode, Rectangle targetBounds, Set<DependencyGraph.Constraint> allConstraints) {
        ConstraintType opposite2;
        ConstraintType opposite1;
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        switch (type) {
            case LAYOUT_BELOW: 
            case LAYOUT_ABOVE: {
                opposite1 = ConstraintType.LAYOUT_LEFT_OF;
                opposite2 = ConstraintType.LAYOUT_RIGHT_OF;
                break;
            }
            case LAYOUT_LEFT_OF: 
            case LAYOUT_RIGHT_OF: {
                opposite1 = ConstraintType.LAYOUT_ABOVE;
                opposite2 = ConstraintType.LAYOUT_BELOW;
                break;
            }
            default: {
                return false;
            }
        }
        DependencyGraph.Constraint pair = null;
        for (DependencyGraph.Constraint constraint : allConstraints) {
            if (constraint.type != opposite1 && constraint.type != opposite2 || constraint.to.node != targetNode || constraint.from.node != sourceNode) continue;
            pair = constraint;
            break;
        }
        if (pair != null) {
            if (sourceSegmentTypeX == SegmentType.UNKNOWN) {
                sourceSegmentTypeX = pair.type.sourceSegmentTypeX;
            }
            if (sourceSegmentTypeY == SegmentType.UNKNOWN) {
                sourceSegmentTypeY = pair.type.sourceSegmentTypeY;
            }
            if (targetSegmentTypeX == SegmentType.UNKNOWN) {
                targetSegmentTypeX = pair.type.targetSegmentTypeX;
            }
            if (targetSegmentTypeY == SegmentType.UNKNOWN) {
                targetSegmentTypeY = pair.type.targetSegmentTypeY;
            }
            int x1 = sourceSegmentTypeX == SegmentType.LEFT ? sourceBounds.x + 1 * sourceBounds.width / 4 : sourceBounds.x + 3 * sourceBounds.width / 4;
            int y1 = sourceSegmentTypeY == SegmentType.TOP ? sourceBounds.y + 1 * sourceBounds.height / 4 : sourceBounds.y + 3 * sourceBounds.height / 4;
            int x2 = targetSegmentTypeX == SegmentType.LEFT ? targetBounds.x + 1 * targetBounds.width / 4 : targetBounds.x + 3 * targetBounds.width / 4;
            int y2 = targetSegmentTypeY == SegmentType.TOP ? targetBounds.y + 1 * targetBounds.height / 4 : targetBounds.y + 3 * targetBounds.height / 4;
            graphics.useStyle(DrawingStyle.GUIDELINE);
            graphics.drawArrow(x1, y1, x2, y2);
            allConstraints.remove(pair);
            return true;
        }
        return false;
    }

    private static void paintVerticalConstraint(DesignerGraphics graphics, ConstraintType type, RadViewComponent sourceNode, Rectangle sourceBounds, RadViewComponent targetNode, Rectangle targetBounds, boolean highlightTargetEdge) {
        int endX;
        int startX;
        int sharedY;
        int minRight;
        int maxLeft;
        int center;
        int targetY;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        JComponent targetComponent = graphics.getTarget();
        Insets targetMargins = targetNode.getMargins(targetComponent);
        assert (sourceSegmentTypeY != SegmentType.UNKNOWN);
        assert (targetBounds != null);
        int sourceY = sourceSegmentTypeY.getY(sourceNode, sourceBounds);
        int n = targetY = targetSegmentTypeY == SegmentType.UNKNOWN ? sourceY : targetSegmentTypeY.getY(targetNode, targetBounds);
        if (highlightTargetEdge && type.isRelativeToParentEdge()) {
            graphics.useStyle(DrawingStyle.DROP_ZONE_ACTIVE);
            graphics.fillRect(targetBounds.x, targetY - 6, targetBounds.width, 12);
        }
        if ((center = ((maxLeft = Math.max(sourceBounds.x, targetBounds.x)) + (minRight = Math.min(GuidelineHandler.x2(sourceBounds), GuidelineHandler.x2(targetBounds)))) / 2) > sourceBounds.x && center < GuidelineHandler.x2(sourceBounds)) {
            if (targetSegmentTypeY == SegmentType.BOTTOM && targetMargins.bottom > 5) {
                int sharedY2 = targetY + targetMargins.bottom;
                if (sourceY > sharedY2 + 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(targetBounds.x, sharedY2, GuidelineHandler.x2(targetBounds), sharedY2);
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, sourceY, center, sharedY2 + 2);
                    graphics.drawArrow(center, targetY, center, sharedY2 - 3);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, targetY, center, sourceY);
                }
                return;
            }
            if (targetSegmentTypeY == SegmentType.TOP && targetMargins.top > 5) {
                int sharedY3 = targetY - targetMargins.top;
                if (sourceY < sharedY3 - 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(targetBounds.x, sharedY3, GuidelineHandler.x2(targetBounds), sharedY3);
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, sourceY, center, sharedY3 - 3);
                    graphics.drawArrow(center, targetY, center, sharedY3 + 3);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, targetY, center, sourceY);
                }
                return;
            }
            if (sourceY == targetY) {
                if (sourceSegmentTypeY == SegmentType.BOTTOM || sourceSegmentTypeY == SegmentType.BASELINE) {
                    sourceY -= 10;
                } else if (sourceSegmentTypeY == SegmentType.TOP) {
                    sourceY += 10;
                } else {
                    assert (sourceSegmentTypeY == SegmentType.CENTER_HORIZONTAL) : sourceSegmentTypeY;
                    sourceY += sourceBounds.height / 2 - 10;
                }
            } else if (sourceSegmentTypeY == SegmentType.BASELINE) {
                sourceY = targetY - 10;
            }
            graphics.useStyle(DrawingStyle.GUIDELINE);
            graphics.drawArrow(center, sourceY, center, targetY);
            return;
        }
        int n2 = sharedY = targetSegmentTypeY == SegmentType.UNKNOWN ? sourceY : targetSegmentTypeY.getY(targetNode, targetBounds);
        if (type.relativeToMargin) {
            if (targetSegmentTypeY == SegmentType.TOP) {
                sharedY -= targetMargins.top;
            } else if (targetSegmentTypeY == SegmentType.BOTTOM) {
                sharedY += targetMargins.bottom;
            }
        }
        if (center <= sourceBounds.x) {
            startX = targetBounds.x + targetBounds.width / 4;
            endX = GuidelineHandler.x2(sourceBounds);
        } else {
            assert (center >= GuidelineHandler.x2(sourceBounds));
            startX = sourceBounds.x;
            endX = targetBounds.x + 3 * targetBounds.width / 4;
        }
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(startX, sharedY, endX, sharedY);
        if (Math.abs(sharedY - sourceY) < 10) {
            if (sourceSegmentTypeY == SegmentType.BASELINE) {
                sourceY = sharedY - 10;
            } else if (sourceSegmentTypeY == SegmentType.TOP) {
                sharedY = sourceY;
                sourceY = sharedY + 10;
            } else {
                sharedY = sourceY;
                sourceY = sharedY - 10;
            }
        }
        graphics.useStyle(DrawingStyle.GUIDELINE);
        int x = sourceBounds.x + (sourceSegmentTypeY == SegmentType.BASELINE ? sourceBounds.width / 2 : sourceBounds.width / 4);
        graphics.drawArrow(x, sourceY, x, sharedY);
        int tx = GuidelineHandler.centerX(targetBounds);
        if (targetSegmentTypeY == SegmentType.TOP) {
            int ty = targetBounds.y;
            int margin = targetMargins.top;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx, ty + 10, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx, ty - margin);
            }
        } else if (targetSegmentTypeY == SegmentType.BOTTOM) {
            int ty = GuidelineHandler.y2(targetBounds);
            int margin = targetMargins.bottom;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx, ty - 10, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx, ty + margin);
            }
        } else {
            assert (targetSegmentTypeY == SegmentType.BASELINE) : targetSegmentTypeY;
            int ty = targetSegmentTypeY.getY(targetNode, targetBounds);
            graphics.drawArrow(tx, ty - 10, tx, ty);
        }
    }

    private static void paintHorizontalConstraint(DesignerGraphics graphics, ConstraintType type, RadViewComponent sourceNode, Rectangle sourceBounds, RadViewComponent targetNode, Rectangle targetBounds, boolean highlightTargetEdge) {
        int endY;
        int startY;
        int sharedX;
        int minBottom;
        int maxTop;
        int center;
        int targetX;
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        JComponent targetComponent = graphics.getTarget();
        Insets targetMargins = targetNode.getMargins(targetComponent);
        assert (sourceSegmentTypeX != SegmentType.UNKNOWN);
        assert (targetBounds != null);
        int sourceX = sourceSegmentTypeX.getX(sourceNode, sourceBounds);
        int n = targetX = targetSegmentTypeX == SegmentType.UNKNOWN ? sourceX : targetSegmentTypeX.getX(targetNode, targetBounds);
        if (highlightTargetEdge && type.isRelativeToParentEdge()) {
            graphics.useStyle(DrawingStyle.DROP_ZONE_ACTIVE);
            graphics.fillRect(targetX - 6, targetBounds.y, 12, targetBounds.height);
        }
        if ((center = ((maxTop = Math.max(sourceBounds.y, targetBounds.y)) + (minBottom = Math.min(GuidelineHandler.y2(sourceBounds), GuidelineHandler.y2(targetBounds)))) / 2) > sourceBounds.y && center < GuidelineHandler.y2(sourceBounds)) {
            if (targetSegmentTypeX == SegmentType.RIGHT && targetMargins.right > 5) {
                int sharedX2 = targetX + targetMargins.right;
                if (sourceX > sharedX2 + 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(sharedX2, targetBounds.y, sharedX2, GuidelineHandler.y2(targetBounds));
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(sourceX, center, sharedX2 + 2, center);
                    graphics.drawArrow(targetX, center, sharedX2 - 3, center);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(targetX, center, sourceX, center);
                }
                return;
            }
            if (targetSegmentTypeX == SegmentType.LEFT && targetMargins.left > 5) {
                int sharedX3 = targetX - targetMargins.left;
                if (sourceX < sharedX3 - 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(sharedX3, targetBounds.y, sharedX3, GuidelineHandler.y2(targetBounds));
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(sourceX, center, sharedX3 - 3, center);
                    graphics.drawArrow(targetX, center, sharedX3 + 3, center);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(targetX, center, sourceX, center);
                }
                return;
            }
            if (sourceX == targetX) {
                if (sourceSegmentTypeX == SegmentType.RIGHT) {
                    sourceX -= 10;
                } else if (sourceSegmentTypeX == SegmentType.LEFT) {
                    sourceX += 10;
                } else {
                    assert (sourceSegmentTypeX == SegmentType.CENTER_VERTICAL) : sourceSegmentTypeX;
                    sourceX += sourceBounds.width / 2 - 10;
                }
            }
            graphics.useStyle(DrawingStyle.GUIDELINE);
            graphics.drawArrow(sourceX, center, targetX, center);
            return;
        }
        int n2 = sharedX = targetSegmentTypeX == SegmentType.UNKNOWN ? sourceX : targetSegmentTypeX.getX(targetNode, targetBounds);
        if (type.relativeToMargin) {
            if (targetSegmentTypeX == SegmentType.LEFT) {
                sharedX -= targetMargins.left;
            } else if (targetSegmentTypeX == SegmentType.RIGHT) {
                sharedX += targetMargins.right;
            }
        }
        if (center <= sourceBounds.y) {
            startY = targetBounds.y + targetBounds.height / 4;
            endY = GuidelineHandler.y2(sourceBounds);
        } else {
            assert (center >= GuidelineHandler.y2(sourceBounds));
            startY = sourceBounds.y;
            endY = targetBounds.y + 3 * targetBounds.height / 2;
        }
        int y = sourceBounds.y + sourceBounds.height / 4;
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(sharedX, startY, sharedX, endY);
        if (Math.abs(sharedX - sourceX) < 10) {
            if (sourceSegmentTypeX == SegmentType.LEFT) {
                sharedX = sourceX;
                sourceX = sharedX + 10;
            } else {
                sharedX = sourceX;
                sourceX = sharedX - 10;
            }
        }
        graphics.useStyle(DrawingStyle.GUIDELINE);
        graphics.drawArrow(sourceX, y, sharedX, y);
        int ty = GuidelineHandler.centerY(targetBounds);
        if (targetSegmentTypeX == SegmentType.LEFT) {
            int tx = targetBounds.x;
            int margin = targetMargins.left;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx + 10, ty, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx - margin, ty);
            }
        } else {
            assert (targetSegmentTypeX == SegmentType.RIGHT);
            int tx = GuidelineHandler.x2(targetBounds);
            int margin = targetMargins.right;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx - 10, ty, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx + margin, ty);
            }
        }
    }

    private static void paintVerticalCenterConstraint(DesignerGraphics graphics, Rectangle sourceBounds, Rectangle targetBounds) {
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(targetBounds.x, GuidelineHandler.centerY(targetBounds), GuidelineHandler.x2(targetBounds), GuidelineHandler.centerY(targetBounds));
        graphics.useStyle(DrawingStyle.GUIDELINE);
        graphics.drawLine(sourceBounds.x, GuidelineHandler.centerY(sourceBounds), GuidelineHandler.x2(sourceBounds), GuidelineHandler.centerY(sourceBounds));
    }

    private static void paintHorizontalCenterConstraint(DesignerGraphics graphics, Rectangle sourceBounds, Rectangle targetBounds) {
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(GuidelineHandler.centerX(targetBounds), targetBounds.y, GuidelineHandler.centerX(targetBounds), GuidelineHandler.y2(targetBounds));
        graphics.useStyle(DrawingStyle.GUIDELINE);
        graphics.drawLine(GuidelineHandler.centerX(sourceBounds), sourceBounds.y, GuidelineHandler.centerX(sourceBounds), GuidelineHandler.y2(sourceBounds));
    }
}

