/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.ui.actions;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class OpenOutputAction
extends AnAction {
    private final AdditionalTabComponent myConsole;

    public OpenOutputAction(AdditionalTabComponent console) {
        super("Open in Editor");
        this.myConsole = console;
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Export);
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)this.myConsole.getComponent()));
        if (editor != null) {
            try {
                byte[] content = editor.getDocument().getText().getBytes("UTF-8");
                String extension = "xml";
                VcsVirtualFile file = new VcsVirtualFile("XSLT Output.xml", content, null, (VirtualFileSystem)VcsFileSystem.getInstance()){

                    public Charset getCharset() {
                        return Charset.forName("UTF-8");
                    }
                };
                FileEditorManager.getInstance((Project)((Project)CommonDataKeys.PROJECT.getData(e.getDataContext()))).openFile((VirtualFile)file, true);
            }
            catch (UnsupportedEncodingException e1) {
                throw new AssertionError(e);
            }
        }
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)this.myConsole.getComponent()));
        e.getPresentation().setEnabled(editor != null && editor.getDocument().getTextLength() > 0);
    }
}

