/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.initialization.BuildLayoutParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutCommandLineConverter
extends AbstractCommandLineConverter<BuildLayoutParameters> {
    public static final String GRADLE_USER_HOME = "g";
    private static final String NO_SEARCH_UPWARDS = "u";
    public static final String PROJECT_DIR = "p";

    public BuildLayoutParameters convert(ParsedCommandLine options, BuildLayoutParameters target) throws CommandLineArgumentException {
        BasicFileResolver resolver = new BasicFileResolver(target.getProjectDir());
        if (options.hasOption(NO_SEARCH_UPWARDS)) {
            target.setSearchUpwards(false);
        }
        if (options.hasOption(PROJECT_DIR)) {
            target.setProjectDir((File)resolver.transform(options.option(PROJECT_DIR).getValue()));
        }
        if (options.hasOption(GRADLE_USER_HOME)) {
            target.setGradleUserHomeDir((File)resolver.transform(options.option(GRADLE_USER_HOME).getValue()));
        }
        return target;
    }

    public void configure(CommandLineParser parser) {
        parser.option(new String[]{NO_SEARCH_UPWARDS, "no-search-upward"}).hasDescription(String.format("Don't search in parent folders for a %s file.", "settings.gradle"));
        parser.option(new String[]{PROJECT_DIR, "project-dir"}).hasArgument().hasDescription("Specifies the start directory for Gradle. Defaults to current directory.");
        parser.option(new String[]{GRADLE_USER_HOME, "gradle-user-home"}).hasArgument().hasDescription("Specifies the gradle user home directory.");
    }
}

