/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.net.NetUtils;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetchExtResourceAction
extends BaseExtResourceAction
implements WatchedRootsProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.FetchDtdAction");
    @NonNls
    private static final String HTML_MIME = "text/html";
    @NonNls
    private static final String HTTP_PROTOCOL = "http://";
    @NonNls
    private static final String HTTPS_PROTOCOL = "https://";
    @NonNls
    private static final String FTP_PROTOCOL = "ftp://";
    @NonNls
    private static final String EXT_RESOURCES_FOLDER = "extResources";
    private final boolean myForceResultIsValid;

    public FetchExtResourceAction() {
        this.myForceResultIsValid = false;
    }

    public FetchExtResourceAction(boolean forceResultIsValid) {
        this.myForceResultIsValid = forceResultIsValid;
    }

    @Override
    protected String getQuickFixKeyId() {
        return "fetch.external.resource";
    }

    @Override
    protected boolean isAcceptableUri(String uri) {
        return uri.startsWith(HTTP_PROTOCOL) || uri.startsWith(FTP_PROTOCOL) || uri.startsWith(HTTPS_PROTOCOL);
    }

    public static String findUrl(PsiFile file, int offset, String uri) {
        String attrValue;
        String prefix;
        XmlTag tag;
        PsiElement currentElement = file.findElementAt(offset);
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlAttribute.class);
        if (attribute != null && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class)) != null && (prefix = tag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) != null && (attrValue = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(attrValue);
            while (tokenizer.hasMoreElements()) {
                if (uri.equals(tokenizer.nextToken())) {
                    if (!tokenizer.hasMoreElements()) {
                        return uri;
                    }
                    String url = tokenizer.nextToken();
                    return url.startsWith(HTTP_PROTOCOL) ? url : uri;
                }
                if (!tokenizer.hasMoreElements()) {
                    return uri;
                }
                tokenizer.nextToken();
            }
        }
        return uri;
    }

    @NotNull
    public Set<String> getRootsToWatch() {
        File path = new File(FetchExtResourceAction.getExternalResourcesPath());
        if (!path.exists() && !path.mkdirs()) {
            LOG.warn("Unable to create: " + path);
        }
        Set<String> set = Collections.singleton(path.getAbsolutePath());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction", "getRootsToWatch"));
        }
        return set;
    }

    @Override
    protected void doInvoke(final @NotNull PsiFile file, int offset, final @NotNull String uri, Editor editor) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction", "doInvoke"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction", "doInvoke"));
        }
        final String url = FetchExtResourceAction.findUrl(file, offset, uri);
        final Project project = file.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, XmlBundle.message((String)"fetching.resource.title", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$1", "run"));
                }
                while (true) {
                    try {
                        HttpConfigurable.getInstance().prepareURL(url);
                        FetchExtResourceAction.this.fetchDtd(project, uri, url, indicator);
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
                            }
                        });
                        return;
                    }
                    catch (IOException ex) {
                        LOG.info((Throwable)ex);
                        String problemUrl = ex instanceof FetchingResourceIOException ? ((FetchingResourceIOException)ex).url : url;
                        String message = XmlBundle.message((String)"error.fetching.title", (Object[])new Object[0]);
                        if (url.equals(problemUrl)) continue;
                        message = XmlBundle.message((String)"error.fetching.dependent.resource.title", (Object[])new Object[0]);
                        if (IOExceptionDialog.showErrorDialog((String)message, (String)XmlBundle.message((String)"error.fetching.resource", (Object[])new Object[]{problemUrl}))) continue;
                        return;
                    }
                    break;
                }
            }
        });
    }

    private void fetchDtd(Project project, String dtdUrl, String url, ProgressIndicator indicator) throws IOException {
        String extResourcesPath = FetchExtResourceAction.getExternalResourcesPath();
        final File extResources = new File(extResourcesPath);
        LOG.assertTrue(extResources.mkdirs() || extResources.exists(), (Object)extResources);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(FetchExtResourceAction.class);
                try {
                    String path = FileUtil.toSystemIndependentName((String)extResources.getAbsolutePath());
                    VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    LOG.assertTrue(vFile != null, (Object)path);
                }
                finally {
                    token.finish();
                }
            }
        }, indicator.getModalityState());
        LinkedList<String> downloadedResources = new LinkedList<String>();
        LinkedList<String> resourceUrls = new LinkedList<String>();
        IOException[] nestedException = new IOException[1];
        try {
            String resPath = this.fetchOneFile(indicator, url, project, extResourcesPath, null);
            if (resPath == null) {
                return;
            }
            resourceUrls.add(dtdUrl);
            downloadedResources.add(resPath);
            VirtualFile virtualFile = FetchExtResourceAction.findFileByPath(resPath, dtdUrl, indicator);
            HashSet<String> linksToProcess = new HashSet<String>();
            HashSet<String> processedLinks = new HashSet<String>();
            HashMap<String, String> baseUrls = new HashMap<String, String>();
            VirtualFile contextFile = virtualFile;
            linksToProcess.addAll(FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile, null, psiManager, url));
            while (!linksToProcess.isEmpty()) {
                String resourcePath;
                String resourceUrl;
                String s = (String)linksToProcess.iterator().next();
                linksToProcess.remove(s);
                processedLinks.add(s);
                boolean absoluteUrl = s.startsWith(HTTP_PROTOCOL);
                if (absoluteUrl) {
                    resourceUrl = s;
                } else {
                    String baseUrl = (String)baseUrls.get(s);
                    if (baseUrl == null) {
                        baseUrl = url;
                    }
                    resourceUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47) + 1) + s;
                }
                String refname = s.substring(s.lastIndexOf(47) + 1);
                if (absoluteUrl) {
                    refname = Integer.toHexString(s.hashCode()) + "_" + refname;
                }
                try {
                    resourcePath = this.fetchOneFile(indicator, resourceUrl, project, extResourcesPath, refname);
                }
                catch (IOException e) {
                    nestedException[0] = new FetchingResourceIOException(e, resourceUrl);
                    break;
                }
                if (resourcePath != null) {
                    virtualFile = FetchExtResourceAction.findFileByPath(resourcePath, absoluteUrl ? s : null, indicator);
                    downloadedResources.add(resourcePath);
                    if (absoluteUrl) {
                        resourceUrls.add(s);
                    }
                    Set<String> newLinks = FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile, contextFile, psiManager, resourceUrl);
                    for (String u : newLinks) {
                        baseUrls.put(u, resourceUrl);
                        if (processedLinks.contains(u)) continue;
                        linksToProcess.add(u);
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            nestedException[0] = ex;
        }
        if (nestedException[0] != null) {
            this.cleanup(resourceUrls, downloadedResources);
            throw nestedException[0];
        }
    }

    private static VirtualFile findFileByPath(final String resPath, final @Nullable String dtdUrl, ProgressIndicator indicator) {
        final Ref ref = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ref.set((Object)LocalFileSystem.getInstance().refreshAndFindFileByPath(resPath.replace(File.separatorChar, '/')));
                        if (dtdUrl != null) {
                            ExternalResourceManager.getInstance().addResource(dtdUrl, resPath);
                        }
                    }
                });
            }
        }, indicator.getModalityState());
        return (VirtualFile)ref.get();
    }

    public static String getExternalResourcesPath() {
        return PathManager.getSystemPath() + File.separator + EXT_RESOURCES_FOLDER;
    }

    private void cleanup(final List<String> resourceUrls, final List<String> downloadedResources) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (String resourcesUrl : resourceUrls) {
                            ExternalResourceManager.getInstance().removeResource(resourcesUrl);
                        }
                        for (String downloadedResource : downloadedResources) {
                            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(downloadedResource));
                            if (virtualFile == null) continue;
                            try {
                                virtualFile.delete((Object)this);
                            }
                            catch (IOException ignore) {}
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String fetchOneFile(final ProgressIndicator indicator, final String resourceUrl, Project project, String extResourcesPath, @Nullable String refname) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                indicator.setText(XmlBundle.message((String)"fetching.progress.indicator", (Object[])new Object[]{resourceUrl}));
            }
        });
        FetchResult result = FetchExtResourceAction.fetchData(project, resourceUrl, indicator);
        if (result == null) {
            return null;
        }
        if (!this.resultIsValid(project, indicator, resourceUrl, result)) {
            return null;
        }
        int slashIndex = resourceUrl.lastIndexOf(47);
        String resPath = extResourcesPath + File.separatorChar;
        if (refname != null) {
            File parent;
            int refNameSlashIndex = (resPath = resPath + refname).lastIndexOf(47);
            if (!(refNameSlashIndex == -1 || (parent = new File(resPath.substring(0, refNameSlashIndex))).mkdirs() && parent.exists())) {
                LOG.warn("Unable to create: " + parent);
            }
        } else {
            resPath = resPath + Integer.toHexString(resourceUrl.hashCode()) + "_" + resourceUrl.substring(slashIndex + 1);
        }
        int lastDoPosInResourceUrl = resourceUrl.lastIndexOf(46, slashIndex);
        if (lastDoPosInResourceUrl == -1 || FileTypeManager.getInstance().getFileTypeByExtension(resourceUrl.substring(lastDoPosInResourceUrl + 1)) == FileTypes.UNKNOWN) {
            String extension = result.contentType != null && result.contentType.contains(HTML_MIME) ? StdFileTypes.HTML.getDefaultExtension() : StdFileTypes.XML.getDefaultExtension();
            resPath = resPath + "." + extension;
        }
        File res = new File(resPath);
        FileOutputStream out = new FileOutputStream(res);
        try {
            out.write(result.bytes);
        }
        finally {
            out.close();
        }
        return resPath;
    }

    protected boolean resultIsValid(final Project project, ProgressIndicator indicator, final String resourceUrl, FetchResult result) {
        if (this.myForceResultIsValid) {
            return true;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && result.contentType != null && result.contentType.contains(HTML_MIME) && new String(result.bytes).contains("<html")) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showMessageDialog((Project)project, (String)XmlBundle.message((String)"invalid.url.no.xml.file.at.location", (Object[])new Object[]{resourceUrl}), (String)XmlBundle.message((String)"invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                }
            }, indicator.getModalityState());
            return false;
        }
        return true;
    }

    private static Set<String> extractEmbeddedFileReferences(XmlFile file, XmlFile context, final String url) {
        final LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (context != null) {
            XmlEntityCache.copyEntityCaches((PsiFile)file, (PsiFile)context);
        }
        XmlUtil.processXmlElements((XmlElement)file, new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                block8: {
                    String schemaLocation;
                    XmlTag tag;
                    block10: {
                        block9: {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$7", "execute"));
                            }
                            if (!(element instanceof XmlEntityDecl)) break block9;
                            String candidateName = null;
                            for (PsiElement e = element.getLastChild(); e != null; e = e.getPrevSibling()) {
                                if (e instanceof XmlAttributeValue && candidateName == null) {
                                    candidateName = e.getText().substring(1, e.getTextLength() - 1);
                                    continue;
                                }
                                if (!(e instanceof XmlToken) || candidateName == null || ((XmlToken)e).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC && ((XmlToken)e).getTokenType() != XmlTokenType.XML_DOCTYPE_SYSTEM) continue;
                                if (result.contains(candidateName)) break block8;
                                result.add(candidateName);
                                break block8;
                            }
                            break block8;
                        }
                        if (!(element instanceof XmlTag)) break block8;
                        tag = (XmlTag)element;
                        schemaLocation = tag.getAttributeValue("schemaLocation");
                        if (schemaLocation == null) break block10;
                        PsiReference[] references = tag.getAttribute("schemaLocation").getValueElement().getReferences();
                        if (references.length <= 0) break block8;
                        String extension = FileUtilRt.getExtension((String)new File(url).getName());
                        String namespace = tag.getAttributeValue("namespace");
                        if (namespace != null && schemaLocation.indexOf(47) == -1 && !extension.equals(FileUtilRt.getExtension((String)schemaLocation))) {
                            result.add(namespace.substring(0, namespace.lastIndexOf(47) + 1) + schemaLocation);
                        } else {
                            result.add(schemaLocation);
                        }
                        break block8;
                    }
                    schemaLocation = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
                    if (schemaLocation != null) {
                        StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
                        while (tokenizer.hasMoreTokens()) {
                            tokenizer.nextToken();
                            if (tokenizer.hasMoreTokens()) {
                                String location = tokenizer.nextToken();
                                result.add(location);
                                continue;
                            }
                            break;
                        }
                    }
                }
                return true;
            }
        }, true, true);
        return result;
    }

    public static Set<String> extractEmbeddedFileReferences(final VirtualFile vFile, final @Nullable VirtualFile contextVFile, final PsiManager psiManager, final String url) {
        return (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<String>>(){

            public Set<String> compute() {
                PsiFile file = psiManager.findFile(vFile);
                if (file instanceof XmlFile) {
                    PsiFile contextFile = contextVFile != null ? psiManager.findFile(contextVFile) : null;
                    return FetchExtResourceAction.extractEmbeddedFileReferences((XmlFile)file, contextFile instanceof XmlFile ? (XmlFile)contextFile : null, url);
                }
                return Collections.emptySet();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static FetchResult fetchData(final Project project, final String dtdUrl, ProgressIndicator indicator) throws IOException {
        try {
            String contentType;
            URL url = new URL(dtdUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.addRequestProperty("accept", "text/xml,application/xml,text/html,*/*");
            int contentLength = urlConnection.getContentLength();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = urlConnection.getInputStream();
            try {
                contentType = urlConnection.getContentType();
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)in, (OutputStream)out, (int)contentLength);
            }
            finally {
                in.close();
            }
            FetchResult result = new FetchResult();
            result.bytes = out.toByteArray();
            result.contentType = contentType;
            return result;
        }
        catch (MalformedURLException e) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((Project)project, (String)XmlBundle.message((String)"invalid.url.message", (Object[])new Object[]{dtdUrl}), (String)XmlBundle.message((String)"invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    }
                }, indicator.getModalityState());
            }
            return null;
        }
    }

    protected static class FetchResult {
        byte[] bytes;
        String contentType;

        protected FetchResult() {
        }
    }

    static class FetchingResourceIOException
    extends IOException {
        private final String url;

        FetchingResourceIOException(Throwable cause, String url) {
            this.initCause(cause);
            this.url = url;
        }
    }
}

