/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoveUnusedVariableFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix");
    private final PsiVariable myVariable;

    public RemoveUnusedVariableFix(PsiVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message(this.myVariable instanceof PsiField ? "remove.unused.field" : "remove.unused.variable", this.myVariable.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.unused.variable.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix", "isAvailable"));
        }
        return this.myVariable != null && this.myVariable.isValid() && this.myVariable.getManager().isInProject((PsiElement)this.myVariable);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        this.removeVariableAndReferencingStatements(editor);
    }

    private void removeVariableAndReferencingStatements(Editor editor) {
        final ArrayList<PsiElement> references = new ArrayList<PsiElement>();
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean[] canCopeWithSideEffects = new boolean[]{true};
        try {
            PsiClass context;
            Object object = context = this.myVariable instanceof PsiField ? ((PsiField)this.myVariable).getContainingClass() : PsiUtil.getVariableCodeBlock((PsiVariable)this.myVariable, null);
            if (context != null) {
                RemoveUnusedVariableUtil.collectReferences((PsiElement)context, this.myVariable, references);
            }
            references.add((PsiElement)this.myVariable);
            for (PsiElement element : references) {
                Boolean result = RemoveUnusedVariableUtil.processUsage(element, this.myVariable, sideEffects, 0);
                if (result == null) {
                    return;
                }
                canCopeWithSideEffects[0] = canCopeWithSideEffects[0] & result;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        final int deleteMode = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, this.myVariable, editor, canCopeWithSideEffects[0]);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    RemoveUnusedVariableUtil.deleteReferences(RemoveUnusedVariableFix.this.myVariable, references, deleteMode);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public static int showSideEffectsWarning(List<PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects, @NonNls String beforeText, @NonNls String afterText) {
        if (sideEffects.isEmpty()) {
            return 2;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return canCopeWithSideEffects ? 1 : 2;
        }
        Project project = editor.getProject();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(sideEffects);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlights(editor, elements, attributes, true, null);
        SideEffectWarningDialog dialog = new SideEffectWarningDialog(project, false, variable, beforeText, afterText, canCopeWithSideEffects);
        dialog.show();
        return dialog.getExitCode();
    }

    private static int showSideEffectsWarning(List<PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects) {
        PsiElement sideEffect;
        String text = sideEffects.isEmpty() ? "" : ((sideEffect = sideEffects.get(0)) instanceof PsiExpression ? PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)sideEffect)) : sideEffect.getText());
        return RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, editor, canCopeWithSideEffects, text, text);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

