/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.javadoc.ColorUtil;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.javadoc.PsiInlineDocTagImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocInfoGenerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.javadoc.JavaDocInfoGenerator");
    @NonNls
    private static final Pattern ourNotDot = Pattern.compile("[^.]");
    @NonNls
    private static final Pattern ourWhitespaces = Pattern.compile("[ \\n\\r\\t]+");
    @NonNls
    private static final String THROWS_KEYWORD = "throws";
    @NonNls
    private static final String BR_TAG = "<br>";
    @NonNls
    private static final String LINK_TAG = "link";
    @NonNls
    private static final String LITERAL_TAG = "literal";
    @NonNls
    private static final String CODE_TAG = "code";
    @NonNls
    private static final String LINKPLAIN_TAG = "linkplain";
    @NonNls
    private static final String INHERITDOC_TAG = "inheritDoc";
    @NonNls
    private static final String DOCROOT_TAG = "docRoot";
    @NonNls
    private static final String VALUE_TAG = "value";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private final Project myProject;
    private final PsiElement myElement;
    private static final InheritDocProvider<PsiDocTag> ourEmptyProvider = new InheritDocProvider<PsiDocTag>(){

        @Override
        public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
            return null;
        }

        @Override
        public PsiClass getElement() {
            return null;
        }
    };
    private static final InheritDocProvider<PsiElement[]> ourEmptyElementsProvider = JavaDocInfoGenerator.mapProvider(ourEmptyProvider, false);

    private static InheritDocProvider<PsiElement[]> mapProvider(final InheritDocProvider<PsiDocTag> i, final boolean dropFirst) {
        return new InheritDocProvider<PsiElement[]>(){

            @Override
            public Pair<PsiElement[], InheritDocProvider<PsiElement[]>> getInheritDoc() {
                PsiElement[] elements;
                Pair pair = i.getInheritDoc();
                if (pair == null) {
                    return null;
                }
                PsiElement[] rawElements = ((PsiDocTag)pair.first).getDataElements();
                if (dropFirst && rawElements != null && rawElements.length > 0) {
                    elements = new PsiElement[rawElements.length - 1];
                    System.arraycopy(rawElements, 1, elements, 0, elements.length);
                } else {
                    elements = rawElements;
                }
                return Pair.create((Object)elements, (Object)JavaDocInfoGenerator.mapProvider((InheritDocProvider)pair.second, dropFirst));
            }

            @Override
            public PsiClass getElement() {
                return i.getElement();
            }
        };
    }

    private static DocTagLocator<PsiDocTag> parameterLocator(final String name) {
        return new DocTagLocator<PsiDocTag>(){

            @Override
            public PsiDocTag find(PsiDocComment comment) {
                PsiDocTag[] tags;
                if (comment == null) {
                    return null;
                }
                for (PsiDocTag tag : tags = comment.findTagsByName("param")) {
                    String text;
                    PsiDocTagValue value = tag.getValueElement();
                    if (value == null || (text = value.getText()) == null || !text.equals(name)) continue;
                    return tag;
                }
                return null;
            }
        };
    }

    private static DocTagLocator<PsiDocTag> exceptionLocator(final String name) {
        return new DocTagLocator<PsiDocTag>(){

            @Override
            public PsiDocTag find(PsiDocComment comment) {
                PsiDocTag[] tags;
                if (comment == null) {
                    return null;
                }
                for (PsiDocTag tag : tags = JavaDocInfoGenerator.getThrowsTags(comment)) {
                    String text;
                    PsiDocTagValue value = tag.getValueElement();
                    if (value == null || (text = value.getText()) == null || !JavaDocInfoGenerator.areWeakEqual(text, name)) continue;
                    return tag;
                }
                return null;
            }
        };
    }

    public JavaDocInfoGenerator(Project project, PsiElement element) {
        this.myProject = project;
        this.myElement = element;
    }

    @Nullable
    public String generateFileInfo() {
        StringBuilder buffer = new StringBuilder();
        if (this.myElement instanceof PsiFile) {
            JavaDocInfoGenerator.generateFileJavaDoc(buffer, (PsiFile)this.myElement, true);
        }
        return JavaDocInfoGenerator.fixupDoc(buffer);
    }

    @Nullable
    private static String fixupDoc(@NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator", "fixupDoc"));
        }
        String text = buffer.toString();
        if (text.isEmpty()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated JavaDoc:");
            LOG.debug(text);
        }
        text = StringUtil.replaceIgnoreCase((String)text, (String)"<p/>", (String)"<p></p>");
        return StringUtil.replace((String)text, (String)"/>", (String)">");
    }

    public boolean generateDocInfoCore(StringBuilder buffer, boolean generatePrologueAndEpilogue) {
        if (this.myElement instanceof PsiClass) {
            this.generateClassJavaDoc(buffer, (PsiClass)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiMethod) {
            this.generateMethodJavaDoc(buffer, (PsiMethod)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiParameter) {
            this.generateMethodParameterJavaDoc(buffer, (PsiParameter)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiField) {
            this.generateFieldJavaDoc(buffer, (PsiField)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiVariable) {
            JavaDocInfoGenerator.generateVariableJavaDoc(buffer, (PsiVariable)this.myElement, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myElement);
            if (aPackage == null) {
                return false;
            }
            this.generatePackageJavaDoc(buffer, aPackage, generatePrologueAndEpilogue);
        } else if (this.myElement instanceof PsiPackage) {
            this.generatePackageJavaDoc(buffer, (PsiPackage)this.myElement, generatePrologueAndEpilogue);
        } else {
            return false;
        }
        return true;
    }

    public static String generateSignature(PsiElement element) {
        StringBuilder buf = new StringBuilder();
        if (element instanceof PsiClass) {
            if (JavaDocInfoGenerator.generateClassSignature(buf, (PsiClass)element, false)) {
                return null;
            }
        } else if (element instanceof PsiField) {
            JavaDocInfoGenerator.generateFieldSignature(buf, (PsiField)element, false);
        } else if (element instanceof PsiMethod) {
            JavaDocInfoGenerator.generateMethodSignature(buf, (PsiMethod)element, false);
        }
        return buf.toString();
    }

    @Nullable
    public String generateDocInfo(List<String> docURLs) {
        StringBuilder buffer = new StringBuilder();
        if (!this.generateDocInfoCore(buffer, true)) {
            return null;
        }
        if (docURLs != null) {
            if (buffer.length() == 0) {
                buffer.append("<html><body></body></html>");
            }
            String errorSection = "<p id=\"error\">Following external urls were checked:<br>&nbsp;&nbsp;&nbsp;<i>" + StringUtil.join(docURLs, (Function)new Function<String, String>(){

                public String fun(String url) {
                    return XmlStringUtil.escapeString((String)url);
                }
            }, (String)"</i><br>&nbsp;&nbsp;&nbsp;<i>") + "</i><br>The documentation for this element is not found. Please add all the needed paths to API docs in " + "<a href=\"open://Project Settings\">Project Settings.</a></p>";
            buffer.insert(buffer.indexOf("<body>"), errorSection);
        }
        return JavaDocInfoGenerator.fixupDoc(buffer);
    }

    private void generateClassJavaDoc(@NonNls StringBuilder buffer, PsiClass aClass, boolean generatePrologueAndEpilogue) {
        String packageName;
        PsiFile file;
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generatePrologue(buffer);
        }
        if ((file = aClass.getContainingFile()) instanceof PsiJavaFile && !(packageName = ((PsiJavaFile)file).getPackageName()).isEmpty()) {
            buffer.append("<small><b>");
            buffer.append(packageName);
            buffer.append("</b></small>");
        }
        buffer.append("<PRE>");
        if (JavaDocInfoGenerator.generateClassSignature(buffer, aClass, true)) {
            return;
        }
        buffer.append("</PRE>");
        PsiDocComment comment = JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)aClass);
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
            this.generateTypeParametersSection(buffer, aClass);
        }
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generateEpilogue(buffer);
        }
    }

    private static boolean generateClassSignature(StringBuilder buffer, PsiClass aClass, boolean generateLink) {
        int i;
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)aClass, generateLink, true);
        String modifiers = PsiFormatUtil.formatModifiers((PsiElement)aClass, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        buffer.append(aClass.isInterface() ? LangBundle.message("java.terms.interface", new Object[0]) : LangBundle.message("java.terms.class", new Object[0]));
        buffer.append(" ");
        String refText = JavaDocUtil.getReferenceText(aClass.getProject(), (PsiElement)aClass);
        if (refText == null) {
            buffer.setLength(0);
            return true;
        }
        String labelText = JavaDocUtil.getLabelText(aClass.getProject(), aClass.getManager(), refText, (PsiElement)aClass);
        buffer.append("<b>");
        buffer.append(labelText);
        buffer.append("</b>");
        buffer.append(JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)aClass));
        buffer.append("\n");
        PsiClassType[] refs = aClass.getExtendsListTypes();
        String qName = aClass.getQualifiedName();
        if (refs.length > 0 || !aClass.isInterface() && (qName == null || !qName.equals("java.lang.Object"))) {
            buffer.append("extends ");
            if (refs.length == 0) {
                JavaDocInfoGenerator.generateLink(buffer, "java.lang.Object", null, (PsiElement)aClass, false);
            } else {
                for (i = 0; i < refs.length; ++i) {
                    JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[i], (PsiElement)aClass, generateLink);
                    if (i >= refs.length - 1) continue;
                    buffer.append(",&nbsp;");
                }
            }
            buffer.append("\n");
        }
        if ((refs = aClass.getImplementsListTypes()).length > 0) {
            buffer.append("implements ");
            for (i = 0; i < refs.length; ++i) {
                JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[i], (PsiElement)aClass, generateLink);
                if (i >= refs.length - 1) continue;
                buffer.append(",&nbsp;");
            }
            buffer.append("\n");
        }
        if (buffer.charAt(buffer.length() - 1) == '\n') {
            buffer.setLength(buffer.length() - 1);
        }
        return false;
    }

    private void generateTypeParametersSection(StringBuilder buffer, PsiClass aClass) {
        PsiTypeParameter[] typeParameters;
        PsiDocComment docComment = aClass.getDocComment();
        if (docComment == null) {
            return;
        }
        LinkedList<Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>> result = new LinkedList<Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>>();
        for (PsiTypeParameter typeParameter : typeParameters = aClass.getTypeParameters()) {
            DocTagLocator<PsiDocTag> locator = JavaDocInfoGenerator.parameterLocator("<" + typeParameter.getName() + ">");
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> inClassComment = JavaDocInfoGenerator.findInClassComment(aClass, locator);
            if (inClassComment != null) {
                result.add(inClassComment);
                continue;
            }
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair = JavaDocInfoGenerator.findInHierarchy(aClass, locator);
            if (pair == null) continue;
            result.add(pair);
        }
        this.generateTypeParametersSection(buffer, result);
    }

    @Nullable
    private static Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> findInHierarchy(PsiClass psiClass, DocTagLocator<PsiDocTag> locator) {
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair;
        for (PsiClass superClass : psiClass.getSupers()) {
            pair = JavaDocInfoGenerator.findInClassComment(superClass, locator);
            if (pair == null) continue;
            return pair;
        }
        for (PsiClass superInterface : psiClass.getInterfaces()) {
            pair = JavaDocInfoGenerator.findInClassComment(superInterface, locator);
            if (pair == null) continue;
            return pair;
        }
        return null;
    }

    private static Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> findInClassComment(final PsiClass psiClass, final DocTagLocator<PsiDocTag> locator) {
        PsiDocTag tag = locator.find(JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)psiClass));
        if (tag != null) {
            return new Pair((Object)tag, (Object)new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return JavaDocInfoGenerator.findInHierarchy(psiClass, locator);
                }

                @Override
                public PsiClass getElement() {
                    return psiClass;
                }
            });
        }
        return null;
    }

    @Nullable
    private static PsiDocComment getDocComment(PsiDocCommentOwner docOwner) {
        PsiElement parent;
        PsiModifierList modifierList;
        PsiElement navElement = docOwner.getNavigationElement();
        if (!(navElement instanceof PsiDocCommentOwner)) {
            LOG.info("Wrong navElement: " + navElement + "; original = " + docOwner + " of class " + docOwner.getClass());
            return null;
        }
        PsiDocComment comment = ((PsiDocCommentOwner)navElement).getDocComment();
        if (comment == null && (modifierList = docOwner.getModifierList()) != null && (parent = modifierList.getParent()) instanceof PsiDocCommentOwner && parent.getNavigationElement() instanceof PsiDocCommentOwner) {
            return ((PsiDocCommentOwner)parent.getNavigationElement()).getDocComment();
        }
        return comment;
    }

    private void generateFieldJavaDoc(@NonNls StringBuilder buffer, PsiField field, boolean generatePrologueAndEpilogue) {
        String qName;
        PsiClass parentClass;
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generatePrologue(buffer);
        }
        if ((parentClass = field.getContainingClass()) != null && (qName = parentClass.getQualifiedName()) != null) {
            buffer.append("<small><b>");
            JavaDocInfoGenerator.generateLink(buffer, qName, qName, (PsiElement)field, false);
            buffer.append("</b></small>");
        }
        buffer.append("<PRE>");
        JavaDocInfoGenerator.generateFieldSignature(buffer, field, true);
        buffer.append("</PRE>");
        ColorUtil.appendColorPreview((PsiVariable)field, buffer);
        PsiDocComment comment = JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)field);
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
        }
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generateEpilogue(buffer);
        }
    }

    private static void generateFieldSignature(StringBuilder buffer, PsiField field, boolean generateLink) {
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)field, generateLink, true);
        String modifiers = PsiFormatUtil.formatModifiers((PsiElement)field, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        JavaDocInfoGenerator.generateType(buffer, field.getType(), (PsiElement)field, generateLink);
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(field.getName());
        JavaDocInfoGenerator.appendInitializer(buffer, (PsiVariable)field);
        JavaDocInfoGenerator.enumConstantOrdinal(buffer, field, field.getContainingClass(), "\n");
        buffer.append("</b>");
    }

    public static void enumConstantOrdinal(StringBuilder buffer, PsiField field, PsiClass parentClass, String newLine) {
        Object[] fields;
        int idx;
        if (parentClass != null && field instanceof PsiEnumConstant && (idx = ArrayUtilRt.find((Object[])(fields = parentClass.getFields()), (Object)field)) >= 0) {
            buffer.append(newLine);
            buffer.append("Enum constant ordinal: ").append(idx);
        }
    }

    private static void generateVariableJavaDoc(@NonNls StringBuilder buffer, PsiVariable variable, boolean generatePrologueAndEpilogue) {
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generatePrologue(buffer);
        }
        buffer.append("<PRE>");
        String modifiers = PsiFormatUtil.formatModifiers((PsiElement)variable, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        JavaDocInfoGenerator.generateType(buffer, variable.getType(), (PsiElement)variable);
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(variable.getName());
        JavaDocInfoGenerator.appendInitializer(buffer, variable);
        buffer.append("</b>");
        buffer.append("</PRE>");
        ColorUtil.appendColorPreview(variable, buffer);
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generateEpilogue(buffer);
        }
    }

    private static void generateFileJavaDoc(StringBuilder buffer, PsiFile file, boolean generatePrologueAndEpilogue) {
        VirtualFile virtualFile;
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generatePrologue(buffer);
        }
        if ((virtualFile = file.getVirtualFile()) != null) {
            buffer.append(virtualFile.getPresentableUrl());
        }
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generateEpilogue(buffer);
        }
    }

    private void generatePackageJavaDoc(StringBuilder buffer, PsiPackage psiPackage, boolean generatePrologueAndEpilogue) {
        for (PsiDirectory directory : psiPackage.getDirectories()) {
            ASTNode docCommentNode;
            FileASTNode node;
            PsiFile packageInfoFile = directory.findFile("package-info.java");
            if (packageInfoFile != null && (node = packageInfoFile.getNode()) != null && (docCommentNode = node.findChildByType((IElementType)JavaDocElementType.DOC_COMMENT)) != null) {
                PsiDocComment docComment = (PsiDocComment)docCommentNode.getPsi();
                if (generatePrologueAndEpilogue) {
                    JavaDocInfoGenerator.generatePrologue(buffer);
                }
                this.generateCommonSection(buffer, docComment);
                if (!generatePrologueAndEpilogue) break;
                JavaDocInfoGenerator.generateEpilogue(buffer);
                break;
            }
            PsiFile packageHtmlFile = directory.findFile("package.html");
            if (packageHtmlFile == null) continue;
            this.generatePackageHtmlJavaDoc(buffer, packageHtmlFile, generatePrologueAndEpilogue);
            break;
        }
    }

    public void generateCommonSection(StringBuilder buffer, PsiDocComment docComment) {
        this.generateDescription(buffer, docComment);
        this.generateDeprecatedSection(buffer, docComment);
        this.generateSinceSection(buffer, docComment);
        JavaDocInfoGenerator.generateSeeAlsoSection(buffer, docComment);
    }

    private void generatePackageHtmlJavaDoc(StringBuilder buffer, PsiFile packageHtmlFile, boolean generatePrologueAndEpilogue) {
        PsiDocComment docComment;
        String htmlText = packageHtmlFile.getText();
        try {
            Element subTag;
            Document document = JDOMUtil.loadDocument((InputStream)new ByteArrayInputStream(htmlText.getBytes(CharsetToolkit.UTF8_CHARSET)));
            Element rootTag = document.getRootElement();
            if (rootTag != null && (subTag = rootTag.getChild("body")) != null) {
                htmlText = subTag.getValue();
            }
        }
        catch (JDOMException ignore) {
        }
        catch (IOException ignore) {
            // empty catch block
        }
        htmlText = StringUtil.replace((String)htmlText, (String)"*/", (String)"&#42;&#47;");
        String fileText = "/** " + htmlText + " */";
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)packageHtmlFile.getProject()).getElementFactory();
        try {
            docComment = elementFactory.createDocCommentFromText(fileText);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generatePrologue(buffer);
        }
        this.generateCommonSection(buffer, docComment);
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generateEpilogue(buffer);
        }
    }

    @Nullable
    public static PsiExpression calcInitializerExpression(PsiVariable variable) {
        JavaPsiFacade instance;
        Object o;
        PsiModifierList modifierList;
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (modifierList = variable.getModifierList()) != null && modifierList.hasModifierProperty("final") && !(initializer instanceof PsiLiteralExpression) && (o = (instance = JavaPsiFacade.getInstance((Project)variable.getProject())).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) != null) {
            String text = o.toString();
            PsiType type = variable.getType();
            if (type.equalsToText("java.lang.String")) {
                text = "\"" + StringUtil.escapeLineBreak((String)StringUtil.shortenPathWithEllipsis((String)text, (int)120)) + "\"";
            } else if (type.equalsToText("char")) {
                text = "'" + text + "'";
            }
            try {
                return instance.getElementFactory().createExpressionFromText(text, (PsiElement)variable);
            }
            catch (IncorrectOperationException ex) {
                LOG.error(text, (Throwable)ex);
            }
        }
        return null;
    }

    public static boolean appendExpressionValue(StringBuilder buffer, PsiExpression initializer, String label) {
        int index;
        int index2;
        String text = initializer.getText().trim();
        int index1 = text.indexOf(10);
        if (index1 < 0) {
            index1 = text.length();
        }
        if ((index2 = text.indexOf(13)) < 0) {
            index2 = text.length();
        }
        boolean trunc = (index = Math.min(index1, index2)) < text.length();
        text = text.substring(0, index);
        buffer.append(label);
        buffer.append(StringUtil.escapeXml((String)text));
        if (trunc) {
            buffer.append("...");
        }
        return trunc;
    }

    private static void appendInitializer(StringBuilder buffer, PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null) {
            int index;
            boolean trunc;
            int index2;
            buffer.append(" = ");
            String text = initializer.getText();
            text = text.trim();
            int index1 = text.indexOf(10);
            if (index1 < 0) {
                index1 = text.length();
            }
            if ((index2 = text.indexOf(13)) < 0) {
                index2 = text.length();
            }
            boolean bl = trunc = (index = Math.min(index1, index2)) < text.length();
            if (trunc) {
                text = text.substring(0, index);
                buffer.append(StringUtil.escapeXml((String)text));
                buffer.append("...");
            } else {
                initializer.accept((PsiElementVisitor)new MyVisitor(buffer));
            }
            PsiExpression constantInitializer = JavaDocInfoGenerator.calcInitializerExpression(variable);
            if (constantInitializer != null) {
                buffer.append("\n");
                JavaDocInfoGenerator.appendExpressionValue(buffer, constantInitializer, CodeInsightBundle.message((String)"javadoc.resolved.value", (Object[])new Object[0]));
            }
        }
    }

    private static void generateAnnotations(@NonNls @NotNull StringBuilder buffer, @NotNull PsiModifierListOwner owner, boolean generateLink, boolean splitAnnotations) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator", "generateAnnotations"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator", "generateAnnotations"));
        }
        PsiModifierList ownerModifierList = owner.getModifierList();
        if (ownerModifierList == null) {
            return;
        }
        JavaDocInfoGenerator.generateAnnotations(buffer, owner, ownerModifierList.getAnnotations(), false, generateLink, splitAnnotations);
        Object[] externalAnnotations = ExternalAnnotationsManager.getInstance((Project)owner.getProject()).findExternalAnnotations(owner);
        if (externalAnnotations == null) {
            externalAnnotations = new PsiAnnotation[]{};
        }
        Object[] inferredAnnotations = InferredAnnotationsManager.getInstance((Project)owner.getProject()).findInferredAnnotations(owner);
        externalAnnotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])externalAnnotations, (Object[])inferredAnnotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY);
        JavaDocInfoGenerator.generateAnnotations(buffer, owner, (PsiAnnotation[])externalAnnotations, true, generateLink, splitAnnotations);
    }

    private static void generateAnnotations(StringBuilder buffer, PsiModifierListOwner owner, PsiAnnotation[] annotations, boolean external, boolean generateLink, boolean splitAnnotations) {
        PsiManager manager = owner.getManager();
        HashSet shownAnnotations = ContainerUtil.newHashSet();
        for (PsiAnnotation annotation : annotations) {
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null) continue;
            PsiElement resolved = nameReferenceElement.resolve();
            boolean inferred = AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
            if (!shownAnnotations.add(annotation.getQualifiedName()) && !JavaDocInfoGenerator.isRepeatableAnnotationType(resolved)) continue;
            if (resolved instanceof PsiClass) {
                PsiClass annotationType = (PsiClass)resolved;
                if (JavaDocInfoGenerator.isDocumentedAnnotationType((PsiElement)annotationType)) {
                    if (inferred) {
                        buffer.append("<i>");
                    }
                    PsiClassType type = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(annotationType, PsiSubstitutor.EMPTY);
                    buffer.append("@");
                    if (inferred && !generateLink) {
                        buffer.append(type.getPresentableText());
                    } else {
                        JavaDocInfoGenerator.generateType(buffer, (PsiType)type, (PsiElement)owner, generateLink);
                    }
                    PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                    if (attributes.length > 0) {
                        buffer.append("(");
                        boolean first = true;
                        for (PsiNameValuePair pair : attributes) {
                            PsiAnnotationMemberValue value;
                            if (!first) {
                                buffer.append(",&nbsp;");
                            }
                            first = false;
                            String name = pair.getName();
                            if (name != null) {
                                buffer.append(name);
                                buffer.append(" = ");
                            }
                            if ((value = pair.getValue()) == null) continue;
                            if (value instanceof PsiArrayInitializerMemberValue) {
                                buffer.append("{");
                                boolean firstMember = true;
                                for (PsiAnnotationMemberValue memberValue : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                                    if (!firstMember) {
                                        buffer.append(",");
                                    }
                                    firstMember = false;
                                    JavaDocInfoGenerator.appendLinkOrText(buffer, memberValue, generateLink);
                                }
                                buffer.append("}");
                                continue;
                            }
                            JavaDocInfoGenerator.appendLinkOrText(buffer, value, generateLink);
                        }
                        buffer.append(")");
                    }
                    if (inferred) {
                        buffer.append("</i>");
                    }
                    buffer.append("&nbsp;");
                }
            } else if (external) {
                if (inferred) {
                    buffer.append("<i>");
                }
                String annoText = inferred ? "@" + annotation.getNameReferenceElement().getReferenceName() + annotation.getParameterList().getText() : annotation.getText();
                buffer.append(XmlStringUtil.escapeString((String)annoText));
                if (inferred) {
                    buffer.append("</i>");
                }
                buffer.append("&nbsp;");
            } else {
                buffer.append("<font color=red>");
                buffer.append(XmlStringUtil.escapeString((String)annotation.getText()));
                buffer.append("</font>");
                buffer.append("&nbsp;");
            }
            if (!splitAnnotations) continue;
            buffer.append("\n");
        }
    }

    private static void appendLinkOrText(StringBuilder buffer, PsiAnnotationMemberValue memberValue, boolean generateLink) {
        if (generateLink && memberValue instanceof PsiQualifiedReferenceElement) {
            String text = ((PsiQualifiedReferenceElement)memberValue).getCanonicalText();
            PsiElement resolve = ((PsiQualifiedReferenceElement)memberValue).resolve();
            if (resolve instanceof PsiField) {
                PsiField field = (PsiField)resolve;
                PsiClass aClass = field.getContainingClass();
                int startOfPropertyNamePosition = text.lastIndexOf(46);
                if (startOfPropertyNamePosition != -1) {
                    text = text.substring(0, startOfPropertyNamePosition) + '#' + text.substring(startOfPropertyNamePosition + 1);
                } else if (aClass != null) {
                    text = aClass.getQualifiedName() + '#' + field.getName();
                }
                JavaDocInfoGenerator.generateLink(buffer, text, aClass != null ? aClass.getName() + '.' + field.getName() : null, (PsiElement)memberValue, false);
                return;
            }
        }
        buffer.append(XmlStringUtil.escapeString((String)memberValue.getText()));
    }

    public static boolean isDocumentedAnnotationType(@Nullable PsiElement annotationType) {
        return annotationType instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)annotationType), (String)"java.lang.annotation.Documented", (boolean)false);
    }

    public static boolean isRepeatableAnnotationType(@Nullable PsiElement annotationType) {
        return annotationType instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)annotationType), (String)"java.lang.annotation.Repeatable", (boolean)false, (boolean)true);
    }

    private void generateMethodParameterJavaDoc(@NonNls StringBuilder buffer, PsiParameter parameter, boolean generatePrologueAndEpilogue) {
        PsiElement[] elements;
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tagInfoProvider;
        PsiDocComment docComment;
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generatePrologue(buffer);
        }
        buffer.append("<PRE>");
        String modifiers = PsiFormatUtil.formatModifiers((PsiElement)parameter, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)parameter, true, true);
        JavaDocInfoGenerator.generateType(buffer, parameter.getType(), (PsiElement)parameter);
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(parameter.getName());
        JavaDocInfoGenerator.appendInitializer(buffer, (PsiVariable)parameter);
        buffer.append("</b>");
        buffer.append("</PRE>");
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method != null && (docComment = JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)method)) != null && (tagInfoProvider = this.findDocTag(docComment.getTags(), parameter.getName(), method)) != null && (elements = ((PsiDocTag)tagInfoProvider.first).getDataElements()).length != 0) {
            this.generateOneParameter(elements, buffer, tagInfoProvider);
        }
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generateEpilogue(buffer);
        }
    }

    private void generateMethodJavaDoc(@NonNls StringBuilder buffer, PsiMethod method, boolean generatePrologueAndEpilogue) {
        String qName;
        PsiClass parentClass;
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generatePrologue(buffer);
        }
        if ((parentClass = method.getContainingClass()) != null && (qName = parentClass.getQualifiedName()) != null) {
            buffer.append("<small><b>");
            JavaDocInfoGenerator.generateLink(buffer, qName, qName, (PsiElement)method, false);
            buffer.append("</b></small>");
        }
        buffer.append("<PRE>");
        JavaDocInfoGenerator.generateMethodSignature(buffer, method, true);
        buffer.append("</PRE>");
        PsiDocComment comment = this.getMethodDocComment(method);
        this.generateMethodDescription(buffer, method, comment);
        JavaDocInfoGenerator.generateSuperMethodsSection(buffer, method, false);
        JavaDocInfoGenerator.generateSuperMethodsSection(buffer, method, true);
        if (comment != null) {
            this.generateDeprecatedSection(buffer, comment);
        }
        this.generateParametersSection(buffer, method, comment);
        this.generateTypeParametersSection(buffer, method);
        this.generateReturnsSection(buffer, method, comment);
        this.generateThrowsSection(buffer, method, comment);
        if (comment != null) {
            this.generateSinceSection(buffer, comment);
            JavaDocInfoGenerator.generateSeeAlsoSection(buffer, comment);
        }
        if (generatePrologueAndEpilogue) {
            JavaDocInfoGenerator.generateEpilogue(buffer);
        }
    }

    private static void generateMethodSignature(StringBuilder buffer, PsiMethod method, boolean generateLink) {
        int j;
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)method, generateLink, true);
        String modifiers = PsiFormatUtil.formatModifiers((PsiElement)method, (int)16384);
        int indent = 0;
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append("&nbsp;");
            indent += modifiers.length() + 1;
        }
        String typeParamsString = JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)method);
        indent += StringUtil.unescapeXml((String)StringUtil.stripHtml((String)typeParamsString, (boolean)true)).length();
        if (!typeParamsString.isEmpty()) {
            buffer.append(typeParamsString);
            buffer.append("&nbsp;");
            ++indent;
        }
        if (method.getReturnType() != null) {
            indent += JavaDocInfoGenerator.generateType(buffer, method.getReturnType(), (PsiElement)method, generateLink);
            buffer.append("&nbsp;");
            ++indent;
        }
        buffer.append("<b>");
        String name = method.getName();
        buffer.append(name);
        buffer.append("</b>");
        indent += name.length();
        buffer.append("(");
        PsiParameter[] parms = method.getParameterList().getParameters();
        for (int i = 0; i < parms.length; ++i) {
            PsiParameter parm = parms[i];
            JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)parm, generateLink, false);
            JavaDocInfoGenerator.generateType(buffer, parm.getType(), (PsiElement)method, generateLink);
            buffer.append("&nbsp;");
            if (parm.getName() != null) {
                buffer.append(parm.getName());
            }
            if (i >= parms.length - 1) continue;
            buffer.append(",\n ");
            for (j = 0; j < indent; ++j) {
                buffer.append(" ");
            }
        }
        buffer.append(")");
        PsiClassType[] refs = method.getThrowsList().getReferencedTypes();
        if (refs.length > 0) {
            int i;
            buffer.append("\n");
            indent -= THROWS_KEYWORD.length() + 1;
            for (i = 0; i < indent; ++i) {
                buffer.append(" ");
            }
            indent += THROWS_KEYWORD.length() + 1;
            buffer.append(THROWS_KEYWORD);
            buffer.append("&nbsp;");
            for (i = 0; i < refs.length; ++i) {
                JavaDocInfoGenerator.generateLink(buffer, refs[i].getCanonicalText(), null, (PsiElement)method, false);
                if (i >= refs.length - 1) continue;
                buffer.append(",\n");
                for (j = 0; j < indent; ++j) {
                    buffer.append(" ");
                }
            }
        }
    }

    private PsiDocComment getMethodDocComment(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        if (parentClass != null && parentClass.isEnum()) {
            PsiType psiType;
            PsiParameterList parameterList = method.getParameterList();
            if (method.getName().equals("values") && parameterList.getParametersCount() == 0) {
                return this.loadSyntheticDocComment(method, "/javadoc/EnumValues.java.template");
            }
            if (method.getName().equals("valueOf") && parameterList.getParametersCount() == 1 && (psiType = parameterList.getParameters()[0].getType()).equalsToText("java.lang.String")) {
                return this.loadSyntheticDocComment(method, "/javadoc/EnumValueOf.java.template");
            }
        }
        return JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiDocComment loadSyntheticDocComment(PsiMethod method, String resourceName) {
        StringBuilder buffer;
        InputStream commentStream = JavaDocInfoGenerator.class.getResourceAsStream(resourceName);
        if (commentStream == null) {
            return null;
        }
        try {
            buffer = new StringBuilder();
            try {
                int ch;
                while ((ch = commentStream.read()) != -1) {
                    buffer.append((char)ch);
                }
            }
            catch (IOException e) {
                PsiDocComment psiDocComment = null;
                try {
                    commentStream.close();
                }
                catch (IOException e2) {
                    LOG.error((Throwable)e2);
                }
                return psiDocComment;
            }
        }
        finally {
            try {
                commentStream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        String s = buffer.toString();
        s = StringUtil.replace((String)s, (String)"<ClassName>", (String)method.getContainingClass().getName());
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        try {
            return elementFactory.createDocCommentFromText(s);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static void generatePrologue(StringBuilder buffer) {
        buffer.append("<html><head>    <style type=\"text/css\">        #error {            background-color: #eeeeee;            margin-bottom: 10px;        }        p {            margin: 5px 0;        }    </style></head><body>");
    }

    private static void generateEpilogue(StringBuilder buffer) {
        while (buffer.length() >= BR_TAG.length()) {
            char c = buffer.charAt(buffer.length() - 1);
            if (c == '\n' || c == '\r' || c == ' ' || c == '\t') {
                buffer.setLength(buffer.length() - 1);
                continue;
            }
            String tail = buffer.substring(buffer.length() - BR_TAG.length());
            if (!tail.equalsIgnoreCase(BR_TAG)) break;
            buffer.setLength(buffer.length() - BR_TAG.length());
        }
        buffer.append("</body></html>");
    }

    private void generateDescription(StringBuilder buffer, PsiDocComment comment) {
        PsiElement[] elements = comment.getDescriptionElements();
        this.generateValue(buffer, elements, ourEmptyElementsProvider);
    }

    private static boolean isEmptyDescription(PsiDocComment comment) {
        PsiElement[] descriptionElements;
        if (comment == null) {
            return true;
        }
        for (PsiElement description : descriptionElements = comment.getDescriptionElements()) {
            String text = description.getText();
            if (text == null || ourWhitespaces.matcher(text).replaceAll("").isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void generateMethodDescription(@NonNls StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        final DocTagLocator<PsiElement[]> descriptionLocator = new DocTagLocator<PsiElement[]>(){

            @Override
            public PsiElement[] find(PsiDocComment comment) {
                if (comment == null) {
                    return null;
                }
                if (JavaDocInfoGenerator.isEmptyDescription(comment)) {
                    return null;
                }
                return comment.getDescriptionElements();
            }
        };
        if (comment != null && !JavaDocInfoGenerator.isEmptyDescription(comment)) {
            this.generateValue(buffer, comment.getDescriptionElements(), new InheritDocProvider<PsiElement[]>(){

                @Override
                public Pair<PsiElement[], InheritDocProvider<PsiElement[]>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(method, descriptionLocator);
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            });
            return;
        }
        Pair<PsiElement[], InheritDocProvider<PsiElement[]>> pair = this.findInheritDocTag(method, descriptionLocator);
        if (pair != null) {
            PsiElement[] elements = (PsiElement[])pair.first;
            PsiClass extendee = ((InheritDocProvider)pair.second).getElement();
            if (elements != null) {
                buffer.append("<DD><DL>");
                buffer.append("<DT><b>");
                buffer.append(extendee.isInterface() ? CodeInsightBundle.message((String)"javadoc.description.copied.from.interface", (Object[])new Object[0]) : CodeInsightBundle.message((String)"javadoc.description.copied.from.class", (Object[])new Object[0]));
                buffer.append("</b>&nbsp;");
                JavaDocInfoGenerator.generateLink(buffer, (PsiElement)extendee, JavaDocUtil.getShortestClassName(extendee, (PsiElement)method), false);
                buffer.append(BR_TAG);
                this.generateValue(buffer, elements, (InheritDocProvider)pair.second);
                buffer.append("</DD></DL></DD>");
            }
        }
    }

    private void generateValue(StringBuilder buffer, PsiElement[] elements, InheritDocProvider<PsiElement[]> provider) {
        this.generateValue(buffer, elements, 0, provider);
    }

    private String getDocRoot() {
        PsiClass aClass = this.myElement instanceof PsiClass ? (PsiClass)this.myElement : (this.myElement instanceof PsiMember ? ((PsiMember)this.myElement).getContainingClass() : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiClass.class));
        if (aClass == null) {
            return "";
        }
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return "";
        }
        return "../" + ourNotDot.matcher(qName).replaceAll("").replaceAll(".", "../");
    }

    private void generateValue(StringBuilder buffer, PsiElement[] elements, int startIndex, InheritDocProvider<PsiElement[]> provider) {
        int predictOffset = startIndex < elements.length ? elements[startIndex].getTextOffset() + elements[startIndex].getText().length() : 0;
        for (int i = startIndex; i < elements.length; ++i) {
            if (elements[i].getTextOffset() > predictOffset) {
                buffer.append(" ");
            }
            predictOffset = elements[i].getTextOffset() + elements[i].getText().length();
            PsiElement element = elements[i];
            if (element instanceof PsiInlineDocTag) {
                PsiInlineDocTag tag = (PsiInlineDocTag)element;
                String tagName = tag.getName();
                if (tagName.equals(LINK_TAG)) {
                    JavaDocInfoGenerator.generateLinkValue(tag, buffer, false);
                    continue;
                }
                if (tagName.equals(LITERAL_TAG)) {
                    PsiElement[] dataElements = tag instanceof PsiInlineDocTagImpl ? ((PsiInlineDocTagImpl)tag).getDataElementsIgnoreWhitespaces() : tag.getDataElements();
                    JavaDocInfoGenerator.generateLiteralValue(buffer, dataElements);
                    continue;
                }
                if (tagName.equals(CODE_TAG)) {
                    JavaDocInfoGenerator.generateCodeValue(tag, buffer);
                    continue;
                }
                if (tagName.equals(LINKPLAIN_TAG)) {
                    JavaDocInfoGenerator.generateLinkValue(tag, buffer, true);
                    continue;
                }
                if (tagName.equals(INHERITDOC_TAG)) {
                    Pair<PsiElement[], InheritDocProvider<PsiElement[]>> inheritInfo = provider.getInheritDoc();
                    if (inheritInfo == null) continue;
                    this.generateValue(buffer, (PsiElement[])inheritInfo.first, (InheritDocProvider)inheritInfo.second);
                    continue;
                }
                if (tagName.equals(DOCROOT_TAG)) {
                    buffer.append(this.getDocRoot());
                    continue;
                }
                if (tagName.equals(VALUE_TAG)) {
                    this.generateValueValue(tag, buffer, element);
                    continue;
                }
                buffer.append(element.getText());
                continue;
            }
            buffer.append(element.getText());
        }
    }

    private static void generateCodeValue(PsiInlineDocTag tag, StringBuilder buffer) {
        buffer.append("<code>");
        JavaDocInfoGenerator.generateLiteralValue(buffer, tag.getDataElements());
        buffer.append("</code>");
    }

    private static void generateLiteralValue(StringBuilder buffer, PsiElement[] dataElements) {
        for (PsiElement element : dataElements) {
            JavaDocInfoGenerator.appendPlainText(element.getText(), buffer);
        }
    }

    private static void appendPlainText(@NonNls String text, StringBuilder buffer) {
        text = text.replaceAll("<", LT);
        text = text.replaceAll(">", GT);
        buffer.append(text);
    }

    private static void generateLinkValue(PsiInlineDocTag tag, StringBuilder buffer, boolean plainLink) {
        PsiElement[] tagElements = tag.getDataElements();
        String text = JavaDocInfoGenerator.createLinkText(tagElements);
        if (!text.isEmpty()) {
            int index = JavaDocUtil.extractReference(text);
            String refText = text.substring(0, index).trim();
            String label = text.substring(index).trim();
            if (label.isEmpty()) {
                label = null;
            }
            JavaDocInfoGenerator.generateLink(buffer, refText, label, tagElements[0], plainLink);
        }
    }

    private void generateValueValue(PsiInlineDocTag tag, StringBuilder buffer, PsiElement element) {
        String text = JavaDocInfoGenerator.createLinkText(tag.getDataElements());
        PsiField valueField = null;
        if (text.isEmpty()) {
            if (this.myElement instanceof PsiField) {
                valueField = (PsiField)this.myElement;
            }
        } else {
            PsiElement target = JavaDocUtil.findReferenceTarget(PsiManager.getInstance((Project)this.myProject), text, this.myElement);
            if (target instanceof PsiField) {
                valueField = (PsiField)target;
            }
        }
        Object value = null;
        if (valueField != null) {
            PsiExpression initializer = valueField.getInitializer();
            value = JavaConstantExpressionEvaluator.computeConstantExpression(initializer, false);
        }
        if (value != null) {
            buffer.append(value);
        } else {
            buffer.append(element.getText());
        }
    }

    private static String createLinkText(PsiElement[] tagElements) {
        int predictOffset = tagElements.length > 0 ? tagElements[0].getTextOffset() + tagElements[0].getText().length() : 0;
        StringBuilder buffer1 = new StringBuilder();
        for (int j = 0; j < tagElements.length; ++j) {
            PsiElement tagElement = tagElements[j];
            if (tagElement.getTextOffset() > predictOffset) {
                buffer1.append(" ");
            }
            predictOffset = tagElement.getTextOffset() + tagElement.getText().length();
            buffer1.append(tagElement.getText());
            if (j >= tagElements.length - 1) continue;
            buffer1.append(" ");
        }
        return buffer1.toString().trim();
    }

    private void generateDeprecatedSection(StringBuilder buffer, PsiDocComment comment) {
        PsiDocTag tag = comment.findTagByName("deprecated");
        if (tag != null) {
            buffer.append("<DD><DL>");
            buffer.append("<B>").append(CodeInsightBundle.message((String)"javadoc.deprecated", (Object[])new Object[0])).append("</B>&nbsp;");
            buffer.append("<I>");
            this.generateValue(buffer, tag.getDataElements(), ourEmptyElementsProvider);
            buffer.append("</I>");
            buffer.append("</DL></DD>");
        }
    }

    private void generateSinceSection(StringBuilder buffer, PsiDocComment comment) {
        PsiDocTag tag = comment.findTagByName("since");
        if (tag != null) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.since", (Object[])new Object[0])).append("</b>");
            buffer.append("<DD>");
            this.generateValue(buffer, tag.getDataElements(), ourEmptyElementsProvider);
            buffer.append("</DD></DL></DD>");
        }
    }

    private static void generateSeeAlsoSection(StringBuilder buffer, PsiDocComment comment) {
        PsiDocTag[] tags = comment.findTagsByName("see");
        if (tags.length > 0) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.see.also", (Object[])new Object[0])).append("</b>");
            buffer.append("<DD>");
            for (int i = 0; i < tags.length; ++i) {
                PsiDocTag tag = tags[i];
                PsiElement[] elements = tag.getDataElements();
                if (elements.length > 0) {
                    String text = JavaDocInfoGenerator.createLinkText(elements);
                    if (text.startsWith("<")) {
                        buffer.append(text);
                    } else if (text.startsWith("\"")) {
                        JavaDocInfoGenerator.appendPlainText(text, buffer);
                    } else {
                        int index = JavaDocUtil.extractReference(text);
                        String refText = text.substring(0, index).trim();
                        String label = text.substring(index).trim();
                        if (label.isEmpty()) {
                            label = null;
                        }
                        JavaDocInfoGenerator.generateLink(buffer, refText, label, (PsiElement)comment, false);
                    }
                }
                if (i >= tags.length - 1) continue;
                buffer.append(",\n");
            }
            buffer.append("</DD></DL></DD>");
        }
    }

    private void generateParametersSection(StringBuilder buffer, PsiMethod method, PsiDocComment comment) {
        PsiParameter[] params = method.getParameterList().getParameters();
        PsiDocTag[] localTags = comment != null ? comment.findTagsByName("param") : PsiDocTag.EMPTY_ARRAY;
        LinkedList<Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>> collectedTags = new LinkedList<Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>>();
        for (PsiParameter param : params) {
            String paramName = param.getName();
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> parmTag = this.findDocTag(localTags, paramName, method);
            if (parmTag == null) continue;
            collectedTags.addLast(parmTag);
        }
        if (!collectedTags.isEmpty()) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0])).append("</b>");
            for (Pair pair : collectedTags) {
                PsiElement[] elements = ((PsiDocTag)pair.first).getDataElements();
                if (elements.length == 0) continue;
                this.generateOneParameter(elements, buffer, (Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>)pair);
            }
            buffer.append("</DD></DL></DD>");
        }
    }

    private void generateTypeParametersSection(StringBuilder buffer, PsiMethod method) {
        PsiDocComment docComment = method.getDocComment();
        if (docComment == null) {
            return;
        }
        PsiDocTag[] localTags = docComment.findTagsByName("param");
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        LinkedList<Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>> collectedTags = new LinkedList<Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>>();
        for (PsiTypeParameter typeParameter : typeParameters) {
            String paramName = "<" + typeParameter.getName() + ">";
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> parmTag = this.findDocTag(localTags, paramName, method);
            if (parmTag == null) continue;
            collectedTags.addLast(parmTag);
        }
        this.generateTypeParametersSection(buffer, collectedTags);
    }

    private void generateTypeParametersSection(StringBuilder buffer, LinkedList<Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>> collectedTags) {
        if (!collectedTags.isEmpty()) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.type.parameters", (Object[])new Object[0])).append("</b>");
            for (Pair pair : collectedTags) {
                PsiElement[] elements = ((PsiDocTag)pair.first).getDataElements();
                if (elements.length == 0) continue;
                this.generateOneParameter(elements, buffer, (Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>)pair);
            }
            buffer.append("</DD></DL></DD>");
        }
    }

    @Nullable
    private Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> findDocTag(PsiDocTag[] localTags, final String paramName, final PsiMethod method) {
        Pair parmTag = null;
        for (PsiDocTag localTag : localTags) {
            String tagName;
            PsiDocTagValue value = localTag.getValueElement();
            if (value == null || (tagName = value.getText()) == null || !tagName.equals(paramName)) continue;
            parmTag = new Pair((Object)localTag, (Object)new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(method, JavaDocInfoGenerator.parameterLocator(paramName));
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            });
            break;
        }
        if (parmTag == null) {
            parmTag = this.findInheritDocTag(method, JavaDocInfoGenerator.parameterLocator(paramName));
        }
        return parmTag;
    }

    private void generateOneParameter(PsiElement[] elements, StringBuilder buffer, Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tag) {
        String text = elements[0].getText();
        buffer.append("<DD>");
        int spaceIndex = text.indexOf(32);
        if (spaceIndex < 0) {
            spaceIndex = text.length();
        }
        String parmName = text.substring(0, spaceIndex);
        buffer.append("<code>");
        buffer.append(StringUtil.escapeXml((String)parmName));
        buffer.append("</code>");
        buffer.append(" - ");
        buffer.append(text.substring(spaceIndex));
        this.generateValue(buffer, elements, 1, JavaDocInfoGenerator.mapProvider((InheritDocProvider)tag.second, true));
    }

    private void generateReturnsSection(StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair;
        PsiDocTag tag = comment == null ? null : comment.findTagByName("return");
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair2 = pair = tag == null ? null : new Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>((Object)tag, (Object)new InheritDocProvider<PsiDocTag>(){

            @Override
            public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                return JavaDocInfoGenerator.this.findInheritDocTag(method, new ReturnTagLocator());
            }

            @Override
            public PsiClass getElement() {
                return method.getContainingClass();
            }
        });
        if (pair == null && this.myElement instanceof PsiMethod) {
            pair = this.findInheritDocTag((PsiMethod)this.myElement, new ReturnTagLocator());
        }
        if (pair != null) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0])).append("</b>");
            buffer.append("<DD>");
            this.generateValue(buffer, ((PsiDocTag)pair.first).getDataElements(), JavaDocInfoGenerator.mapProvider((InheritDocProvider)pair.second, false));
            buffer.append("</DD></DL></DD>");
        }
    }

    private static PsiDocTag[] getThrowsTags(PsiDocComment comment) {
        if (comment == null) {
            return PsiDocTag.EMPTY_ARRAY;
        }
        Object[] tags1 = comment.findTagsByName(THROWS_KEYWORD);
        Object[] tags2 = comment.findTagsByName("exception");
        return (PsiDocTag[])ArrayUtil.mergeArrays((Object[])tags1, (Object[])tags2);
    }

    private static boolean areWeakEqual(String one, String two) {
        return one.equals(two) || one.endsWith("." + two) || two.endsWith("." + one);
    }

    private void generateThrowsSection(StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        PsiClassType[] trousers;
        PsiDocTag[] localTags = JavaDocInfoGenerator.getThrowsTags(comment);
        LinkedList<Pair> collectedTags = new LinkedList<Pair>();
        ArrayList<PsiClassType> declaredThrows = new ArrayList<PsiClassType>(Arrays.asList(method.getThrowsList().getReferencedTypes()));
        for (int i = localTags.length - 1; i > -1; --i) {
            PsiDocTagValue valueElement = localTags[i].getValueElement();
            if (valueElement == null) continue;
            Iterator iterator = declaredThrows.iterator();
            while (iterator.hasNext()) {
                PsiClassType classType = (PsiClassType)iterator.next();
                if (!Comparing.strEqual((String)valueElement.getText(), (String)classType.getClassName()) && !Comparing.strEqual((String)valueElement.getText(), (String)classType.getCanonicalText())) continue;
                iterator.remove();
                break;
            }
            final Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tag = this.findInheritDocTag(method, JavaDocInfoGenerator.exceptionLocator(valueElement.getText()));
            collectedTags.addFirst(new Pair((Object)localTags[i], (Object)new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return tag;
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            }));
        }
        for (PsiClassType trouser : trousers = declaredThrows.toArray(new PsiClassType[declaredThrows.size()])) {
            if (trouser == null) continue;
            String paramName = trouser.getCanonicalText();
            Pair parmTag = null;
            for (PsiDocTag localTag : localTags) {
                String tagName;
                PsiDocTagValue value = localTag.getValueElement();
                if (value == null || (tagName = value.getText()) == null || !JavaDocInfoGenerator.areWeakEqual(tagName, paramName)) continue;
                parmTag = Pair.create((Object)localTag, ourEmptyProvider);
                break;
            }
            if (parmTag == null) {
                parmTag = this.findInheritDocTag(method, JavaDocInfoGenerator.exceptionLocator(paramName));
            }
            if (parmTag != null) {
                collectedTags.addLast(parmTag);
                continue;
            }
            try {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
                PsiDocTag tag = elementFactory.createDocTagFromText("@exception " + paramName);
                collectedTags.addLast(Pair.create((Object)tag, ourEmptyProvider));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!collectedTags.isEmpty()) {
            buffer.append("<DD><DL>");
            buffer.append("<DT><b>").append(CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0])).append("</b>");
            for (Pair tag : collectedTags) {
                PsiElement[] elements = ((PsiDocTag)tag.first).getDataElements();
                if (elements.length == 0) continue;
                buffer.append("<DD>");
                String text = elements[0].getText();
                int index = JavaDocUtil.extractReference(text);
                String refText = text.substring(0, index).trim();
                JavaDocInfoGenerator.generateLink(buffer, refText, null, (PsiElement)method, false);
                String rest = text.substring(index);
                if (!rest.isEmpty() || elements.length > 1) {
                    buffer.append(" - ");
                }
                buffer.append(rest);
                this.generateValue(buffer, elements, 1, JavaDocInfoGenerator.mapProvider((InheritDocProvider)tag.second, true));
            }
            buffer.append("</DD></DL></DD>");
        }
    }

    private static void generateSuperMethodsSection(StringBuilder buffer, PsiMethod method, boolean overrides) {
        PsiClass parentClass = method.getContainingClass();
        if (parentClass == null) {
            return;
        }
        if (parentClass.isInterface() && !overrides) {
            return;
        }
        PsiMethod[] supers = method.findSuperMethods();
        if (supers.length == 0) {
            return;
        }
        boolean headerGenerated = false;
        for (PsiMethod superMethod : supers) {
            PsiClass superClass;
            boolean isAbstract = superMethod.hasModifierProperty("abstract");
            if ((!overrides ? !isAbstract : (parentClass.isInterface() ? !isAbstract : isAbstract)) || (superClass = superMethod.getContainingClass()) == null) continue;
            if (!headerGenerated) {
                buffer.append("<DD><DL>");
                buffer.append("<DT><b>");
                buffer.append(overrides ? CodeInsightBundle.message((String)"javadoc.method.overrides", (Object[])new Object[0]) : CodeInsightBundle.message((String)"javadoc.method.specified.by", (Object[])new Object[0]));
                buffer.append("</b>");
                headerGenerated = true;
            }
            buffer.append("<DD>");
            StringBuilder methodBuffer = new StringBuilder();
            JavaDocInfoGenerator.generateLink(methodBuffer, (PsiElement)superMethod, superMethod.getName(), false);
            StringBuilder classBuffer = new StringBuilder();
            JavaDocInfoGenerator.generateLink(classBuffer, (PsiElement)superClass, superClass.getName(), false);
            if (superClass.isInterface()) {
                buffer.append(CodeInsightBundle.message((String)"javadoc.method.in.interface", (Object[])new Object[]{methodBuffer.toString(), classBuffer.toString()}));
                continue;
            }
            buffer.append(CodeInsightBundle.message((String)"javadoc.method.in.class", (Object[])new Object[]{methodBuffer.toString(), classBuffer.toString()}));
        }
        if (headerGenerated) {
            buffer.append("</DD></DL></DD>");
        }
    }

    private static void generateLink(StringBuilder buffer, PsiElement element, String label, boolean plainLink) {
        String refText = JavaDocUtil.getReferenceText(element.getProject(), element);
        if (refText != null) {
            DocumentationManagerUtil.createHyperlink(buffer, element, refText, label, plainLink);
        }
    }

    private static int generateLink(StringBuilder buffer, String refText, String label, @NotNull PsiElement context, boolean plainLink) {
        boolean isBrokenLink;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator", "generateLink"));
        }
        if (label == null) {
            PsiManager manager = context.getManager();
            label = JavaDocUtil.getLabelText(manager.getProject(), manager, refText, context);
        }
        LOG.assertTrue(refText != null, (Object)"refText appears to be null.");
        PsiElement target = JavaDocUtil.findReferenceTarget(context.getManager(), refText, context);
        boolean bl = isBrokenLink = target == null;
        if (isBrokenLink) {
            buffer.append("<font color=red>");
            buffer.append(label);
            buffer.append("</font>");
            return StringUtil.stripHtml((String)label, (boolean)true).length();
        }
        JavaDocInfoGenerator.generateLink(buffer, target, label, plainLink);
        return StringUtil.stripHtml((String)label, (boolean)true).length();
    }

    public static int generateType(StringBuilder buffer, PsiType type, PsiElement context) {
        return JavaDocInfoGenerator.generateType(buffer, type, context, true);
    }

    public static int generateType(StringBuilder buffer, PsiType type, PsiElement context, boolean generateLink) {
        if (type instanceof PsiPrimitiveType) {
            String text = StringUtil.escapeXml((String)type.getCanonicalText());
            buffer.append(text);
            return text.length();
        }
        if (type instanceof PsiArrayType) {
            int rest = JavaDocInfoGenerator.generateType(buffer, ((PsiArrayType)type).getComponentType(), context, generateLink);
            if (type instanceof PsiEllipsisType) {
                buffer.append("...");
                return rest + 3;
            }
            buffer.append("[]");
            return rest + 2;
        }
        if (type instanceof PsiCapturedWildcardType) {
            type = ((PsiCapturedWildcardType)type).getWildcard();
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wt = (PsiWildcardType)type;
            buffer.append("?");
            PsiType bound = wt.getBound();
            if (bound != null) {
                String keyword = wt.isExtends() ? " extends " : " super ";
                buffer.append(keyword);
                return JavaDocInfoGenerator.generateType(buffer, bound, context, generateLink) + 1 + keyword.length();
            }
            return 1;
        }
        if (type instanceof PsiClassType) {
            int length;
            PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
            PsiClass psiClass = result.getElement();
            PsiSubstitutor psiSubst = result.getSubstitutor();
            if (psiClass == null) {
                String canonicalText = type.getCanonicalText();
                String text = "<font color=red>" + StringUtil.escapeXml((String)canonicalText) + "</font>";
                buffer.append(text);
                return canonicalText.length();
            }
            String qName = psiClass.getQualifiedName();
            if (qName == null || psiClass instanceof PsiTypeParameter) {
                String text = StringUtil.escapeXml((String)type.getCanonicalText());
                buffer.append(text);
                return text.length();
            }
            if (generateLink) {
                length = JavaDocInfoGenerator.generateLink(buffer, qName, null, context, false);
            } else {
                buffer.append(qName);
                length = buffer.length();
            }
            if (psiClass.hasTypeParameters()) {
                StringBuilder subst = new StringBuilder();
                PsiTypeParameter[] params = psiClass.getTypeParameters();
                subst.append(LT);
                ++length;
                boolean goodSubst = true;
                for (int i = 0; i < params.length; ++i) {
                    PsiType t = psiSubst.substitute(params[i]);
                    if (t == null) {
                        goodSubst = false;
                        break;
                    }
                    length += JavaDocInfoGenerator.generateType(subst, t, context, generateLink);
                    if (i >= params.length - 1) continue;
                    subst.append(", ");
                }
                subst.append(GT);
                ++length;
                if (goodSubst) {
                    String text = subst.toString();
                    buffer.append(text);
                }
            }
            return length;
        }
        if (type instanceof PsiDisjunctionType || type instanceof PsiIntersectionType) {
            if (!generateLink) {
                String canonicalText = type.getCanonicalText();
                String text = StringUtil.escapeXml((String)canonicalText);
                buffer.append(text);
                return canonicalText.length();
            }
            String separator = type instanceof PsiDisjunctionType ? " | " : " & ";
            List<PsiType> componentTypes = type instanceof PsiIntersectionType ? Arrays.asList(((PsiIntersectionType)type).getConjuncts()) : ((PsiDisjunctionType)type).getDisjunctions();
            int length = 0;
            for (PsiType psiType : componentTypes) {
                if (length > 0) {
                    buffer.append(separator);
                    length += 3;
                }
                length += JavaDocInfoGenerator.generateType(buffer, psiType, context, generateLink);
            }
            return length;
        }
        return 0;
    }

    private static String generateTypeParameters(PsiTypeParameterListOwner owner) {
        if (owner.hasTypeParameters()) {
            PsiTypeParameter[] parms = owner.getTypeParameters();
            StringBuilder buffer = new StringBuilder();
            buffer.append(LT);
            for (int i = 0; i < parms.length; ++i) {
                PsiTypeParameter p = parms[i];
                buffer.append(p.getName());
                PsiClassType[] refs = JavaDocUtil.getExtendsList((PsiClass)p);
                if (refs.length > 0) {
                    buffer.append(" extends ");
                    for (int j = 0; j < refs.length; ++j) {
                        JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[j], (PsiElement)owner);
                        if (j >= refs.length - 1) continue;
                        buffer.append(" & ");
                    }
                }
                if (i >= parms.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(GT);
            return buffer.toString();
        }
        return "";
    }

    private <T> Pair<T, InheritDocProvider<T>> searchDocTagInOverridenMethod(PsiMethod method, final PsiClass aSuper, final DocTagLocator<T> loc) {
        T tag;
        PsiMethod overriden;
        if (aSuper != null && (overriden = JavaDocInfoGenerator.findMethodInSuperClass(method, aSuper)) != null && (tag = loc.find(JavaDocInfoGenerator.getDocComment((PsiDocCommentOwner)overriden))) != null) {
            return new Pair(tag, (Object)new InheritDocProvider<T>(){

                @Override
                public Pair<T, InheritDocProvider<T>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(overriden, loc);
                }

                @Override
                public PsiClass getElement() {
                    return aSuper;
                }
            });
        }
        return null;
    }

    @Nullable
    private static PsiMethod findMethodInSuperClass(PsiMethod method, PsiClass aSuper) {
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            PsiMethod overriden = aSuper.findMethodBySignature(superMethod, false);
            if (overriden == null) continue;
            return overriden;
        }
        return null;
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> searchDocTagInSupers(PsiClassType[] supers, PsiMethod method, DocTagLocator<T> loc, Set<PsiClass> visitedClasses) {
        Pair<T, InheritDocProvider<T>> tag;
        PsiClass aSuper;
        for (PsiClassType superType : supers) {
            aSuper = superType.resolve();
            if (aSuper == null || (tag = this.searchDocTagInOverridenMethod(method, aSuper, loc)) == null) continue;
            return tag;
        }
        for (PsiClassType superType : supers) {
            aSuper = superType.resolve();
            if (aSuper == null || !visitedClasses.add(aSuper) || (tag = this.findInheritDocTagInClass(method, aSuper, loc, visitedClasses)) == null) continue;
            return tag;
        }
        return null;
    }

    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTagInClass(PsiMethod aMethod, PsiClass aClass, DocTagLocator<T> loc, Set<PsiClass> visitedClasses) {
        if (aClass == null) {
            return null;
        }
        PsiClassType[] implementsTypes = aClass.getImplementsListTypes();
        Pair<T, InheritDocProvider<T>> tag = this.searchDocTagInSupers(implementsTypes, aMethod, loc, visitedClasses);
        if (tag != null) {
            return tag;
        }
        PsiClassType[] extendsTypes = aClass.getExtendsListTypes();
        return this.searchDocTagInSupers(extendsTypes, aMethod, loc, visitedClasses);
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTag(PsiMethod method, DocTagLocator<T> loc) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        return this.findInheritDocTagInClass(method, aClass, loc, new HashSet<PsiClass>());
    }

    private static class MyVisitor
    extends JavaElementVisitor {
        @NotNull
        private final StringBuilder myBuffer;

        MyVisitor(@NotNull StringBuilder buffer) {
            if (buffer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator$MyVisitor", "<init>"));
            }
            this.myBuffer = buffer;
        }

        public void visitNewExpression(PsiNewExpression expression) {
            this.myBuffer.append("new ");
            PsiType type = expression.getType();
            if (type != null) {
                JavaDocInfoGenerator.generateType(this.myBuffer, type, (PsiElement)expression);
            }
            this.myBuffer.append("(");
            expression.acceptChildren((PsiElementVisitor)this);
            this.myBuffer.append(")");
        }

        public void visitExpressionList(PsiExpressionList list) {
            PsiExpression[] expressions;
            String separator = ", ";
            for (PsiExpression expression : expressions = list.getExpressions()) {
                expression.accept((PsiElementVisitor)this);
                this.myBuffer.append(separator);
            }
            if (expressions.length > 0) {
                this.myBuffer.setLength(this.myBuffer.length() - separator.length());
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            this.myBuffer.append(expression.getMethodExpression().getText()).append("(");
            expression.getArgumentList().accept((PsiElementVisitor)this);
            this.myBuffer.append(")");
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            this.myBuffer.append(StringUtil.escapeXml((String)expression.getText()));
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.myBuffer.append(StringUtil.escapeXml((String)expression.getText()));
        }
    }

    private static class ReturnTagLocator
    implements DocTagLocator<PsiDocTag> {
        private ReturnTagLocator() {
        }

        @Override
        public PsiDocTag find(PsiDocComment comment) {
            if (comment == null) {
                return null;
            }
            return comment.findTagByName("return");
        }
    }

    static interface DocTagLocator<T> {
        public T find(PsiDocComment var1);
    }

    static interface InheritDocProvider<T> {
        public Pair<T, InheritDocProvider<T>> getInheritDoc();

        public PsiClass getElement();
    }
}

