/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.google.common.base.Strings;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.LoremNode;
import com.intellij.codeInsight.template.emmet.nodes.MoreOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.MulOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.IdentifierToken;
import com.intellij.codeInsight.template.emmet.tokens.NumberToken;
import com.intellij.codeInsight.template.emmet.tokens.OperationToken;
import com.intellij.codeInsight.template.emmet.tokens.StringLiteralToken;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingTokens;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEmmetParser
extends EmmetParser {
    private static final String DEFAULT_TAG = "div";
    private static final int DEFAULT_LOREM_LENGTH = 30;
    private static final Pattern LOREM_PATTERN = Pattern.compile("(lorem|lipsum)(\\d*)");
    @NonNls
    private static final String DEFAULT_INLINE_TAG = "span";
    @NonNls
    private static final String LOREM_KEYWORD = "lorem";
    @NonNls
    private static final String LIPSUM_KEYWORD = "lipsum";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private boolean hasTagContext = false;
    private final Stack<String> tagLevel = new Stack();
    private static final Map<String, String> parentChildTagMapping = new HashMap<String, String>(){
        {
            this.put("p", XmlEmmetParser.DEFAULT_INLINE_TAG);
            this.put("ul", "li");
            this.put("ol", "li");
            this.put("table", "tr");
            this.put("tr", "td");
            this.put("tbody", "tr");
            this.put("thead", "tr");
            this.put("tfoot", "tr");
            this.put("colgroup", "col");
            this.put("select", "option");
            this.put("optgroup", "option");
            this.put("audio", "source");
            this.put("video", "source");
            this.put("object", "param");
            this.put("map", "area");
        }
    };

    public XmlEmmetParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        super(tokens, callback, generator);
        PsiElement context = callback.getContext();
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        if (surroundWithTemplate && parentTag != null && context.getNode().getElementType() == XmlTokenType.XML_START_TAG_START) {
            parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parentTag, XmlTag.class);
        }
        if (parentTag != null) {
            this.hasTagContext = true;
            this.tagLevel.push((Object)parentTag.getName());
        }
    }

    @NotNull
    private static String getAttributeValueByToken(@Nullable ZenCodingToken token) {
        if (token == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return "";
        }
        if (token instanceof StringLiteralToken) {
            String text = ((StringLiteralToken)token).getText();
            String string = text.substring(1, text.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token instanceof TextToken) {
            String string = ((TextToken)token).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token instanceof IdentifierToken) {
            String string = ((IdentifierToken)token).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token instanceof NumberToken) {
            String string = Integer.toString(((NumberToken)token).getNumber());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token == ZenCodingTokens.DOT || token == ZenCodingTokens.SHARP) {
            String string = token.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
        }
        return "";
    }

    @Override
    @Nullable
    protected ZenCodingNode parseTemplate() {
        ZenCodingToken token = this.getToken();
        String templateKey = this.getDefaultTemplateKey();
        boolean mustHaveSelector = true;
        if (token instanceof IdentifierToken) {
            templateKey = ((IdentifierToken)token).getText();
            this.advance();
            if (StringUtil.startsWithIgnoreCase((String)templateKey, (String)LOREM_KEYWORD) || StringUtil.startsWithIgnoreCase((String)templateKey, (String)LIPSUM_KEYWORD)) {
                return this.parseLorem(templateKey);
            }
            mustHaveSelector = false;
        }
        if (templateKey == null) {
            return null;
        }
        TemplateImpl template = this.myCallback.findApplicableTemplate(templateKey);
        if (template == null && !ZenCodingUtil.isXML11ValidQName(templateKey) && !StringUtil.containsChar((String)templateKey, (char)'$')) {
            return null;
        }
        List<Couple<String>> attrList = this.parseSelectors();
        if (mustHaveSelector && attrList.size() == 0) {
            return null;
        }
        TemplateToken templateToken = new TemplateToken(templateKey, attrList);
        if (!this.setTemplate(templateToken, template)) {
            return null;
        }
        return new TemplateNode(templateToken, this.myGenerator);
    }

    @Override
    protected ZenCodingNode parseClimbUpOperation(@Nullable ZenCodingNode leftPart) {
        this.popTagLevel();
        return super.parseClimbUpOperation(leftPart);
    }

    @Override
    protected ZenCodingNode parseMoreOperation(@Nullable ZenCodingNode leftPart) {
        ZenCodingNode result;
        String parentTag = XmlEmmetParser.getParentTag(leftPart);
        boolean hasParent = false;
        if (!Strings.isNullOrEmpty((String)parentTag)) {
            hasParent = true;
            this.tagLevel.push((Object)parentTag);
        }
        if ((result = super.parseMoreOperation(leftPart)) == null) {
            return null;
        }
        if (hasParent) {
            this.popTagLevel();
        }
        return result;
    }

    @Nullable
    private String getDefaultTemplateKey() {
        return ZenCodingUtil.isHtml(this.myCallback) ? this.suggestTagName() : null;
    }

    @Nullable
    private static String getParentTag(ZenCodingNode node) {
        ZenCodingNode leftOperand;
        if (node instanceof TemplateNode) {
            return ((TemplateNode)node).getTemplateToken().getKey();
        }
        if (node instanceof MulOperationNode && (leftOperand = ((MulOperationNode)node).getLeftOperand()) instanceof TemplateNode) {
            return ((TemplateNode)leftOperand).getTemplateToken().getKey();
        }
        return null;
    }

    @Nullable
    private ZenCodingNode parseLorem(String templateKey) {
        Matcher matcher = LOREM_PATTERN.matcher(templateKey);
        if (matcher.matches()) {
            boolean isRepeating;
            int loremWordsCount = 30;
            if (matcher.groupCount() > 1) {
                String group = matcher.group(2);
                loremWordsCount = group == null || group.isEmpty() ? 30 : Integer.parseInt(group);
            }
            List<Couple<String>> attrList = this.parseSelectors();
            ZenCodingToken token = this.getToken();
            boolean bl = isRepeating = token instanceof OperationToken && ((OperationToken)token).getSign() == '*';
            if (!attrList.isEmpty() || isRepeating) {
                String wrapTag = this.suggestTagName();
                TemplateImpl template = this.myCallback.findApplicableTemplate(templateKey);
                if (template == null && !ZenCodingUtil.isXML11ValidQName(templateKey)) {
                    return null;
                }
                TemplateToken templateToken = new TemplateToken(wrapTag, attrList);
                if (!this.setTemplate(templateToken, template)) {
                    return null;
                }
                return new MoreOperationNode(new TemplateNode(templateToken), new LoremNode(loremWordsCount));
            }
            return new LoremNode(loremWordsCount);
        }
        return null;
    }

    private String suggestTagName() {
        if (!this.tagLevel.empty()) {
            String parentTag = (String)this.tagLevel.peek();
            if (parentChildTagMapping.containsKey(parentTag)) {
                return parentChildTagMapping.get(parentTag);
            }
            if (HtmlUtil.isPossiblyInlineTag(parentTag)) {
                return DEFAULT_INLINE_TAG;
            }
        }
        return DEFAULT_TAG;
    }

    private void popTagLevel() {
        if (this.tagLevel.size() > (this.hasTagContext ? 1 : 0)) {
            this.tagLevel.pop();
        }
    }

    @NotNull
    private List<Couple<String>> parseSelectors() {
        ArrayList<Couple<String>> result = new ArrayList<Couple<String>>();
        int classAttrPosition = -1;
        int idAttrPosition = -1;
        StringBuilder classAttrBuilder = new StringBuilder();
        StringBuilder idAttrBuilder = new StringBuilder();
        block0: while (true) {
            List<Couple<String>> attrList;
            if ((attrList = this.parseSelector()) == null) {
                if (classAttrPosition != -1) {
                    result.set(classAttrPosition, Couple.of((Object)CLASS, (Object)classAttrBuilder.toString()));
                }
                if (idAttrPosition != -1) {
                    result.set(idAttrPosition, (Couple<String>)Couple.of((Object)ID, (Object)idAttrBuilder.toString()));
                }
                ArrayList<Couple<String>> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "parseSelectors"));
                }
                return arrayList;
            }
            Iterator<Couple<String>> i$ = attrList.iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                Couple<String> attr = i$.next();
                if (CLASS.equals(attr.first)) {
                    if (classAttrBuilder.length() > 0) {
                        classAttrBuilder.append(' ');
                    }
                    classAttrBuilder.append((String)attr.second);
                    if (classAttrPosition != -1) continue;
                    classAttrPosition = result.size();
                    result.add(attr);
                    continue;
                }
                if (ID.equals(attr.first)) {
                    if (idAttrBuilder.length() > 0) {
                        idAttrBuilder.append(' ');
                    }
                    idAttrBuilder.append((String)attr.second);
                    if (idAttrPosition != -1) continue;
                    idAttrPosition = result.size();
                    result.add(attr);
                    continue;
                }
                result.add(attr);
            }
            break;
        }
    }

    @Nullable
    private List<Couple<String>> parseSelector() {
        ZenCodingToken token = this.getToken();
        if (token == ZenCodingTokens.OPENING_SQ_BRACKET) {
            this.advance();
            List<Couple<String>> attrList = this.parseAttributeList();
            if (attrList == null || this.getToken() != ZenCodingTokens.CLOSING_SQ_BRACKET) {
                return null;
            }
            this.advance();
            return attrList;
        }
        if (token == ZenCodingTokens.DOT || token == ZenCodingTokens.SHARP) {
            String name = token == ZenCodingTokens.DOT ? CLASS : ID;
            this.advance();
            token = this.getToken();
            String value = XmlEmmetParser.getAttributeValueByToken(token);
            if (!value.isEmpty()) {
                this.advance();
            }
            return Collections.singletonList(Couple.of((Object)name, (Object)value));
        }
        return null;
    }

    @Nullable
    private List<Couple<String>> parseAttributeList() {
        ArrayList<Couple<String>> result = new ArrayList<Couple<String>>();
        Couple<String> attribute;
        while ((attribute = this.parseAttribute()) != null) {
            result.add(attribute);
            ZenCodingToken token = this.getToken();
            if (token != ZenCodingTokens.COMMA && token != ZenCodingTokens.SPACE) {
                return result;
            }
            this.advance();
        }
        return result;
    }

    @Nullable
    private Couple<String> parseAttribute() {
        ZenCodingToken token = this.getToken();
        if (!(token instanceof IdentifierToken)) {
            return null;
        }
        String name = ((IdentifierToken)token).getText();
        if (name.isEmpty()) {
            return null;
        }
        XmlTag tag = XmlElementFactory.getInstance((Project)this.myCallback.getProject()).createTagFromText((CharSequence)("<tag " + name + "=''/>"));
        XmlAttribute[] attributes = tag.getAttributes();
        if (attributes.length != 1) {
            return null;
        }
        name = attributes[0].getName();
        this.advance();
        token = this.getToken();
        if (token != ZenCodingTokens.EQ) {
            return Couple.of((Object)name, (Object)"");
        }
        this.advance();
        StringBuilder attrValueBuilder = new StringBuilder();
        do {
            token = this.getToken();
            String value = XmlEmmetParser.getAttributeValueByToken(token);
            attrValueBuilder.append(value);
            if (token == null || token == ZenCodingTokens.CLOSING_SQ_BRACKET || token == ZenCodingTokens.SPACE || token == ZenCodingTokens.COMMA) continue;
            this.advance();
        } while (token != null && token != ZenCodingTokens.CLOSING_SQ_BRACKET && token != ZenCodingTokens.SPACE && token != ZenCodingTokens.COMMA);
        return Couple.of((Object)name, (Object)attrValueBuilder.toString());
    }
}

