/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfigurable;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.impl.java.EclipseCompilerTool;

public class EclipseCompiler
implements BackendCompiler {
    private final Project myProject;

    public EclipseCompiler(Project project) {
        this.myProject = project;
    }

    public static boolean isInitialized() {
        return EclipseCompilerTool.findEcjJarFile() != null;
    }

    @Override
    @NotNull
    public String getId() {
        if ("Eclipse" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "getId"));
        }
        return "Eclipse";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.eclipse.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        EclipseCompilerConfigurable eclipseCompilerConfigurable = new EclipseCompilerConfigurable(EclipseCompilerConfiguration.getOptions(this.myProject, EclipseCompilerConfiguration.class));
        if (eclipseCompilerConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "createConfigurable"));
        }
        return eclipseCompilerConfigurable;
    }

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<LanguageFileType> set = Collections.singleton(StdFileTypes.JAVA);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "getCompilableFileTypes"));
        }
        return set;
    }
}

