/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.ArrayList;
import java.util.List;
import jsr166e.CountedCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplierCompleter
extends CountedCompleter<Void> {
    private final boolean runInReadAction;
    private final ProgressIndicator progressIndicator;
    @NotNull
    private final List array;
    @NotNull
    private final Processor processor;
    private final int lo;
    private final int hi;
    private final ApplierCompleter next;
    volatile Throwable throwable;
    private static final AtomicFieldUpdater<ApplierCompleter, Throwable> throwableUpdater = AtomicFieldUpdater.forFieldOfType(ApplierCompleter.class, Throwable.class);
    private List<ApplierCompleter> failedSubTasks;

    ApplierCompleter(ApplierCompleter parent, boolean runInReadAction, @NotNull ProgressIndicator progressIndicator, @NotNull List array, @NotNull Processor processor, int lo, int hi, ApplierCompleter next) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        super((CountedCompleter)parent);
        this.runInReadAction = runInReadAction;
        this.progressIndicator = progressIndicator;
        this.array = array;
        this.processor = processor;
        this.lo = lo;
        this.hi = hi;
        this.next = next;
    }

    public void compute() {
        this.wrapInReadActionAndIndicator(new Runnable(){

            @Override
            public void run() {
                ApplierCompleter.this.execAndForkSubTasks();
            }
        });
    }

    private void wrapInReadActionAndIndicator(final @NotNull Runnable process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/concurrency/ApplierCompleter", "wrapInReadActionAndIndicator"));
        }
        Runnable toRun = this.runInReadAction ? new Runnable(){

            @Override
            public void run() {
                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(process)) {
                    ApplierCompleter.this.failedSubTasks = new ArrayList();
                    ApplierCompleter.this.failedSubTasks.add(ApplierCompleter.this);
                    ApplierCompleter.this.doComplete(ApplierCompleter.this.throwable);
                }
            }
        } : process;
        ProgressIndicator existing = ProgressManager.getInstance().getProgressIndicator();
        if (existing == this.progressIndicator) {
            toRun.run();
        } else {
            ProgressManager.getInstance().executeProcessUnderProgress(toRun, this.progressIndicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ApplierCompleter execAndForkSubTasks() {
        int hi = this.hi;
        long start = System.currentTimeMillis();
        ApplierCompleter right = null;
        Throwable throwable = null;
        try {
            for (int i = this.lo; i < hi; ++i) {
                this.progressIndicator.checkCanceled();
                if (!this.processor.process(this.array.get(i))) {
                    throw new ComputationAbortedException();
                }
                long finish = System.currentTimeMillis();
                long elapsed = finish - start;
                if (elapsed <= 5L || hi - i < 2 || ApplierCompleter.getSurplusQueuedTaskCount() > JobSchedulerImpl.CORES_COUNT) continue;
                int mid = i + hi >>> 1;
                right = new ApplierCompleter(this, this.runInReadAction, this.progressIndicator, this.array, this.processor, mid, hi, right);
                this.addToPendingCount(1);
                right.fork();
                hi = mid;
                start = finish;
            }
            if (right != null) {
                throwable = super.tryToExecAllList();
            }
        }
        catch (Throwable e) {
            this.cancelProgress();
            throwable = e;
        }
        finally {
            this.doComplete(ApplierCompleter.moreImportant(throwable, this.throwable));
        }
        return right;
    }

    private static Throwable moreImportant(Throwable throwable1, Throwable throwable2) {
        Throwable result = throwable1 == null ? throwable2 : (throwable2 == null ? throwable1 : (throwable1 instanceof ProcessCanceledException ? throwable2 : throwable1));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doComplete(Throwable throwable) {
        ApplierCompleter a;
        ApplierCompleter child = a = this;
        while (true) {
            Throwable newThrowable;
            Throwable oldThrowable;
            if ((oldThrowable = a.throwable) != (newThrowable = ApplierCompleter.moreImportant(oldThrowable, throwable)) && !throwableUpdater.compareAndSet((Object)a, (Object)oldThrowable, (Object)newThrowable)) {
                continue;
            }
            throwable = newThrowable;
            if (a.getPendingCount() == 0) {
                a.onCompletion(child);
                child = a;
                if ((a = (ApplierCompleter)a.getCompleter()) != null) continue;
                child.quietlyComplete();
                return;
            }
            if (a.decrementPendingCountUnlessZero() != 0) return;
        }
    }

    private void cancelProgress() {
        if (!this.progressIndicator.isCanceled()) {
            this.progressIndicator.cancel();
        }
    }

    private Throwable tryToExecAllList() {
        ApplierCompleter right = this;
        Throwable result = this.throwable;
        while (right != null) {
            if (right.tryUnfork()) {
                right.execAndForkSubTasks();
                result = ApplierCompleter.moreImportant(result, right.throwable);
            }
            right = right.next;
        }
        return result;
    }

    boolean completeTaskWhichFailToAcquireReadAction() {
        if (this.failedSubTasks == null) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        for (final ApplierCompleter task : this.failedSubTasks) {
            task.failedSubTasks = null;
            task.wrapInReadActionAndIndicator(new Runnable(){

                @Override
                public void run() {
                    for (int i = task.lo; i < task.hi; ++i) {
                        if (task.processor.process(task.array.get(i))) continue;
                        result[0] = false;
                        break;
                    }
                }
            });
            assert (task.failedSubTasks == null) : task.failedSubTasks;
        }
        return result[0];
    }

    public String toString() {
        return System.identityHashCode((Object)this) + " (" + this.lo + "-" + this.hi + ")";
    }

    static class ComputationAbortedException
    extends RuntimeException {
        ComputationAbortedException() {
        }
    }
}

