/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.ContinueException;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.util.Comparing;
import com.sun.jdi.BooleanValue;

public abstract class ForStatementEvaluatorBase
implements Evaluator {
    private final String myLabelName;

    public ForStatementEvaluatorBase(String labelName) {
        this.myLabelName = labelName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object value = context.getDebugProcess().getVirtualMachineProxy().mirrorOf();
        value = this.evaluateInitialization(context, value);
        while (true) {
            block10: {
                Object codition;
                if ((codition = this.evaluateCondition(context)) instanceof Boolean) {
                    if (!((Boolean)codition).booleanValue()) {
                        break;
                    }
                } else if (codition instanceof BooleanValue) {
                    if (!((BooleanValue)codition).booleanValue()) {
                        break;
                    }
                } else {
                    throw EvaluateExceptionUtil.BOOLEAN_EXPECTED;
                }
                try {
                    this.evaluateBody(context);
                }
                catch (BreakException e) {
                    if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) break;
                    throw e;
                }
                catch (ContinueException e) {
                    if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) break block10;
                    throw e;
                }
            }
            value = this.evaluateUpdate(context, value);
        }
        return value;
    }

    protected Object evaluateInitialization(EvaluationContextImpl context, Object value) throws EvaluateException {
        return value;
    }

    protected Object evaluateCondition(EvaluationContextImpl context) throws EvaluateException {
        return true;
    }

    protected void evaluateBody(EvaluationContextImpl context) throws EvaluateException {
    }

    protected Object evaluateUpdate(EvaluationContextImpl context, Object value) throws EvaluateException {
        return value;
    }
}

