/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.google.common.collect.ImmutableSet;
import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedDocumentWatcher {
    private static final Key<CachedValue<Boolean>> CONTAINS_ERROR_ELEMENT = Key.create((String)"CONTAINS_ERROR_ELEMENT");
    private final Project myProject;
    private final Alarm myAlarm;
    private final int myDelayMillis;
    private final Consumer<Set<VirtualFile>> myConsumer;
    private final Condition<VirtualFile> myChangedFileFilter;
    private final MyDocumentAdapter myListener;
    private final Runnable myAlarmRunnable;
    private final Set<VirtualFile> myChangedFiles;
    private boolean myDocumentSavingInProgress;
    private MessageBusConnection myConnection;
    private int myEventCount;

    public DelayedDocumentWatcher(@NotNull Project project, int delayMillis, @NotNull Consumer<Set<VirtualFile>> consumer, @Nullable Condition<VirtualFile> changedFileFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/DelayedDocumentWatcher", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/execution/DelayedDocumentWatcher", "<init>"));
        }
        this.myChangedFiles = new THashSet();
        this.myDocumentSavingInProgress = false;
        this.myEventCount = 0;
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
        this.myDelayMillis = delayMillis;
        this.myConsumer = consumer;
        this.myChangedFileFilter = changedFileFilter;
        this.myListener = new MyDocumentAdapter();
        this.myAlarmRunnable = new MyRunnable();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/DelayedDocumentWatcher", "getProject"));
        }
        return project;
    }

    public void activate() {
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.myListener, (Disposable)this.myProject);
        if (this.myConnection == null) {
            this.myConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
            this.myConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

                public void beforeAllDocumentsSaving() {
                    DelayedDocumentWatcher.this.myDocumentSavingInProgress = true;
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DelayedDocumentWatcher.this.myDocumentSavingInProgress = false;
                        }
                    }, ModalityState.any());
                }
            });
        }
    }

    public void deactivate() {
        EditorFactory.getInstance().getEventMulticaster().removeDocumentListener((DocumentListener)this.myListener);
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    private void asyncCheckErrors(final @NotNull Collection<VirtualFile> files, final @NotNull Consumer<Boolean> errorsFoundConsumer) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/execution/DelayedDocumentWatcher", "asyncCheckErrors"));
        }
        if (errorsFoundConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsFoundConsumer", "com/intellij/execution/DelayedDocumentWatcher", "asyncCheckErrors"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final boolean errorsFound = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        for (VirtualFile file : files) {
                            if (!DelayedDocumentWatcher.this.hasErrors(file)) continue;
                            return true;
                        }
                        return false;
                    }
                });
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        errorsFoundConsumer.consume((Object)errorsFound);
                    }
                }, ModalityState.any());
            }
        });
    }

    private boolean hasErrors(@NotNull VirtualFile file) {
        PsiFile psiFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/DelayedDocumentWatcher", "hasErrors"));
        }
        if (!file.isValid()) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document)) != null) {
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.myProject);
            return (Boolean)cachedValuesManager.getCachedValue((UserDataHolder)psiFile, CONTAINS_ERROR_ELEMENT, (CachedValueProvider)new CachedValueProvider<Boolean>(){

                public CachedValueProvider.Result<Boolean> compute() {
                    boolean error = PsiTreeUtil.hasErrorElements((PsiElement)psiFile);
                    return CachedValueProvider.Result.create((Object)error, (Object[])new Object[]{psiFile});
                }
            }, false);
        }
        return WolfTheProblemSolver.getInstance((Project)this.myProject).hasSyntaxErrors(file);
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            final int oldEventCount = DelayedDocumentWatcher.this.myEventCount;
            ImmutableSet copy = ImmutableSet.copyOf((Collection)DelayedDocumentWatcher.this.myChangedFiles);
            DelayedDocumentWatcher.this.asyncCheckErrors((Collection)copy, (Consumer<Boolean>)((Consumer)new Consumer<Boolean>((Set)copy){
                final /* synthetic */ Set val$copy;
                {
                    this.val$copy = set;
                }

                public void consume(Boolean errorsFound) {
                    if (DelayedDocumentWatcher.this.myEventCount != oldEventCount) {
                        return;
                    }
                    if (errorsFound.booleanValue()) {
                        return;
                    }
                    DelayedDocumentWatcher.this.myChangedFiles.clear();
                    DelayedDocumentWatcher.this.myConsumer.consume((Object)this.val$copy);
                }
            }));
        }
    }

    private class MyDocumentAdapter
    extends DocumentAdapter {
        private MyDocumentAdapter() {
        }

        public void documentChanged(DocumentEvent event) {
            if (DelayedDocumentWatcher.this.myDocumentSavingInProgress) {
                return;
            }
            Document document = event.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            if (file == null) {
                return;
            }
            if (!DelayedDocumentWatcher.this.myChangedFiles.contains(file)) {
                if (DelayedDocumentWatcher.this.myChangedFileFilter != null && !DelayedDocumentWatcher.this.myChangedFileFilter.value((Object)file)) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.add(file);
            }
            DelayedDocumentWatcher.this.myAlarm.cancelRequest(DelayedDocumentWatcher.this.myAlarmRunnable);
            DelayedDocumentWatcher.this.myAlarm.addRequest(DelayedDocumentWatcher.this.myAlarmRunnable, DelayedDocumentWatcher.this.myDelayMillis);
            DelayedDocumentWatcher.this.myEventCount++;
        }
    }
}

