/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesTextFieldWithBrowseButton
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    private Map<String, String> myEnvs = Collections.emptyMap();
    private boolean myPassParentEnvs;
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesTextFieldWithBrowseButton() {
        this.setEditable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MyEnvironmentVariablesDialog().show();
            }
        });
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "getEnvs"));
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "setEnvs"));
        }
        this.myEnvs = ImmutableMap.copyOf(envs);
        String envsStr = EnvironmentVariablesTextFieldWithBrowseButton.stringifyEnvs(this.myEnvs);
        this.setText(envsStr);
    }

    @NotNull
    private static String stringifyEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "stringifyEnvs"));
        }
        if (envs.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "stringifyEnvs"));
            }
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(entry.getKey()).append("=").append(entry.getValue());
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "stringifyEnvs"));
        }
        return string;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        if (this.myPassParentEnvs != passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    private class MyEnvironmentVariablesDialog
    extends DialogWrapper {
        private final EnvVariablesTable myEnvVariablesTable;
        private final JCheckBox myUseDefaultCb;
        private final JPanel myWholePanel;

        protected MyEnvironmentVariablesDialog() {
            super((Component)((Object)EnvironmentVariablesTextFieldWithBrowseButton.this), true);
            this.myUseDefaultCb = new JCheckBox(ExecutionBundle.message((String)"env.vars.checkbox.title", (Object[])new Object[0]));
            this.myWholePanel = new JPanel(new BorderLayout());
            this.myEnvVariablesTable = new EnvVariablesTable();
            List envVariables = ContainerUtil.map(EnvironmentVariablesTextFieldWithBrowseButton.this.myEnvs.entrySet(), (Function)new Function<Map.Entry<String, String>, EnvironmentVariable>(){

                public EnvironmentVariable fun(Map.Entry<String, String> entry) {
                    return new EnvironmentVariable(entry.getKey(), entry.getValue(), false);
                }
            });
            this.myEnvVariablesTable.setValues(envVariables);
            this.myUseDefaultCb.setSelected(EnvironmentVariablesTextFieldWithBrowseButton.this.isPassParentEnvs());
            this.myWholePanel.add((Component)this.myEnvVariablesTable.getComponent(), "Center");
            this.myWholePanel.add((Component)this.myUseDefaultCb, "South");
            this.setTitle(ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        protected void doOKAction() {
            this.myEnvVariablesTable.stopEditing();
            LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
            for (EnvironmentVariable variable : this.myEnvVariablesTable.getEnvironmentVariables()) {
                envs.put(variable.getName(), variable.getValue());
            }
            EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(envs);
            EnvironmentVariablesTextFieldWithBrowseButton.this.setPassParentEnvs(this.myUseDefaultCb.isSelected());
            super.doOKAction();
        }
    }
}

