/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.junit2.segments.Extractor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class JUnitProcessHandler
extends OSProcessHandler {
    private final Extractor myOut;
    private final Extractor myErr;
    private final Charset myCharset;

    public JUnitProcessHandler(@NotNull Process process, String commandLine, @NotNull Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/junit/JUnitProcessHandler", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/junit/JUnitProcessHandler", "<init>"));
        }
        super(process, commandLine);
        this.myOut = new Extractor(this.getProcess().getInputStream(), charset);
        this.myErr = new Extractor(this.getProcess().getErrorStream(), charset);
        this.myCharset = charset;
    }

    protected Reader createProcessOutReader() {
        return this.myOut.createReader();
    }

    protected Reader createProcessErrReader() {
        return this.myErr.createReader();
    }

    public Extractor getErr() {
        return this.myErr;
    }

    public Extractor getOut() {
        return this.myOut;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public static JUnitProcessHandler runCommandLine(GeneralCommandLine commandLine) throws ExecutionException {
        JUnitProcessHandler processHandler = new JUnitProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        return processHandler;
    }
}

