/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.DelayedDocumentWatcher;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;

public class AutoTestManager {
    static final Key<Boolean> AUTOTESTABLE = Key.create((String)"auto.test.manager.supported");
    public static final String AUTO_TEST_MANAGER_DELAY = "auto.test.manager.delay";
    private final Project myProject;
    private int myDelay;
    private DelayedDocumentWatcher myDocumentWatcher;
    private final Set<Content> myEnabledDescriptors = Collections.newSetFromMap(new WeakHashMap());

    public static AutoTestManager getInstance(Project project) {
        return (AutoTestManager)ServiceManager.getService((Project)project, AutoTestManager.class);
    }

    public AutoTestManager(Project project) {
        this.myProject = project;
        this.myDelay = PropertiesComponent.getInstance((Project)this.myProject).getOrInitInt(AUTO_TEST_MANAGER_DELAY, 3000);
        this.myDocumentWatcher = this.createWatcher();
    }

    private DelayedDocumentWatcher createWatcher() {
        return new DelayedDocumentWatcher(this.myProject, this.myDelay, new Consumer<Set<VirtualFile>>(){

            public void consume(Set<VirtualFile> files) {
                for (Content content : AutoTestManager.this.myEnabledDescriptors) {
                    AutoTestManager.runAutoTest(content);
                }
            }
        }, new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return FileEditorManager.getInstance((Project)AutoTestManager.this.myProject).isFileOpen(file);
            }
        });
    }

    public void setAutoTestEnabled(RunContentDescriptor descriptor, boolean enabled) {
        Content content = descriptor.getAttachedContent();
        if (enabled) {
            this.myEnabledDescriptors.add(content);
            this.myDocumentWatcher.activate();
        } else {
            this.myEnabledDescriptors.remove(content);
            if (this.myEnabledDescriptors.isEmpty()) {
                this.myDocumentWatcher.deactivate();
            }
        }
    }

    public boolean isAutoTestEnabled(RunContentDescriptor descriptor) {
        return this.myEnabledDescriptors.contains(descriptor.getAttachedContent());
    }

    private static void runAutoTest(Content content) {
        DataContext dataContext;
        RunContentDescriptor descriptor;
        JComponent component = content.getComponent();
        if (component != null && (descriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext = DataManager.getInstance().getDataContext((Component)component))) != null) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler != null && !processHandler.isProcessTerminated()) {
                return;
            }
            descriptor.setActivateToolWindowWhenAdded(false);
            descriptor.setReuseToolWindowActivation(true);
            ExecutionUtil.restart((Content)content);
        }
    }

    int getDelay() {
        return this.myDelay;
    }

    void setDelay(int delay) {
        this.myDelay = delay;
        this.myDocumentWatcher.deactivate();
        this.myDocumentWatcher = this.createWatcher();
        if (!this.myEnabledDescriptors.isEmpty()) {
            this.myDocumentWatcher.activate();
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(AUTO_TEST_MANAGER_DELAY, String.valueOf(this.myDelay));
    }
}

