/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class ConfigurationModuleSelector {
    private final String myNoModule;
    private final Project myProject;
    private final JComboBox myModulesList;
    private final SortedComboBoxModel<Object> myModules = new SortedComboBoxModel((Comparator)new Comparator<Object>(){

        @Override
        public int compare(Object module, Object module1) {
            if (module instanceof Module && module1 instanceof Module) {
                return ((Module)module).getName().compareToIgnoreCase(((Module)module1).getName());
            }
            return -1;
        }
    });

    public ConfigurationModuleSelector(Project project, JComboBox modulesList) {
        this(project, modulesList, "<no module>");
    }

    public ConfigurationModuleSelector(Project project, JComboBox modulesList, String noModule) {
        this.myNoModule = noModule;
        this.myProject = project;
        this.myModulesList = modulesList;
        new ComboboxSpeedSearch(modulesList){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                if (element == null) {
                    return ConfigurationModuleSelector.this.myNoModule;
                }
                return super.getElementText(element);
            }
        };
        this.myModulesList.setModel(this.myModules);
        this.myModulesList.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Module) {
                    Module module = (Module)value;
                    this.setIcon(ModuleType.get((Module)module).getIcon());
                    this.setText(module.getName());
                } else if (value == null) {
                    this.setText(ConfigurationModuleSelector.this.myNoModule);
                }
            }
        });
    }

    public void applyTo(ModuleBasedConfiguration configurationModule) {
        configurationModule.setModule((Module)this.myModulesList.getSelectedItem());
    }

    public void reset(ModuleBasedConfiguration configuration) {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        ArrayList<Module> list = new ArrayList<Module>();
        for (Module module : modules) {
            if (!this.isModuleAccepted(module)) continue;
            list.add(module);
        }
        this.setModules(list);
        this.myModules.setSelectedItem((Object)configuration.getConfigurationModule().getModule());
    }

    public boolean isModuleAccepted(Module module) {
        return ModuleTypeManager.getInstance().isClasspathProvider(ModuleType.get((Module)module));
    }

    public Project getProject() {
        return this.myProject;
    }

    public JavaRunConfigurationModule getConfigurationModule() {
        JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.getProject(), false);
        configurationModule.setModule((Module)this.myModules.getSelectedItem());
        return configurationModule;
    }

    private void setModules(Collection<Module> modules) {
        this.myModules.clear();
        this.myModules.add(null);
        for (Module module : modules) {
            this.myModules.add((Object)module);
        }
    }

    public Module getModule() {
        return (Module)this.myModules.getSelectedItem();
    }

    @Nullable
    public PsiClass findClass(String className) {
        return this.getConfigurationModule().findClass(className);
    }

    public String getModuleName() {
        Module module = (Module)this.myModules.getSelectedItem();
        return module == null ? "" : module.getName();
    }
}

