/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.components.LastStorageChooserForWrite;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;

@State(name="RecentProjectsManager", storages={@Storage(file="$APP_CONFIG$/other.xml", roamingType=RoamingType.DISABLED), @Storage(file="$APP_CONFIG$/recentProjects.xml", roamingType=RoamingType.DISABLED)}, storageChooser=LastStorageChooserForWrite.class)
public class RecentProjectsManager
extends RecentProjectsManagerBase {
    public RecentProjectsManager(MessageBus messageBus) {
        super(messageBus);
    }

    @Override
    protected String getProjectPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/RecentProjectsManager", "getProjectPath"));
        }
        return project.getPresentableUrl();
    }

    @Override
    protected void doOpenProject(@NotNull String projectPath, Project projectToClose, boolean forceOpenInNewFrame) {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/ide/RecentProjectsManager", "doOpenProject"));
        }
        ProjectUtil.openProject(projectPath, projectToClose, forceOpenInNewFrame);
    }
}

