/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import javax.swing.Icon;

public class ReopenProjectAction
extends AnAction
implements DumbAware {
    private final String myProjectPath;
    private final String myProjectName;

    public ReopenProjectAction(String projectPath, String projectName, String displayName) {
        this.myProjectPath = projectPath;
        this.myProjectName = projectName;
        Presentation presentation = this.getTemplatePresentation();
        String text = projectPath.equals(displayName) ? FileUtil.getLocationRelativeToUserHome((String)projectPath) : displayName;
        presentation.setText(text, false);
        presentation.setDescription(projectPath);
    }

    public void actionPerformed(AnActionEvent e) {
        int modifiers = e.getModifiers();
        boolean forceOpenInNewFrame = (modifiers & 2) != 0 || (modifiers & 1) != 0;
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (!new File(this.myProjectPath).exists()) {
            if (Messages.showDialog((Project)project, (String)("The path " + FileUtil.toSystemDependentName((String)this.myProjectPath) + " does not exist.\n" + "If it is on a removable or network drive, please make sure that the drive is connected."), (String)"Reopen Project", (String[])new String[]{"OK", "&Remove From List"}, (int)0, (Icon)Messages.getErrorIcon()) == 1) {
                RecentProjectsManagerBase.getInstance().removePath(this.myProjectPath);
            }
            return;
        }
        RecentProjectsManagerBase.getInstance().doOpenProject(this.myProjectPath, project, forceOpenInNewFrame);
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public String getProjectName() {
        return this.myProjectName;
    }
}

