/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OpenProjectFileChooserDescriptor
extends FileChooserDescriptor {
    private static final Icon ourProjectIcon = IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl());

    public OpenProjectFileChooserDescriptor(boolean chooseFiles) {
        super(chooseFiles, true, chooseFiles, chooseFiles, false, false);
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || OpenProjectFileChooserDescriptor.isProjectFile(file));
    }

    public boolean isFileSelectable(VirtualFile file) {
        return OpenProjectFileChooserDescriptor.isProjectDirectory(file) || OpenProjectFileChooserDescriptor.isProjectFile(file);
    }

    public Icon getIcon(VirtualFile file) {
        if (OpenProjectFileChooserDescriptor.canInspectDirectory(file)) {
            if (OpenProjectFileChooserDescriptor.isIprFile(file) || OpenProjectFileChooserDescriptor.isIdeaDirectory(file)) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file, (Icon)ourProjectIcon);
            }
            Icon icon = OpenProjectFileChooserDescriptor.getImporterIcon(file);
            if (icon != null) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file, (Icon)icon);
            }
        }
        return super.getIcon(file);
    }

    private static boolean canInspectDirectory(VirtualFile file) {
        if (file.getParent() == null) {
            return false;
        }
        VirtualFile home = VfsUtil.getUserHomeDir();
        if (home == null) {
            return false;
        }
        VirtualFile homes = home.getParent();
        if (homes == null) {
            return false;
        }
        return !homes.equals(file.getParent()) && !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)homes, (boolean)false);
    }

    private static Icon getImporterIcon(VirtualFile file) {
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)file);
        if (provider != null) {
            return file.isDirectory() && provider.lookForProjectsInDirectory() ? ourProjectIcon : provider.getIcon(file);
        }
        return null;
    }

    public static boolean isProjectFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/OpenProjectFileChooserDescriptor", "isProjectFile"));
        }
        return !file.isDirectory() && file.isValid() && (OpenProjectFileChooserDescriptor.isIprFile(file) || OpenProjectFileChooserDescriptor.hasImportProvider(file));
    }

    private static boolean isProjectDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/OpenProjectFileChooserDescriptor", "isProjectDirectory"));
        }
        return file.isDirectory() && file.isValid() && (OpenProjectFileChooserDescriptor.isIdeaDirectory(file) || OpenProjectFileChooserDescriptor.hasImportProvider(file));
    }

    private static boolean isIprFile(VirtualFile file) {
        return "ipr".equalsIgnoreCase(file.getExtension());
    }

    private static boolean isIdeaDirectory(VirtualFile file) {
        return file.findChild(".idea") != null;
    }

    private static boolean hasImportProvider(VirtualFile file) {
        return ProjectOpenProcessor.getImportProvider((VirtualFile)file) != null;
    }
}

