/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class PluginHostsConfigurable
extends BaseConfigurable {
    private CustomPluginRepositoriesPanel myUpdatesSettingsPanel;

    public JComponent createComponent() {
        this.myUpdatesSettingsPanel = new CustomPluginRepositoriesPanel();
        return this.myUpdatesSettingsPanel.myPanel;
    }

    public String getDisplayName() {
        return "Custom Plugin Repositories";
    }

    public String getHelpTopic() {
        return null;
    }

    public void apply() throws ConfigurationException {
        UpdateSettings settings = UpdateSettings.getInstance();
        settings.myPluginHosts.clear();
        settings.myPluginHosts.addAll(this.myUpdatesSettingsPanel.getPluginsHosts());
    }

    public void reset() {
        this.myUpdatesSettingsPanel.setPluginHosts((List<String>)UpdateSettings.getInstance().myPluginHosts);
    }

    public boolean isModified() {
        if (this.myUpdatesSettingsPanel == null) {
            return false;
        }
        UpdateSettings settings = UpdateSettings.getInstance();
        return !settings.myPluginHosts.equals(this.myUpdatesSettingsPanel.getPluginsHosts());
    }

    public void disposeUIResources() {
        this.myUpdatesSettingsPanel = null;
    }

    public Collection<? extends String> getPluginsHosts() {
        return this.myUpdatesSettingsPanel.getPluginsHosts();
    }

    private static String correctRepositoryRule(String input) {
        String protocol = VirtualFileManager.extractProtocol((String)input);
        if (protocol == null) {
            input = VirtualFileManager.constructUrl((String)"http", (String)input);
        }
        return input;
    }

    public static class HostMessages
    extends Messages {

        public static class InputHostDialog
        extends Messages.InputDialog {
            public InputHostDialog(Component parentComponent, String message, String title, Icon icon, String initialValue, InputValidator validator) {
                super(parentComponent, message, title, icon, initialValue, validator);
            }

            @NotNull
            protected Action[] createActions() {
                Object[] actions = super.createActions();
                final AbstractAction checkNowAction = new AbstractAction("Check Now"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final boolean[] result = new boolean[1];
                        final Exception[] ex = new Exception[1];
                        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    result[0] = UpdateChecker.checkPluginsHost(PluginHostsConfigurable.correctRepositoryRule(InputHostDialog.this.getTextField().getText()), new HashMap<PluginId, PluginDownloader>(), true, ProgressManager.getInstance().getProgressIndicator());
                                }
                                catch (Exception e1) {
                                    ex[0] = e1;
                                }
                            }
                        }, "Checking plugins repository...", true, null, InputHostDialog.this.getPreferredFocusedComponent())) {
                            if (ex[0] != null) {
                                Messages.showErrorDialog((Component)InputHostDialog.this.myField, (String)("Connection failed: " + ex[0].getMessage()));
                            } else if (result[0]) {
                                Messages.showInfoMessage((Component)InputHostDialog.this.myField, (String)"Plugins repository was successfully checked", (String)"Check Plugins Repository");
                            } else {
                                Messages.showErrorDialog((Component)InputHostDialog.this.myField, (String)"Plugin descriptions contain some errors. Please, check idea.log for details.");
                            }
                        }
                    }
                };
                this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(DocumentEvent e) {
                        checkNowAction.setEnabled(!StringUtil.isEmptyOrSpaces((String)InputHostDialog.this.myField.getText()));
                    }
                });
                checkNowAction.setEnabled(!StringUtil.isEmptyOrSpaces((String)this.myField.getText()));
                Action[] actionArray = (Action[])ArrayUtil.append((Object[])actions, (Object)checkNowAction);
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginHostsConfigurable$HostMessages$InputHostDialog", "createActions"));
                }
                return actionArray;
            }
        }
    }

    public static class CustomPluginRepositoriesPanel {
        private JBList myUrlsList = new JBList(new DefaultListModel());
        private JPanel myPanel;

        public CustomPluginRepositoriesPanel() {
            this.myUrlsList.getEmptyText().setText(IdeBundle.message((String)"update.no.update.hosts", (Object[])new Object[0]));
            this.myUrlsList.setSelectionMode(0);
            this.myPanel = ToolbarDecorator.createDecorator((JList)this.myUrlsList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    HostMessages.InputHostDialog dlg = new HostMessages.InputHostDialog(CustomPluginRepositoriesPanel.this.myPanel, IdeBundle.message((String)"update.plugin.host.url.message", (Object[])new Object[0]), IdeBundle.message((String)"update.add.new.plugin.host.title", (Object[])new Object[0]), Messages.getQuestionIcon(), "", (InputValidator)new NonEmptyInputValidator());
                    dlg.show();
                    String input = dlg.getInputString();
                    if (input != null) {
                        ((DefaultListModel)CustomPluginRepositoriesPanel.this.myUrlsList.getModel()).addElement(PluginHostsConfigurable.correctRepositoryRule(input));
                    }
                }
            }).setEditAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    HostMessages.InputHostDialog dlg = new HostMessages.InputHostDialog(CustomPluginRepositoriesPanel.this.myPanel, IdeBundle.message((String)"update.plugin.host.url.message", (Object[])new Object[0]), IdeBundle.message((String)"update.edit.plugin.host.title", (Object[])new Object[0]), Messages.getQuestionIcon(), (String)CustomPluginRepositoriesPanel.this.myUrlsList.getSelectedValue(), new InputValidator(){

                        public boolean checkInput(String inputString) {
                            return inputString.length() > 0;
                        }

                        public boolean canClose(String inputString) {
                            return this.checkInput(inputString);
                        }
                    });
                    dlg.show();
                    String input = dlg.getInputString();
                    if (input != null) {
                        ((DefaultListModel)CustomPluginRepositoriesPanel.this.myUrlsList.getModel()).set(CustomPluginRepositoriesPanel.this.myUrlsList.getSelectedIndex(), input);
                    }
                }
            }).disableUpDownActions().createPanel();
        }

        public List<String> getPluginsHosts() {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.myUrlsList.getModel().getSize(); ++i) {
                result.add((String)this.myUrlsList.getModel().getElementAt(i));
            }
            return result;
        }

        public void setPluginHosts(List<String> pluginHosts) {
            DefaultListModel model = (DefaultListModel)this.myUrlsList.getModel();
            model.clear();
            for (String host : pluginHosts) {
                model.addElement(host);
            }
        }
    }
}

