/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class JsonCodeStyleSettings
extends CustomCodeStyleSettings {
    public boolean SPACE_AFTER_COLON = true;
    public boolean SPACE_BEFORE_COLON = false;
    public PropertyAlignment PROPERTY_ALIGNMENT = PropertyAlignment.DO_NOT_ALIGN;
    public int OBJECT_WRAPPING = 2;
    public int ARRAY_WRAPPING = 2;

    public JsonCodeStyleSettings(CodeStyleSettings container) {
        super(JsonLanguage.INSTANCE.getID(), container);
    }

    public static enum PropertyAlignment {
        DO_NOT_ALIGN(JsonBundle.message("msg.align.properties.none", new Object[0])),
        ALIGN_ON_VALUE(JsonBundle.message("msg.align.properties.on.value", new Object[0])),
        ALIGN_ON_COLON(JsonBundle.message("msg.align.properties.on.colon", new Object[0]));

        private final String myDescription;

        private PropertyAlignment(String description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/json/formatter/JsonCodeStyleSettings$PropertyAlignment", "<init>"));
            }
            this.myDescription = description;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonCodeStyleSettings$PropertyAlignment", "getDescription"));
            }
            return string;
        }
    }
}

