/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.html.HtmlTagImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.HtmlFileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.XmlFileElement;
import com.intellij.psi.impl.source.xml.XmlAttlistDeclImpl;
import com.intellij.psi.impl.source.xml.XmlAttributeDeclImpl;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.impl.source.xml.XmlCommentImpl;
import com.intellij.psi.impl.source.xml.XmlConditionalSectionImpl;
import com.intellij.psi.impl.source.xml.XmlDeclImpl;
import com.intellij.psi.impl.source.xml.XmlDoctypeImpl;
import com.intellij.psi.impl.source.xml.XmlDocumentImpl;
import com.intellij.psi.impl.source.xml.XmlElementContentGroupImpl;
import com.intellij.psi.impl.source.xml.XmlElementContentSpecImpl;
import com.intellij.psi.impl.source.xml.XmlElementDeclImpl;
import com.intellij.psi.impl.source.xml.XmlEntityDeclImpl;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.impl.source.xml.XmlEnumeratedTypeImpl;
import com.intellij.psi.impl.source.xml.XmlMarkupDeclImpl;
import com.intellij.psi.impl.source.xml.XmlNotationDeclImpl;
import com.intellij.psi.impl.source.xml.XmlProcessingInstructionImpl;
import com.intellij.psi.impl.source.xml.XmlPrologImpl;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.xml.IXmlLeafElementType;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;

public class XmlASTFactory
extends ASTFactory {
    @Override
    public CompositeElement createComposite(IElementType type) {
        if (type == XmlElementType.XML_TAG) {
            return new XmlTagImpl();
        }
        if (type == XmlElementType.XML_CONDITIONAL_SECTION) {
            return new XmlConditionalSectionImpl();
        }
        if (type == XmlElementType.HTML_TAG) {
            return new HtmlTagImpl();
        }
        if (type == XmlElementType.XML_TEXT) {
            return new XmlTextImpl();
        }
        if (type == XmlElementType.XML_PROCESSING_INSTRUCTION) {
            return new XmlProcessingInstructionImpl();
        }
        if (type == XmlElementType.XML_DOCUMENT) {
            return new XmlDocumentImpl();
        }
        if (type == XmlElementType.HTML_DOCUMENT) {
            return new HtmlDocumentImpl();
        }
        if (type == XmlElementType.XML_PROLOG) {
            return new XmlPrologImpl();
        }
        if (type == XmlElementType.XML_DECL) {
            return new XmlDeclImpl();
        }
        if (type == XmlElementType.XML_ATTRIBUTE) {
            return new XmlAttributeImpl();
        }
        if (type == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return new XmlAttributeValueImpl();
        }
        if (type == XmlElementType.XML_COMMENT) {
            return new XmlCommentImpl();
        }
        if (type == XmlElementType.XML_DOCTYPE) {
            return new XmlDoctypeImpl();
        }
        if (type == XmlElementType.XML_MARKUP_DECL) {
            return new XmlMarkupDeclImpl();
        }
        if (type == XmlElementType.XML_ELEMENT_DECL) {
            return new XmlElementDeclImpl();
        }
        if (type == XmlElementType.XML_ENTITY_DECL) {
            return new XmlEntityDeclImpl();
        }
        if (type == XmlElementType.XML_ATTLIST_DECL) {
            return new XmlAttlistDeclImpl();
        }
        if (type == XmlElementType.XML_ATTRIBUTE_DECL) {
            return new XmlAttributeDeclImpl();
        }
        if (type == XmlElementType.XML_NOTATION_DECL) {
            return new XmlNotationDeclImpl();
        }
        if (type == XmlElementType.XML_ELEMENT_CONTENT_SPEC) {
            return new XmlElementContentSpecImpl();
        }
        if (type == XmlElementType.XML_ELEMENT_CONTENT_GROUP) {
            return new XmlElementContentGroupImpl();
        }
        if (type == XmlElementType.XML_ENTITY_REF) {
            return new XmlEntityRefImpl();
        }
        if (type == XmlElementType.XML_ENUMERATED_TYPE) {
            return new XmlEnumeratedTypeImpl();
        }
        if (type == XmlElementType.XML_CDATA) {
            return new CompositePsiElement(XmlElementType.XML_CDATA){};
        }
        if (type instanceof ITemplateDataElementType) {
            return new XmlFileElement(type, null);
        }
        return null;
    }

    @Override
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        if (type == XmlElementType.XML_FILE) {
            return new XmlFileElement((IElementType)type, text);
        }
        if (type == XmlElementType.DTD_FILE) {
            return new XmlFileElement((IElementType)type, text);
        }
        if (type == XmlElementType.XHTML_FILE) {
            return new XmlFileElement((IElementType)type, text);
        }
        if (type == XmlElementType.HTML_FILE) {
            return new HtmlFileElement(text);
        }
        if (type instanceof ITemplateDataElementType) {
            return new XmlFileElement((IElementType)type, text);
        }
        return null;
    }

    @Override
    public LeafElement createLeaf(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/xml/XmlASTFactory", "createLeaf"));
        }
        if (type instanceof IXmlLeafElementType) {
            if (type == XmlElementType.XML_REAL_WHITE_SPACE) {
                return new PsiWhiteSpaceImpl(text);
            }
            return new XmlTokenImpl(type, text);
        }
        return null;
    }

    static {
        PsiBuilderImpl.registerWhitespaceToken(XmlElementType.XML_REAL_WHITE_SPACE);
    }
}

