/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.options.CurrentUserHolder;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OldStreamProviderAdapter
extends StreamProvider
implements CurrentUserHolder {
    final com.intellij.openapi.options.StreamProvider myProvider;
    private final RoamingType myRoamingType;

    public OldStreamProviderAdapter(com.intellij.openapi.options.StreamProvider provider, @NotNull RoamingType roamingType) {
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "<init>"));
        }
        this.myProvider = provider;
        this.myRoamingType = roamingType;
    }

    @Override
    public boolean isEnabled() {
        return this.myProvider.isEnabled();
    }

    @Override
    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "isApplicable"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "isApplicable"));
        }
        return this.myRoamingType == roamingType && (roamingType != RoamingType.PER_USER || !StorageUtil.isProjectOrModuleFile(fileSpec));
    }

    @Override
    public void saveContent(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType, boolean async) throws IOException {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "saveContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "saveContent"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "saveContent"));
        }
        this.myProvider.saveContent(fileSpec, (InputStream)new BufferExposingByteArrayInputStream(content, size), (long)size, roamingType, async);
    }

    @Override
    @Nullable
    public InputStream loadContent(@NotNull String fileSpec, @NotNull RoamingType roamingType) throws IOException {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "loadContent"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "loadContent"));
        }
        return this.myRoamingType == roamingType ? this.myProvider.loadContent(fileSpec, roamingType) : null;
    }

    @NotNull
    public List<String> listSubFiles(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "listSubFiles"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "listSubFiles"));
        }
        if (this.myRoamingType == roamingType) {
            List<String> list = Arrays.asList(this.myProvider.listSubFiles(fileSpec, roamingType));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "listSubFiles"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "listSubFiles"));
        }
        return list;
    }

    @Override
    public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "delete"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/OldStreamProviderAdapter", "delete"));
        }
        if (this.myRoamingType == roamingType) {
            this.myProvider.deleteFile(fileSpec, roamingType);
        }
    }

    public String getCurrentUserName() {
        return this.myProvider instanceof CurrentUserHolder ? ((CurrentUserHolder)this.myProvider).getCurrentUserName() : null;
    }
}

