/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.Disposer;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameDialogWrapper {
    @NotNull
    protected abstract JComponent getPanel();

    @Nullable
    protected String getDimensionServiceKey() {
        return null;
    }

    @Nullable
    protected JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Nullable
    protected String getTitle() {
        return null;
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    @NotNull
    protected Mode getMode() {
        Mode mode = Mode.MODAL;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/FrameDialogWrapper", "getMode"));
        }
        return mode;
    }

    @Nullable
    protected Disposable getDisposable() {
        return null;
    }

    public void show() {
        switch (this.getMode()) {
            case FRAME: {
                new MyFrameWrapper(this.getProject(), this.getMode(), this.getPanel(), this.getPreferredFocusedComponent(), this.getTitle(), this.getDimensionServiceKey(), this.getDisposable()).show();
                return;
            }
            case MODAL: 
            case NON_MODAL: {
                new MyDialogWrapper(this.getProject(), this.getMode(), this.getPanel(), this.getPreferredFocusedComponent(), this.getTitle(), this.getDimensionServiceKey(), this.getDisposable()).show();
                return;
            }
        }
        throw new IllegalArgumentException(this.getMode().toString());
    }

    private static class MyFrameWrapper
    extends FrameWrapper {
        public MyFrameWrapper(@Nullable Project project, @NotNull Mode mode, @NotNull JComponent component, @Nullable JComponent preferredFocusedComponent, @Nullable String title, @Nullable String dimensionServiceKey, @Nullable Disposable disposable) {
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/diff/impl/dir/FrameDialogWrapper$MyFrameWrapper", "<init>"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/diff/impl/dir/FrameDialogWrapper$MyFrameWrapper", "<init>"));
            }
            super(project, dimensionServiceKey);
            assert (mode == Mode.FRAME);
            if (title != null) {
                this.setTitle(title);
            }
            this.setComponent(component);
            this.setPreferredFocusedComponent(preferredFocusedComponent);
            this.closeOnEsc();
            if (disposable != null) {
                this.addDisposable(disposable);
            }
        }
    }

    private static class MyDialogWrapper
    extends DialogWrapper {
        private final JComponent myComponent;
        private final JComponent myPreferredFocusedComponent;
        private final String myDimensionServiceKey;

        public MyDialogWrapper(@Nullable Project project, @NotNull Mode mode, @NotNull JComponent component, @Nullable JComponent preferredFocusedComponent, @Nullable String title, @Nullable String dimensionServiceKey, @Nullable Disposable disposable) {
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/diff/impl/dir/FrameDialogWrapper$MyDialogWrapper", "<init>"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/diff/impl/dir/FrameDialogWrapper$MyDialogWrapper", "<init>"));
            }
            super(project, true);
            this.myComponent = component;
            this.myPreferredFocusedComponent = preferredFocusedComponent;
            this.myDimensionServiceKey = dimensionServiceKey;
            if (title != null) {
                this.setTitle(title);
            }
            switch (mode) {
                case MODAL: {
                    this.setModal(true);
                    break;
                }
                case NON_MODAL: {
                    this.setModal(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(mode.toString());
                }
            }
            if (disposable != null) {
                Disposer.register((Disposable)this.getDisposable(), (Disposable)disposable);
            }
            this.init();
        }

        protected JComponent createCenterPanel() {
            return this.myComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPreferredFocusedComponent;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return this.myDimensionServiceKey;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/FrameDialogWrapper$MyDialogWrapper", "createActions"));
            }
            return actionArray;
        }
    }

    public static enum Mode {
        FRAME,
        MODAL,
        NON_MODAL;

    }
}

