/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.FontInfo;
import gnu.trove.TObjectIntHashMap;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class DefaultEditorTextRepresentationHelper
implements EditorTextRepresentationHelper {
    private static final int MAX_SYMBOLS_WIDTHS_CACHE_SIZE = 1000;
    private final TObjectIntHashMap<Key> mySymbolWidthCache = new TObjectIntHashMap();
    private final Key mySharedKey = new Key();
    private final Editor myEditor;

    public DefaultEditorTextRepresentationHelper(Editor editor) {
        this.myEditor = editor;
    }

    @Override
    public int toVisualColumnSymbolsNumber(@NotNull CharSequence text, int start, int end, int x) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DefaultEditorTextRepresentationHelper", "toVisualColumnSymbolsNumber"));
        }
        return EditorUtil.textWidthInColumns(this.myEditor, text, start, end, x);
    }

    @Override
    public int charWidth(char c, int fontType) {
        this.mySharedKey.fontType = fontType;
        this.mySharedKey.c = c;
        return this.charWidth(c);
    }

    @Override
    public int textWidth(@NotNull CharSequence text, int start, int end, int fontType, int x) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DefaultEditorTextRepresentationHelper", "textWidth"));
        }
        int startToUse = start;
        for (int i = end - 1; i >= start; --i) {
            if (text.charAt(i) != '\n') continue;
            startToUse = i + 1;
            break;
        }
        int result = 0;
        this.mySharedKey.fontType = fontType;
        for (int i = startToUse; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '\t') {
                this.mySharedKey.c = c;
                result += this.charWidth(c);
                continue;
            }
            result += EditorUtil.nextTabStop(x + result, this.myEditor) - result - x;
        }
        return result;
    }

    private int charWidth(char c) {
        int result = this.mySymbolWidthCache.get((Object)this.mySharedKey);
        if (result > 0) {
            return result;
        }
        Key key = this.mySharedKey.clone();
        FontInfo font = ComplementaryFontsRegistry.getFontAbleToDisplay(c, key.fontType, this.myEditor.getColorsScheme().getFontPreferences());
        result = font.charWidth(c);
        if (this.mySymbolWidthCache.size() >= 1000) {
            this.mySymbolWidthCache.clear();
        }
        this.mySymbolWidthCache.put((Object)key, result);
        return result;
    }

    public void clearSymbolWidthCache() {
        this.mySymbolWidthCache.clear();
    }

    private static class Key {
        @JdkConstants.FontStyle
        private int fontType;
        private char c;

        private Key() {
            this(0, ' ');
        }

        Key(@JdkConstants.FontStyle int fontType, char c) {
            this.fontType = fontType;
            this.c = c;
        }

        protected Key clone() {
            return new Key(this.fontType, this.c);
        }

        public int hashCode() {
            int result = this.fontType;
            result = 31 * result + this.c;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            return this.c == key.c;
        }
    }
}

