/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EditorHeaderComponent
extends JPanel {
    public EditorHeaderComponent() {
        super(new BorderLayout(0, 0));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorHeaderComponent", "paint"));
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paint(g);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorHeaderComponent", "paintComponent"));
        }
        super.paintComponent(g);
        this.paintGradient(g, this);
    }

    private void paintGradient(Graphics g, JComponent c) {
        Color GRADIENT_C1 = this.isBackgroundSet() ? this.getBackground() : new JBColor(this.getBackground(), JBColor.background());
        JBColor GRADIENT_C2 = new JBColor(new Color(Math.max(0, GRADIENT_C1.getRed() - 24), Math.max(0, GRADIENT_C1.getGreen() - 24), Math.max(0, GRADIENT_C1.getBlue() - 24)), (Color)Gray._75);
        Graphics2D g2d = (Graphics2D)g;
        if (!UIUtil.isUnderGTKLookAndFeel()) {
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)GRADIENT_C1, (float)0.0f, (float)c.getHeight(), (Color)GRADIENT_C2));
            g2d.fillRect(1, 1, c.getWidth(), c.getHeight() - 1);
            g2d.setPaint(null);
        }
        g.setColor(UIUtil.getBorderColor());
        g.drawLine(0, c.getHeight() - 1, c.getWidth(), c.getHeight() - 1);
    }
}

