/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemBeforeRunTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEditTaskDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalSystemBeforeRunTaskProvider
extends BeforeRunTaskProvider<ExternalSystemBeforeRunTask> {
    private static final Logger LOG = Logger.getInstance(ExternalSystemBeforeRunTaskProvider.class);
    @NotNull
    private final ProjectSystemId mySystemId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Key<ExternalSystemBeforeRunTask> myId;

    public ExternalSystemBeforeRunTaskProvider(@NotNull ProjectSystemId systemId, @NotNull Project project, @NotNull Key<ExternalSystemBeforeRunTask> id) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "<init>"));
        }
        this.mySystemId = systemId;
        this.myProject = project;
        this.myId = id;
    }

    @NotNull
    public Key<ExternalSystemBeforeRunTask> getId() {
        Key<ExternalSystemBeforeRunTask> key = this.myId;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider", "getId"));
        }
        return key;
    }

    public String getName() {
        return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(RunConfiguration runConfiguration, ExternalSystemBeforeRunTask task) {
        ExternalSystemEditTaskDialog dialog = new ExternalSystemEditTaskDialog(this.myProject, task.getTaskExecutionSettings(), this.mySystemId);
        dialog.setTitle(ExternalSystemBundle.message((String)"tasks.select.task.title", (Object[])new Object[]{this.mySystemId.getReadableName()}));
        dialog.show();
        return dialog.isOK();
    }

    public boolean canExecuteTask(RunConfiguration configuration, ExternalSystemBeforeRunTask beforeRunTask) {
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList tasks = ContainerUtilRt.newArrayList();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        Pair<ProgramRunner, ExecutionEnvironment> pair = ExternalSystemUtil.createRunner(executionSettings, DefaultRunExecutor.EXECUTOR_ID, this.myProject, this.mySystemId);
        if (pair == null) {
            return false;
        }
        ProgramRunner runner = (ProgramRunner)pair.first;
        ExecutionEnvironment environment = (ExecutionEnvironment)pair.second;
        return runner.canRun(DefaultRunExecutor.EXECUTOR_ID, environment.getRunProfile());
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, ExternalSystemBeforeRunTask beforeRunTask) {
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList tasks = ContainerUtilRt.newArrayList();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        Pair<ProgramRunner, ExecutionEnvironment> pair = ExternalSystemUtil.createRunner(executionSettings, DefaultRunExecutor.EXECUTOR_ID, this.myProject, this.mySystemId);
        if (pair == null) {
            return false;
        }
        final ProgramRunner runner = (ProgramRunner)pair.first;
        final ExecutionEnvironment environment = (ExecutionEnvironment)pair.second;
        environment.setExecutionId(env.getExecutionId());
        final Semaphore targetDone = new Semaphore();
        final Ref result = new Ref((Object)false);
        Disposable disposable = Disposer.newDisposable();
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        final String executorId = executor.getId();
        this.myProject.getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

            public void processStartScheduled(String executorIdLocal, ExecutionEnvironment environmentLocal) {
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    targetDone.down();
                }
            }

            public void processNotStarted(String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (environmentLocal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentLocal", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider$1", "processNotStarted"));
                }
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    targetDone.up();
                }
            }

            public void processStarted(String executorIdLocal, final @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler) {
                if (environmentLocal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentLocal", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider$1", "processStarted"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTaskProvider$1", "processStarted"));
                }
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(ProcessEvent event) {
                            result.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                            targetDone.up();
                            environmentLocal.getContentToReuse();
                        }
                    });
                }
            }
        });
        try {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        runner.execute(environment);
                    }
                    catch (ExecutionException e) {
                        targetDone.up();
                        LOG.error((Throwable)e);
                    }
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            Disposer.dispose((Disposable)disposable);
            return false;
        }
        targetDone.waitFor();
        Disposer.dispose((Disposable)disposable);
        return (Boolean)result.get();
    }

    public String getDescription(ExternalSystemBeforeRunTask task) {
        String externalProjectPath = task.getTaskExecutionSettings().getExternalProjectPath();
        if (task.getTaskExecutionSettings().getTaskNames().isEmpty()) {
            return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
        }
        String desc = StringUtil.join((Collection)task.getTaskExecutionSettings().getTaskNames(), (String)" ");
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!this.mySystemId.toString().equals(module.getOptionValue("external.system.id")) || !StringUtil.equals((CharSequence)externalProjectPath, (CharSequence)module.getOptionValue("external.linked.project.path"))) continue;
            desc = module.getName() + ": " + desc;
            break;
        }
        return ExternalSystemBundle.message((String)"tasks.before.run", (Object[])new Object[]{this.mySystemId.getReadableName(), desc});
    }
}

