/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryProjectStructureElement
extends ProjectStructureElement {
    private final Library myLibrary;

    public LibraryProjectStructureElement(@NotNull StructureConfigurableContext context, @NotNull Library library) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement", "<init>"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement", "<init>"));
        }
        super(context);
        this.myLibrary = library;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        if (((LibraryEx)this.myLibrary).isDisposed()) {
            return;
        }
        LibraryEx library = (LibraryEx)this.myContext.getLibraryModel(this.myLibrary);
        if (library == null || library.isDisposed()) {
            return;
        }
        this.reportInvalidRoots(problemsHolder, library, OrderRootType.CLASSES, "classes", ProjectStructureProblemType.error("library-invalid-classes-path"));
        String libraryName = library.getName();
        if (libraryName == null || !libraryName.startsWith("Maven: ")) {
            this.reportInvalidRoots(problemsHolder, library, OrderRootType.SOURCES, "sources", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
            this.reportInvalidRoots(problemsHolder, library, JavadocOrderRootType.getInstance(), "javadoc", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
        }
    }

    private void reportInvalidRoots(ProjectStructureProblemsHolder problemsHolder, LibraryEx library, OrderRootType type, String rootName, ProjectStructureProblemType problemType) {
        List<String> invalidUrls = library.getInvalidRootUrls(type);
        if (!invalidUrls.isEmpty()) {
            String description = LibraryProjectStructureElement.createInvalidRootsDescription(invalidUrls, rootName, library.getName());
            PlaceInProjectStructure place = this.createPlace();
            String message = ProjectBundle.message((String)"project.roots.error.message.invalid.roots", (Object[])new Object[]{rootName, invalidUrls.size()});
            ProjectStructureProblemDescription.ProblemLevel level = library.getTable().getTableLevel().equals("project") ? ProjectStructureProblemDescription.ProblemLevel.PROJECT : ProjectStructureProblemDescription.ProblemLevel.GLOBAL;
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message, description, place, problemType, level, Collections.singletonList(new RemoveInvalidRootsQuickFix(library, type, invalidUrls)), true));
        }
    }

    private static String createInvalidRootsDescription(List<String> invalidClasses, String rootName, String libraryName) {
        StringBuilder buffer = new StringBuilder();
        String name = StringUtil.escapeXml((String)libraryName);
        buffer.append("Library ");
        if (Registry.is((String)"ide.new.project.settings")) {
            buffer.append("<a href='http://library/").append(name).append("'>").append(name).append("</a>");
        } else {
            buffer.append("'").append(name).append("'");
        }
        buffer.append(" has broken " + rootName + " " + StringUtil.pluralize((String)"path", (int)invalidClasses.size()) + ":");
        for (String url : invalidClasses) {
            buffer.append("<br>&nbsp;&nbsp;");
            buffer.append(PathUtil.toPresentableUrl((String)url));
        }
        return XmlStringUtil.wrapInHtml((CharSequence)buffer);
    }

    @NotNull
    private PlaceInProjectStructure createPlace() {
        Project project = this.myContext.getProject();
        PlaceInProjectStructureBase placeInProjectStructureBase = new PlaceInProjectStructureBase(project, ProjectStructureConfigurable.getInstance(project).createProjectOrGlobalLibraryPlace(this.myLibrary), this);
        if (placeInProjectStructureBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement", "createPlace"));
        }
        return placeInProjectStructureBase;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryProjectStructureElement)) {
            return false;
        }
        return this.getSourceOrThis() == ((LibraryProjectStructureElement)o).getSourceOrThis();
    }

    public ActionCallback navigate() {
        return this.createPlace().navigate();
    }

    @NotNull
    private Library getSourceOrThis() {
        InvocationHandler invocationHandler = Proxy.isProxyClass(this.myLibrary.getClass()) ? Proxy.getInvocationHandler(this.myLibrary) : null;
        Library realLibrary = invocationHandler instanceof ModuleEditor.ProxyDelegateAccessor ? (Library)((ModuleEditor.ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate() : this.myLibrary;
        Library source = realLibrary instanceof LibraryImpl ? ((LibraryImpl)realLibrary).getSource() : null;
        Library library = source != null ? source : this.myLibrary;
        if (library == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement", "getSourceOrThis"));
        }
        return library;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.getSourceOrThis());
    }

    @Override
    public boolean shouldShowWarningIfUnused() {
        LibraryTable libraryTable = this.myLibrary.getTable();
        if (libraryTable == null) {
            return false;
        }
        return "project".equals(libraryTable.getTableLevel());
    }

    @Override
    public ProjectStructureProblemDescription createUnusedElementWarning() {
        List<ConfigurationErrorQuickFix> fixes = Arrays.asList(new AddLibraryToDependenciesFix(), new RemoveLibraryFix(), new RemoveAllUnusedLibrariesFix());
        String name = StringUtil.escapeXml((String)this.myLibrary.getName());
        String libraryName = Registry.is((String)"ide.new.project.settings") ? "<a href='http://library/" + name + "'>" + name + "</a>" : "'" + name + "'";
        return new ProjectStructureProblemDescription("Library " + libraryName + " is not used", null, this.createPlace(), ProjectStructureProblemType.unused("unused-library"), ProjectStructureProblemDescription.ProblemLevel.PROJECT, fixes, false);
    }

    @Override
    public String getPresentableName() {
        return "Library '" + this.myLibrary.getName() + "'";
    }

    @Override
    public String getTypeName() {
        return "Library";
    }

    @Override
    public String getId() {
        return "library:" + this.myLibrary.getTable().getTableLevel() + ":" + this.myLibrary.getName();
    }

    private class RemoveAllUnusedLibrariesFix
    extends ConfigurationErrorQuickFix {
        private RemoveAllUnusedLibrariesFix() {
            super("Remove All Unused Libraries");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable configurable = BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), "project");
            Library[] libraries = configurable.getModelProvider().getModifiableModel().getLibraries();
            ArrayList<LibraryProjectStructureElement> toRemove = new ArrayList<LibraryProjectStructureElement>();
            for (Library library : libraries) {
                LibraryProjectStructureElement libraryElement = new LibraryProjectStructureElement(LibraryProjectStructureElement.this.myContext, library);
                if (!LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().getUsages(libraryElement).isEmpty()) continue;
                toRemove.add(libraryElement);
            }
            configurable.removeLibraries(toRemove);
        }
    }

    private class RemoveLibraryFix
    extends ConfigurationErrorQuickFix {
        private RemoveLibraryFix() {
            super("Remove Library");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), LibraryProjectStructureElement.this.myLibrary.getTable().getTableLevel()).removeLibrary(LibraryProjectStructureElement.this);
        }
    }

    private class AddLibraryToDependenciesFix
    extends ConfigurationErrorQuickFix {
        private AddLibraryToDependenciesFix() {
            super("Add to Dependencies...");
        }

        @Override
        public void performFix() {
            LibraryEditingUtil.showDialogAndAddLibraryToDependencies(LibraryProjectStructureElement.this.myLibrary, LibraryProjectStructureElement.this.myContext.getProject(), false);
        }
    }

    private class RemoveInvalidRootsQuickFix
    extends ConfigurationErrorQuickFix {
        private final Library myLibrary;
        private final OrderRootType myType;
        private final List<String> myInvalidUrls;

        public RemoveInvalidRootsQuickFix(Library library, OrderRootType type, List<String> invalidUrls) {
            super("Remove invalid " + StringUtil.pluralize((String)"root", (int)invalidUrls.size()));
            this.myLibrary = library;
            this.myType = type;
            this.myInvalidUrls = invalidUrls;
        }

        @Override
        public void performFix() {
            LibraryTable.ModifiableModel libraryTable = LibraryProjectStructureElement.this.myContext.getModifiableLibraryTable(this.myLibrary.getTable());
            if (libraryTable instanceof LibrariesModifiableModel) {
                for (String invalidRoot : this.myInvalidUrls) {
                    ExistingLibraryEditor libraryEditor = ((LibrariesModifiableModel)libraryTable).getLibraryEditor(this.myLibrary);
                    libraryEditor.removeRoot(invalidRoot, this.myType);
                }
                LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().queueUpdate(LibraryProjectStructureElement.this);
                final ProjectStructureConfigurable structureConfigurable = ProjectStructureConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject());
                LibraryProjectStructureElement.this.navigate().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        NamedConfigurable configurable = structureConfigurable.getConfigurableFor(RemoveInvalidRootsQuickFix.this.myLibrary).getSelectedConfigurable();
                        if (configurable instanceof LibraryConfigurable) {
                            ((LibraryConfigurable)configurable).updateComponent();
                        }
                    }
                });
            }
        }
    }
}

