/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Product {
    private final String myName;
    private final Set<String> myCodes;
    private final List<UpdateChannel> myChannels;

    public Product(Element node) {
        this.myName = node.getAttributeValue("name");
        this.myCodes = new LinkedHashSet<String>();
        this.myChannels = new ArrayList<UpdateChannel>();
        List codes = node.getChildren("code");
        for (Object code : codes) {
            this.myCodes.add(((Element)code).getValue());
        }
        List channels = node.getChildren("channel");
        for (Object channel : channels) {
            this.myChannels.add(new UpdateChannel((Element)channel));
        }
    }

    public boolean hasCode(String code) {
        return this.myCodes.contains(code);
    }

    @Nullable
    public UpdateChannel findUpdateChannelById(String id) {
        for (UpdateChannel channel : this.myChannels) {
            if (!id.equals(channel.getId())) continue;
            return channel;
        }
        return null;
    }

    @NotNull
    public List<UpdateChannel> getChannels() {
        List<UpdateChannel> list = this.myChannels;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/Product", "getChannels"));
        }
        return list;
    }

    public String getName() {
        return this.myName;
    }

    public List<String> getAllChannelIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (UpdateChannel channel : this.myChannels) {
            result.add(channel.getId());
        }
        return result;
    }
}

