/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginAdvertiserEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.type.associations.detected");
    private final Project myProject;
    private final EditorNotifications myNotifications;
    private final Set<String> myEnabledExtensions = new HashSet<String>();

    public PluginAdvertiserEditorNotificationProvider(Project project, EditorNotifications notifications) {
        this.myProject = project;
        this.myNotifications = notifications;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider", "createNotificationPanel"));
        }
        if (file.getFileType() != PlainTextFileType.INSTANCE) {
            return null;
        }
        String extension = file.getExtension();
        String fileName = file.getName();
        if (extension != null && this.isIgnored("*." + extension) || this.isIgnored(fileName)) {
            return null;
        }
        PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
        if (knownExtensions != null) {
            EditorNotificationPanel panel;
            EditorNotificationPanel editorNotificationPanel = panel = extension != null ? this.createPanel("*." + extension, knownExtensions) : null;
            if (panel != null) {
                return panel;
            }
            return this.createPanel(fileName, knownExtensions);
        }
        return null;
    }

    private boolean isIgnored(String extension) {
        return this.myEnabledExtensions.contains(extension) || UnknownFeaturesCollector.getInstance(this.myProject).isIgnored(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
    }

    private EditorNotificationPanel createPanel(String extension, PluginsAdvertiser.KnownExtensions knownExtensions) {
        Set<PluginsAdvertiser.Plugin> plugins = knownExtensions.find(extension);
        if (plugins != null && !plugins.isEmpty()) {
            return this.createPanel(extension, plugins);
        }
        return null;
    }

    @Nullable
    private EditorNotificationPanel createPanel(final String extension, final Set<PluginsAdvertiser.Plugin> plugins) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText("Plugins supporting " + extension + " files are found");
        final IdeaPluginDescriptor disabledPlugin = PluginsAdvertiser.getDisabledPlugin(plugins);
        if (disabledPlugin != null) {
            panel.createActionLabel("Enable " + disabledPlugin.getName() + " plugin", new Runnable(){

                @Override
                public void run() {
                    PluginAdvertiserEditorNotificationProvider.this.myEnabledExtensions.add(extension);
                    PluginAdvertiserEditorNotificationProvider.this.myNotifications.updateAllNotifications();
                    PluginsAdvertiser.enablePlugins(PluginAdvertiserEditorNotificationProvider.this.myProject, Collections.singletonList(disabledPlugin));
                }
            });
        } else if (PluginAdvertiserEditorNotificationProvider.hasNonBundledPlugin(plugins)) {
            panel.createActionLabel("Install plugins", new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((Task)new Task.Modal(null, "Search for plugins in repository", true){
                        private final Set<PluginDownloader> myPlugins;
                        private List<IdeaPluginDescriptor> myAllPlugins;
                        {
                            this.myPlugins = new HashSet<PluginDownloader>();
                        }

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider$2$1", "run"));
                            }
                            try {
                                this.myAllPlugins = RepositoryHelper.loadPluginsFromRepository(indicator);
                                for (IdeaPluginDescriptor loadedPlugin : this.myAllPlugins) {
                                    if (!plugins.contains(new PluginsAdvertiser.Plugin(loadedPlugin.getPluginId(), null, false))) continue;
                                    this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }

                        public void onSuccess() {
                            PluginsAdvertiserDialog advertiserDialog = new PluginsAdvertiserDialog(null, this.myPlugins.toArray(new PluginDownloader[this.myPlugins.size()]), this.myAllPlugins);
                            advertiserDialog.show();
                            if (advertiserDialog.isOK()) {
                                PluginAdvertiserEditorNotificationProvider.this.myEnabledExtensions.add(extension);
                                PluginAdvertiserEditorNotificationProvider.this.myNotifications.updateAllNotifications();
                            }
                        }
                    });
                }
            });
        } else if (PluginsAdvertiser.hasBundledPluginToInstall(plugins) != null) {
            if (PropertiesComponent.getInstance().isTrueValue("ignoreUltimateEdition")) {
                return null;
            }
            panel.setText(extension + " files are supported by " + "IntelliJ IDEA Ultimate Edition");
            panel.createActionLabel("Check IntelliJ IDEA Ultimate Edition", new Runnable(){

                @Override
                public void run() {
                    PluginAdvertiserEditorNotificationProvider.this.myEnabledExtensions.add(extension);
                    PluginsAdvertiser.openDownloadPage();
                }
            });
            panel.createActionLabel("Do not suggest Ultimate Edition", new Runnable(){

                @Override
                public void run() {
                    PropertiesComponent.getInstance().setValue("ignoreUltimateEdition", "true");
                    PluginAdvertiserEditorNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
        } else {
            return null;
        }
        panel.createActionLabel("Ignore extension", new Runnable(){

            @Override
            public void run() {
                UnknownFeaturesCollector.getInstance(PluginAdvertiserEditorNotificationProvider.this.myProject).ignoreFeature(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
                PluginAdvertiserEditorNotificationProvider.this.myNotifications.updateAllNotifications();
            }
        });
        return panel;
    }

    private static boolean hasNonBundledPlugin(Set<PluginsAdvertiser.Plugin> plugins) {
        for (PluginsAdvertiser.Plugin plugin : plugins) {
            if (plugin.myBundled) continue;
            return true;
        }
        return false;
    }

    private static UnknownFeature createExtensionFeature(String extension) {
        return new UnknownFeature(FileTypeFactory.FILE_TYPE_FACTORY_EP.getName(), extension);
    }
}

